C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine xsd_xy (iunit, nsi, nf, times, IX1, IY1,
     1                   XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI, limin, limax,
     3                   dimin, dimax, xyscl, notrp, verbos,
     4                   lidel, didel, RC, noedge)

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>


c declare variables picked up by implicit none

      integer iunit, nsi, nf, ix1, iy1, ndi, nli,j ,i
      integer il, nl, iwrn, jj, ip, nt, ii

      real dx, dy, xyscl, tmin, tmax, cx, cy, aline, xline
      real cxt, cyt, bxt, byt, cdpx, cdpy, val

      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT

      real       times (ndi, nli)

      integer    minX, maxX, minY, maxY, lidel, didel
      integer    limin, limax, dimin, dimax, LI, DI
      character  junk * 80, keywrd * 9, tmp * 10, tag * 1
      real       timj, UnitSmp, OffsetSmp
      logical    xsd, flat, xsdn, notrp, verbos, RC, noedge
      
      do  j = 1, nli
          do  i = 1, ndi
              times (i,j) = 0.
          enddo
      enddo

      rewind iunit
 
      read (iunit, '(a1)') tag
 
      if (tag .eq. 'U') then
         xsd  = .true.
         xsdn = .false.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is xsd pick format'
         write(LERR,*)'File is xsd pick format'
         write(LER,*)' '
         write(LERR,*)' '
      elseif (tag .eq. 'N') then
         xsd  = .false.
         xsdn = .true.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is extended xsd pick format'
         write(LERR,*)'File is extended xsd pick format'
         write(LER,*)' '
         write(LERR,*)' '
      else
         xsd  = .false.
         xsdn = .false.
         flat = .true.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is simple 2-col format (rec time)'
         write(LERR,*)'File is simple 2-col format (rec time)'
         write(LER,*)' '
         write(LERR,*)' '
      endif
 
      rewind iunit

      maxX = -999999999
      minX =  999999999
      maxY = -999999999
      minY =  999999999
      tmin = 999999999.
      tmax = -999999999.

      IF (flat) then

         il = 0
         nl = 0

         Do While (1.eq.1)

             read (iunit, '(a80)', end=10, err=666) junk

             go to 12
10           continue
 
             if (il .eq. 0) then
             write(LERR,*)' '
             write(LERR,*)'ERROR in tim2hed3d:'
             write(LERR,*)'Hit end of file without reading any picks'
             write(LERR,*)'within survey coordinates'
             write(LER ,*)' '
             write(LER ,*)'ERROR in tim2hed3d:'
             write(LER ,*)'Hit end of file without reading any picks'
             write(LER ,*)'within survey coordinates'
             stop 666
             else
             write(LERR,*)' '
             write(LERR,*)'Return from xsd file reader:'
             write(LERR,*)'Found ',il,' picks within survey coordinates'
             go to 999
             endif
 
12           continue
 
             nl = nl + 1

             call fsscnf (junk,'%f %f %f', CX, CY, timj)

             IWRN = 0

             IF ( RC ) THEN

                aline = CX
                xline = CY
                LI = (aline - limin) / lidel + 1
                DI = (xline - dimin) / didel + 1
                IF (LI .LT.     1) IWRN = 1
                IF (LI .GT.   NLI) IWRN = 1
                IF (DI .LT.     1) IWRN = 1
                IF (DI .GT.   NDI) IWRN = 1
                IF (IWRN .eq. 0) THEN
                   il = il + 1
                   jj = LI
                   ii = DI
                   times (ii, jj) = nint ( timj )
                ENDIF

             ELSE

                CX = xyscl * CX
                CY = xyscl * CY
                if (CX .ge. maxX) maxX = CX
                if (CX .le. minX) minX = CX
                if (CY .ge. maxY) maxY = CY
                if (CY .le. minY) minY = CY
                if (timj .le. tmin) tmin = timj
                if (timj .ge. tmax) tmax = timj
                CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                    IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                    DX, DY, NDI, NLI)
 
                IF (LI .LT. limin) IWRN = 1
                IF (LI .GT. limax) IWRN = 1
                IF (DI .LT. dimin) IWRN = 1
                IF (DI .GT. dimax) IWRN = 1
                IF (IWRN .eq. 0) THEN
                   il = il + 1
                   jj = li - limin + 1
                   ii = di - dimin + 1
                   times (ii, jj) = nint ( timj )
                ENDIF

             ENDIF
  

         Enddo


      ELSEIF (xsd) THEN

         il = 0
         nl = 0

         do while (1.eq.1)
            read(iunit,'(a80)',end=999,err=666)junk
            read(junk,'(a1)')keywrd
            if(keywrd(1:1).eq.'S')then
               go to 20
            endif           
         enddo

20       continue

         il = 0
         Do While (1.eq.1)
            read(iunit,'(a80)',end=21,err=666)junk
            read(junk,'(a1)')keywrd
            if(keywrd(1:1).ne.'S')then
               call fsscnf (junk,'%f %f %f', CX, CY, timj)
               nl = nl + 1

               IWRN = 0


               IF ( RC ) THEN

                  LI = (CX - limin) / lidel + 1
                  DI = (CY - dimin) / didel + 1
                  IF (LI .LT.     1) IWRN = 1
                  IF (LI .GT.   NLI) IWRN = 1
                  IF (DI .LT.     1) IWRN = 1
                  IF (DI .GT.   NDI) IWRN = 1
                  IF (IWRN .eq. 0) THEN
                     il = il + 1
                     jj = LI
                     ii = DI
                     times (ii, jj) = nint ( timj )
                  ENDIF

               ELSE


                  CX = xyscl * CX
                  CY = xyscl * CY
                  if (CX .ge. maxX) maxX = CX
                  if (CX .le. minX) minX = CX
                  if (CY .ge. maxY) maxY = CY
                  if (CY .le. minY) minY = CY
                  if (timj .le. tmin) tmin = timj
                  if (timj .ge. tmax) tmax = timj
                  CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                 IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT,YYT,
     2                 DX, DY, NDI, NLI)
 
                  IF (LI .LT. limin) IWRN = 1
                  IF (LI .GT. limax) IWRN = 1
                  IF (DI .LT. dimin) IWRN = 1
                  IF (DI .GT. dimax) IWRN = 1
                  IF (IWRN .eq. 0) THEN
                     il = il + 1
                     jj = li - limin + 1
                     ii = di - dimin + 1
                     times (ii, jj) = nint ( timj )
                  ENDIF

               ENDIF
 
            endif
         Enddo

21       continue

             if (il .eq. 0) then
             write(LERR,*)' '
             write(LERR,*)'ERROR in tim2hed3d:'
             write(LERR,*)'Hit end of file without reading any picks'
             write(LERR,*)'within survey coordinates'
             write(LER ,*)' '
             write(LER ,*)'ERROR in tim2hed3d:'
             write(LER ,*)'Hit end of file without reading any picks'
             write(LER ,*)'within survey coordinates'
             stop 666
             else
             write(LERR,*)' '
             write(LERR,*)'Return from xsd file reader:'
             write(LERR,*)'Found ',il,' picks within survey coordinates'
             go to 999
             endif

      ELSEIF (xsdn) THEN
 
         i = 0
         DO  while (1.eq.1)
             read(iunit,'(a80)',end=33,err=666)junk
             keywrd = junk(1:9)

             if ( keywrd .eq. 'OffsetSmp' )
     :            call fsscnf (junk,'%s %f',tmp,OffsetSmp)
             if ( keywrd .eq. 'UnitSmp' )
     :            call fsscnf (junk,'%s %f',tmp,UnitSmp)

             i  = i + 1
             ip = 0
             if (keywrd .eq. 'Record') then
                 do while (1.eq.1)
                    read(iunit,'(a80)',end=30,err=666)junk
                    keywrd = junk(1:6)
                    if (keywrd(1:4) .eq. 'Pick') go to 30
                    if     (keywrd .eq. 'CDPBCX') then
                        call fsscnf (junk,'%s %f',tmp,cdpx)
                        if (cdpx .ne. 0.0) ip = ip + 1
                    elseif (keywrd .eq. 'CDPBCY') then
                        call fsscnf (junk,'%s %f',tmp,cdpy)
                        if (cdpy .ne. 0.0) ip = ip + 1
                    elseif (keywrd .eq. 'Sample') then
                        call fsscnf (junk,'%s %f',tmp,val)
                        timj = val * UnitSmp + OffsetSmp
c	write(*,*) 'timj = ',timj
                    endif
                 enddo
30               continue
                 if (ip .ne. 2) then
                    write(LERR,*)'Bad pick: encountered zero XY value'
                    write(LERR,*)'in file at line ',i,' Check pick file'
                    write(LERR,*)'for valid CDPBCX & CDPBCY values'
                    stop 
                 endif
                 nl = nl + 1
                 CX = xyscl * cdpx
                 CY = xyscl * cdpy
                 if (CX .ge. maxX) maxX = CX
                 if (CX .le. minX) minX = CX
                 if (CY .ge. maxY) maxY = CY
                 if (CY .le. minY) minY = CY
                 if (timj .le. tmin) tmin = timj
                 if (timj .ge. tmax) tmax = timj
                 CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                        IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2                        DX, DY, NDI, NLI)
 
                 IF (LI .LT. limin) IWRN = 1
                 IF (LI .GT. limax) IWRN = 1
                 IF (DI .LT. dimin) IWRN = 1
                 IF (DI .GT. dimax) IWRN = 1
 
                 IF (IWRN .eq. 0) THEN
 
                    il = il + 1
                    jj = li - limin + 1
                    ii = di - dimin + 1
                    times (ii, jj) = nint ( timj )
 
                 ENDIF

             endif
         ENDDO

33       continue
         nt = i


      ENDIF

      go to 999
 
666   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in tim2hed3d:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nl,' line was:',junk
      write(LER ,*)' '
      write(LER ,*)'ERROR in tim2hed3d:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nl,' line was:',junk
 
999   continue

 
      write(LERR,*)' '
      write(LERR,*)'Minimum X-coord= ',minX
      write(LERR,*)'Maximum X-coord= ',maxX
      write(LERR,*)'Minimum Y-coord= ',minY
      write(LERR,*)'Maximum Y-coord= ',maxY
      write(LERR,*)'Minimum time= ',tmin
      write(LERR,*)'Maximum time= ',tmax
      write(LERR,*)' '
c-----
c  do 2Dx2D interpolation of the input times
c-----
      if (notrp) then
          write(LERR,*)'No horizon file interpolation'
          write(LER ,*)'No horizon file interpolation'
          return
      else
          write(LERR,*)'Horizon file interpolation of zeros'
          write(LER ,*)'Horizon file interpolation of zeros'
      endif
 
      if ( noedge ) then
         write(LERR,*)'Interpolating out to survey edges'
         write(LER ,*)'Interpolating out to survey edges'
         call trp2d (1, nli, 1, ndi, nli, ndi, times)
      else
         write(LERR,*)'No interpolation out to survey edges'
         write(LER ,*)'No interpolation out to survey edges'
         call trp2de (1, nli, 1, ndi, nli, ndi, times)
      endif


c      do  j = 1, nli
c      do  i = 1, ndi
c          write(10,*)j,i,times(i,j)
c      enddo
c       write(10,777)
c 777   format()
c      enddo
c     if (nli .gt. 0) stop

      return

      end
