C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine limits (x, l1, l2, n, thresh)

#include <f77/iounit.h>

c   determine integer limits at a specific fraction of the maximum
c   of a vector, tresh

      real    x(*), thresh
      integer l1, l2, n


c-----------------
c find maximum
      call maxv (x, 1, xmax, index, n)

      xth = thresh * xmax

      if (xth .eq. 0.0) then
         l1 = 1
         l2 = n
         write(LERR,*)'Low/High index= ',l1,l2
         return
      endif

c-----------------
c  count upwards

      do  100  i = n, index, -1

          if (xth .lt. x(i)) then
             l2 = i+1
             go to 150
          endif
100   continue
 
150   continue
c-----------------
c  count downwards

      do  200  i = 1, index

          if (xth .lt. x(i)) then
             l1 = i-1
             go to 500
          endif
200   continue

500   continue


      write(LERR,*)'Low/High index= ',l1,l2
      return
      end
