C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine zone (nsamp, var1, var2, xplot1, xplot2, cof,
     1                 first, reverse, YX, XY, logtr, logsa,
     2                 itrc, luqci, luqco, xmin, xmax, ymin, ymax,
     3                 luqce, EOD, ntap1, ntap2)

#include <f77/iounit.h>

       character ntap1*(*), ntap2*(*)
      integer    nsamp, logtr, logsa, itrc, luqci, luqco, luqce
      real       var1 (*), var2 (*), xplot1 (*), xplot2 (*)
      real       cof  (2,4)
      real       xmin, xmax, ymin, ymax
      logical    first, EOD, reverse, YX, XY(4)

      if (first) then
c---
c  Lines 1 and 2 are Y-limits of the form Y = cof11 * X + cof21 and
c  Y = cof12 * X + cof22
c  Lines 2 and 3 are X-limits form X = cof13 * Y + cof23 and 
c  X = cof14 * Y + cof24
c---
         first = .false.
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'After sorting the coefs for the 4 lines:'
         write(LERR,*)' Y = cof11 * X  +  cof21'
         write(LERR,*)' Y = cof12 * X  +  cof22'
         write(LERR,*)' X = cof13 * Y  +  cof23'
         write(LERR,*)' X = cof14 * Y  +  cof24'
         write(LERR,*)' '
         write(LERR,*)'   Slope     Intercept'
         write(LERR,*)' '
         write(LERR,*)'1: cof(1,1), cof(2,1)= ',cof(1,1), cof(2,1)
         write(LERR,*)'2: cof(1,2), cof(2,2)= ',cof(1,2), cof(2,2)
         write(LERR,*)'3: cof(1,3), cof(2,3)= ',cof(1,3), cof(2,3)
         write(LERR,*)'4: cof(1,4), cof(2,4)= ',cof(1,4), cof(2,4)
         write(LERR,*)' '
         write(LERR,*)'e.g. a square grid will look something like:'
         write(LERR,*)' '
         write(LERR,*)'     y     '
         write(LERR,*)'  3222222  '
         write(LERR,*)'  3  y  4  '
         write(LERR,*)'  3  y  4  '
         write(LERR,*)'xx3xx0xx4xx'
         write(LERR,*)'  3  y  4  '
         write(LERR,*)'  3  y  4  '
         write(LERR,*)'  1111114  '
         write(LERR,*)'     y     '
         write(LERR,*)' '
         write(LERR,*)'for lines 1,2,3,4'
         write(LERR,*)' '
         lc1 = lenth (ntap1)
         lc2 = lenth (ntap2)
         if (luqci .gt. 0) then
             write(luqci,*)'"Data Set X: ',ntap1(1:lc1),'"'
             write(luqci,*)'"Data Set Y: ',ntap2(1:lc2),'"'
             write(luqci,*)'"Input XYs'
         endif
         if (luqco .gt. 0) then
             write(luqco,*)'"Data Set X: ',ntap1(1:lc1),'"'
             write(luqco,*)'"Data Set Y: ',ntap2(1:lc2),'"'
             write(luqco,*)'"Filtered XYs'
         endif
      endif

      call vclr (xplot1, 1, nsamp)
      call vclr (xplot2, 1, nsamp)

      DO  i = 1, nsamp

          X = var1 (i)
          Y = var2 (i)

          if (X .le. xmin) xmin = X
          if (X .ge. xmax) xmax = X
          if (Y .le. ymin) ymin = Y
          if (Y .ge. ymax) ymax = Y

          if (luqci .gt. 0) then
             if (mod(itrc,logtr) .eq. 0 .AND. mod(i,logsa) .eq. 0) then
                 write(luqci,*) X,Y
             endif
          endif

          y1 = X * cof(1,1) + cof(2,1)
          y2 = X * cof(1,2) + cof(2,2)
          x1 = Y * cof(1,3) + cof(2,3)
          x2 = Y * cof(1,4) + cof(2,4)

          IF ( reverse ) THEN

             if (X .ge. x1 .AND. X .le. x2 .AND.
     1           Y .ge. y1 .AND. Y .le. y2) then
                xplot1 (i) = 0.0
                xplot2 (i) = 0.0
             else
                xplot1 (i) = X
                xplot2 (i) = Y
             endif

          ELSE

             if (X .ge. x1 .AND. X .le. x2 .AND.
     1           Y .ge. y1 .AND. Y .le. y2) then
                xplot1 (i) = X
                xplot2 (i) = Y
             else
                xplot1 (i) = 0.0
                xplot2 (i) = 0.0
             endif

          ENDIF

          if (luqco .gt. 0) then
             if (mod(itrc,logtr) .eq. 0 .AND. mod(i,logsa) .eq. 0) then
                 write(luqco,*) xplot1(i), xplot2(i)
             endif
          endif

      ENDDO

      if ( EOD .AND. luqce .gt. 0 ) then
          y1min = xmin * cof(1,1) + cof(2,1)
          y1max = xmax * cof(1,1) + cof(2,1)
          y2min = xmin * cof(1,2) + cof(2,2)
          y2max = xmax * cof(1,2) + cof(2,2)
          x1min = ymin * cof(1,3) + cof(2,3)
          x1max = ymax * cof(1,3) + cof(2,3)
          x2min = ymin * cof(1,4) + cof(2,4)
          x2max = ymax * cof(1,4) + cof(2,4)
          write(luqce,*)'"Data Set X: ',ntap1(1:lc1),'"'
          write(luqce,*)'"Data Set Y: ',ntap2(1:lc2),'"'
          write(luqce,901)cof(1,1),cof(2,1)
901       format('"Lower Y= ',G9.3,' X + ',G9.3)
          write(luqce,*)xmin,y1min
          write(luqce,*)xmax,y1max
          write(luqce,888)
          write(luqce,902)cof(1,2),cof(2,2)
902       format('"Upper Y= ',G9.3,' X + ',G9.3)
          write(luqce,*)xmin,y2min
          write(luqce,*)xmax,y2max
          write(luqce,888)
          write(luqce,903)cof(1,3),cof(2,3)
903       format('"Lower X= ',G9.3,' Y + ',G9.3)
          write(luqce,*)x1min,ymin
          write(luqce,*)x1max,ymax
          write(luqce,888)
          write(luqce,904)cof(1,4),cof(2,4)
904       format('"Lower X= ',G9.3,' Y + ',G9.3)
          write(luqce,*)x2min,ymin
          write(luqce,*)x2max,ymax
          write(luqce,888)
888       format()
      endif

      return
      end
