C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DFASTG
C Description : RADIX 4 COMPLEX DISCRETE FFT WITHOUT UNSCRAMBLING
C Maintainer : A. T. WALDEN
C Version no.: 1
C Date : 28 JAN 88
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: USED BY DFORRT.
C 
C--
      SUBROUTINE DFASTG(XREAL,XIMAG,N,ITYPE)
C
C  DOUBLE PRECISION VERSION OF D.M. MONRO (1975) ``COMPLEX
C  DISCRETE FAST FOURIER TRANSFORM'',
C  ALG AS 83.2 APPL.STATS. (1975) VOL 24, 153-160.
C
C  RADIX 4 COMPLEX DISCRETE FAST FOURIER TRANSFORM WITHOUT
C  UNSCRAMBLING,SUITABLE FOR CONVOLUTIONS OR OTHER
C  APPLICATIONS WHICH DO NOT REQUIRE UNSCRAMBLING.
C  SUBROUTINE FASTF USES THIS ROUTINE FOR TRANSFORMATION
C  AND ALSO PROVIDES UNSCRAMBLING.
C
      IMPLICIT NONE
C
      INTEGER N, IFACA, ITYPE, K, IFCAB, LITLA, I0, I1, I2, I3
C
      DOUBLE PRECISION XREAL(N), XIMAG(N), ZERO, HALF, ONE, ONE5,
     * TWO, FOUR, PIE, Z, BCOS, BSIN, CW1, SW1, XS0, XS1, YS0, YS1,
     * XS2, XS3, YS2, YS3, X1, Y1, X2, Y2, X3, Y3, SW2, SW3,
     * CW3, CW2, TEMPR
C
      DATA ZERO, HALF, ONE, ONE5, TWO, FOUR
     * /0.0D0, 0.5D0, 1.0D0, 1.5D0, 2.0D0, 4.0D0/
      PIE=FOUR*ATAN(ONE)
      IFACA=N/4
      IF(ITYPE)3,19,5
C
C  IF THIS IS TO BE AN INVERSE TRANSFORM,CONJUGATE THE DATA
C
   3  DO 4 K=1,N
   4  XIMAG(K)=-XIMAG(K)
   5  IFCAB=IFACA*4
C
C  DO THE TRANSFORMS REQUIRED BY THIS STAGE
C
      Z=PIE/FLOAT(IFCAB)
      BCOS=-TWO*SIN(Z)**2
      BSIN=SIN(TWO*Z)
      CW1=ONE
      SW1=ZERO
      DO 10 LITLA=1,IFACA
      DO 8 I0=LITLA,N,IFCAB
C
C  THIS IS THE MAIN CALCULATION OF RADIX 4 TRANSFORMS
C
      I1=I0+IFACA
      I2=I1+IFACA
      I3=I2+IFACA
      XS0=XREAL(I0)+XREAL(I2)
      XS1=XREAL(I0)-XREAL(I2)
      YS0=XIMAG(I0)+XIMAG(I2)
      YS1=XIMAG(I0)-XIMAG(I2)
      XS2=XREAL(I1)+XREAL(I3)
      XS3=XREAL(I1)-XREAL(I3)
      YS2=XIMAG(I1)+XIMAG(I3)
      YS3=XIMAG(I1)-XIMAG(I3)
      XREAL(I0)=XS0+XS2
      XIMAG(I0)=YS0+YS2
      X1=XS1+YS3
      Y1=YS1-XS3
      X2=XS0-XS2
      Y2=YS0-YS2
      X3=XS1-YS3
      Y3=YS1+XS3
      IF(LITLA-1)19,6,7
   6  XREAL(I2)=X1
      XIMAG(I2)=Y1
      XREAL(I1)=X2
      XIMAG(I1)=Y2
      XREAL(I3)=X3
      XIMAG(I3)=Y3
      GOTO 8
C
C  MULTIPLY BY TWIDDLE FACTORS IF REQUIRED
C
   7  XREAL(I2)=X1*CW1+Y1*SW1
      XIMAG(I2)=Y1*CW1-X1*SW1
      XREAL(I1)=X2*CW2+Y2*SW2
      XIMAG(I1)=Y2*CW2-X2*SW2
      XREAL(I3)=X3*CW3+Y3*SW3
      XIMAG(I3)=Y3*CW3-X3*SW3
   8  CONTINUE
      IF(LITLA-IFACA) 9,10,19
C
C  CALC A NEW SET OF TWIDDLE FACTORS
C
   9  Z=CW1*BCOS-SW1*BSIN+CW1
      SW1=BCOS*SW1+BSIN*CW1+SW1
      TEMPR=ONE5-HALF*(Z*Z+SW1*SW1)
      CW1=Z*TEMPR
      SW1=SW1*TEMPR
      CW2=CW1*CW1-SW1*SW1
      SW2=TWO*CW1*SW1
      CW3=CW1*CW2-SW1*SW2
      SW3=CW1*SW2+CW2*SW1
 10   CONTINUE
      IF(IFACA-1)14,14,11
C
C  SET UP THE TRANSFORM SPLIT FOR THE NEXT STAGE
C
 11   IFACA=IFACA/4
      IF(IFACA)19,12,5
C
C  THIS IS THE CALCULATION OF A RADIX TWO STAGE
C
 12   DO 13 K=1,N,2
      TEMPR=XREAL(K)+XREAL(K+1)
      XREAL(K+1)=XREAL(K)-XREAL(K+1)
      XREAL(K)=TEMPR
      TEMPR=XIMAG(K)+XIMAG(K+1)
      XIMAG(K+1)=XIMAG(K)-XIMAG(K+1)
      XIMAG(K)=TEMPR
 13   CONTINUE
 14   IF(ITYPE)15,19,17
C
C  IF THIS WAS AN INVERSE TRANSFORM,CONJUGATE THE RESULT
C
 15   DO 16 K=1,N
 16   XIMAG(K)=-XIMAG(K)
      RETURN
C
C  IF THIS WAS A FORWARD TRANSFORM,SCALE THE RESULT
C
 17   Z=ONE/FLOAT(N)
      DO 18 K=1,N
      XREAL(K)=XREAL(K)*Z
      XIMAG(K)=XIMAG(K)*Z
 18   CONTINUE
 19   RETURN
      END
