C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DFORRT
C Description : ONE DIM FORWARD FFT (IN PLACE)
C Maintainer : A. T. WALDEN
C Version no.: 1
C Date : 28 JAN 88
C Component class : SUBROUTINE
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE DFORRT(X,M)
C
C  DOUBLE PRECISION VERSION OF D. M. MONRO (1976)
C  `` REAL DISCRETE FAST FOURIER TRANSFORM''
C  ALGORITHM AS 97 APPL.STATIST.(1976) VOL 25, 166-172.
C
C  FORWARD DISCRETE FOURIER TRANSFORM IN ONE DIMENSION OF
C  REAL DATA USING COMPLEX TRANSFORM SUBROUTINE FASTG
C
C  Y_m = (1/M) sum_{k=0}^{M-1} X_k exp(-i2 pi km/M) m=0,1,...M-1
C
C  X(M)   Real    input: the original real sequence
C                output: the complex result stored as follows:
C                        real parts of Y(0) to Y(M/2) are in
C                        X(1) to X(M/2+1). No imaginary part for
C                        m=0 or M/2, and imaginary parts of
C                        Y(1) to Y(M/2-1) in X(M/2+2) to X(M), i.e.,
C                        M/2 places above corresponding real parts.
C
C  M      Integer input: Length of transform (power of 2)
C                        Minimum length is 8, maximum is 2**21.
C
      IMPLICIT NONE
C
      INTEGER II, K, IPOW, M, N, JPOW, NN, NN1, NN2, KI, L, LI
C
      DOUBLE PRECISION X(M), ZERO, QUART, HALF, ONE, ONE5, TWO, FOUR,
     * PIE, Z, BCOS, BSIN, UN, VN, SAVE1, AN, BN, CN, DN, XN, YN
C
      DATA ZERO,QUART,HALF,ONE,ONE5,TWO,FOUR
     * /0.0D0,0.25D0,0.5D0,1.0D0,1.5D0,2.0D0,4.0D0/
C
C  CHECK FOR VALID TRANSFORM SIZE
C
      II=8
      DO 2 K=3,21
      IPOW=K
      IF(II-M) 1,3,1
  1   II=II*2
  2   CONTINUE
C
C  IF THIS POINT IS REACHED A SIZE ERROR HAS OCCURRED
C
      RETURN
  3   PIE=FOUR*ATAN(ONE)
C
C  SEPARATE ODD AND EVEN PARTS INTO TWO HALVES.
C  FIRST BIT REVERSE THE WHOLE ARRAY OF LENGTH M
C
      CALL DSCRAG(X,M,IPOW)
C
C  NEXT BIT REVERSE THE HALF ARRAYS SEPARATELY
C
      N=M/2
      JPOW=IPOW-1
      CALL DSCRAG(X,N,JPOW)
      CALL DSCRAG(X(N+1),N,JPOW)
C
C  NOW DO TRANSFORM: INCL. divide by N
C
      CALL DFASTG(X,X(N+1),N,1)
C
C UNSCRAMBLE
C
      CALL DSCRAG(X,N,JPOW)
      CALL DSCRAG(X(N+1),N,JPOW)
C
      NN=N/2
C
C  NOW UNRAVEL THE RESULT,FIRST THE SPECIAL CASES
C
      Z=HALF*(X(1)+X(N+1))
      X(N+1)=HALF*(X(1)-X(N+1))
      X(1)=Z
      NN1=NN+1
      NN2=NN1+N
      X(NN1)=HALF*X(NN1)
      X(NN2)=-HALF*X(NN2)
      Z=PIE/FLOAT(N)
      BCOS=-TWO*(SIN(Z/TWO)**2)
      BSIN=SIN(Z)
      UN=ONE
      VN=ZERO
      DO 4 K=2,NN
      Z=UN*BCOS+VN*BSIN+UN
      VN=VN*BCOS-UN*BSIN+VN
      SAVE1=ONE5-HALF*(Z*Z+VN*VN)
      UN=Z*SAVE1
      VN=VN*SAVE1
      KI=N+K
      L=N+2-K
      LI=N+L
      AN=QUART*(X(K)+X(L))
      BN=QUART*(X(KI)-X(LI))
      CN=QUART*(X(KI)+X(LI))
      DN=QUART*(X(L)-X(K))
      XN=UN*CN-VN*DN
      YN=UN*DN+VN*CN
      X(K)=AN+XN
      X(KI)=BN+YN
      X(L)=AN-XN
      X(LI)=YN-BN
  4   CONTINUE
      RETURN
      END
