C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DJTMEANA
C Description : CALCS COMPLEX MU (CMU) FOR THOMSON'S MEAN REMOVAL
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 2 DEC 87
C Component class : SUBROUTINE
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE DJTMEANA(N, NREQ, NREQMAX, K0, K1, UR, Y, 
     *   D, CMU, IFAULT)
C
C  COMPUTES ZERO FREQUENCY CONTRIBUTION BY THOMSON'S METHOD (1982)
C
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N        Integer   (i)      length of dpss sequence
C
C  NREQ     Integer   (i)      number of terms for FFT (e.g., 2**p)
C                              or Singleton-compatible length
C
C  NREQMAX  Integer   (i)      max permitted size of NREQ (e.g., 4096)
C                              (defines first dim of D, UR, Y in calling
C                              prog)
C
C  K0       Integer   (i)      minimum order for dpss (e.g., 0)
C
C  K1       Integer   (i)      maximum order for dpss (e.g., 5)
C
C  UR((NREQMAX/2)+1,K1-K0+1) Real (i)  dpswf in columns at Fourier 
C                                      freqs as defined by NREQ
C
C  Y((NREQMAX/2)+1,K1-K0+1) Complex (i) eigencoeffs at Fourier freqs
C                                       defined by NREQ, by column for
C                                       different orders of dpss
C
C  D((NREQMAX/2)+1,K1-K0+1) Real (i) weights at Fourier freqs defined
C                                    by NREQ, by column for different
C                                    orders of dpss
C
C  CMU    Complex (o)  complex mean mu at zero freq
C
C  IFAULT    Integer (o)   0: successful completion
C                          1: K0 < 0 or K1 > N-1
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C
      INTEGER K, K0, K1, KL, J, N, NREQ, NREQMAX, IFAULT
C
      DOUBLE PRECISION U20SUM, ZERO, UR((NREQMAX/2)+1, K1-K0+1),
     *  D((NREQMAX/2)+1,K1-K0+1), D1J
C
      DOUBLE COMPLEX CMU, Y((NREQMAX/2)+1,K1-K0+1)
C
      DATA ZERO/0.0D0/
C
      IFAULT=1
      IF(K0 .LT. 0 .OR. K1 .GT. N-1) RETURN  
      KL=K0+1
      K=K1-K0+1
      U20SUM=ZERO
      CMU=CMPLX(ZERO,ZERO)
      DO 20 J=1,K
C
C  SET THE WEIGHT
C
          D1J=D(1,J)
C
C  IF EVEN, UR IS NON-ZERO AND CONTRIBUTES TO REGRESSION
C
          IF(MOD(KL+J-2,2) .EQ. 0) THEN
                      CMU=CMU+ D1J*UR(1,J)* Y(1,J)
                      U20SUM=U20SUM+D1J*UR(1,J)*UR(1,J)
          END IF
 20   CONTINUE
C
C  ESTIMATE OF MEAN IS THE RATIO
C
      CMU=CMU/U20SUM
      IFAULT=0
      RETURN
      END

