C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DMOMENTS
C Description : CALCULATES POWER SUMS OF DEVIATIONS ABOUT THE MEAN
C Maintainer : A.T.WALDEN
C Version no.: 1
C Date : 3 DEC 1987
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE DMOMENTS(X,K,N,S1,S2,S3,S4,IFAULT)
C
C**************************************************************
C
C  ALGORITHM AS 52 APPL.STATIST.(1972) VOL 21,NO 2
C    (DOUBLE PRECISION VERSION)
C
C  ADDS A NEW VALUE,X,WHEN CALCULATING A MEAN, AND SUMS
C  OF POWERS OF DEVIATIONS.K INDICATES THE POWERS REQUIRED
C  AND MUST EQUAL 1,2,3 OR 4.ON EXIT,S1 IS THE NEW VALUE
C  OF THE MEAN,THE POWER SUMS ,AS INDICATED BY K,ARE IN
C  S2,S3 AND S4.N IS THE CURRENT NUMBER OF OBSERVATIONS.
C  IT MUST BE SET TO ZERO BEFORE THE FIRST ENTRY.
C
C**************************************************************
C
C X    real      input       value of latest observation
C K    integer   input       indicates the power sum required (1,2,3 or 4)
C N    integer   input       0 at first call, output from previous call
C                            subsequently
C               output       total number of values so far
C S1   real     output       the mean
C S2   real     output       sum of second power about mean
C S3   real     output       sum of third power about mean
C S4   real     output       sum of fourth power about mean
C IFAULT int    output       0:success
C                            1: K <0 or K > 5 or N < 0
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      DOUBLE PRECISION X,S1,S2,S3,S4,AN,AN1,DX,DX2
      DOUBLE PRECISION ZERO,WUN,TWO,THREE,FOUR,SIX
      DATA ZERO,WUN,TWO,THREE,FOUR,SIX/0.0D0,1.0D0,2.0D0,3.0D0,4.0D0,
     *6.0D0/
C
      IF(K.GT.0.AND.K.LT.5.AND.N.GE.0) GOTO 10
      IFAULT=1
      RETURN
 10   IFAULT=0
      N=N+1
      IF(N.GT.1) GOTO 20
      S1=X
      S2=ZERO
      S3=ZERO
      S4=ZERO
      RETURN
 20   AN=N
      AN1=AN-WUN
      DX=(X-S1)/AN
      DX2=DX*DX
      GOTO(60,50,40,30),K
 30   S4=S4-DX*(FOUR*S3-DX*(SIX*S2+AN1*(WUN+AN1**3)*DX2))
 40   S3=S3-DX*(THREE*S2-AN*AN1*(AN-TWO)*DX2)
 50   S2=S2+AN*AN1*DX2
 60   S1=S1+DX
      RETURN
      END
