C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DPSWFA
C Description : CALCS DISCRETE PROLATE SPHEROIDAL WAVE FUNCTION 
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 2 DEC 1987
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: SEE BELOW
C 
C--
      SUBROUTINE DPSWFA(N, NMAX, NREQ, NREQMAX, K0, K1, Z, X, U, UR, 
     * PAD, QFFT, IFAULT)
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  COMPUTES DISCRETE PROLATE SPHEROIDAL WAVE FUNCTION FROM DISCRETE
C  PROLATE SPHEROIDAL SEQUENCE.
C
C  FORMULA IS
C
C  U^k(N,W,f)=
C  epsilon(k) sum_{n=0}^{N-1} v_n^k(N,W) exp(-i 2 pi f(n-{N-1}/2))
C  where epsilon(k) is 1 for k=0,2,4,.. and i otherwise.
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  (i/o): input or output
C
C  N      Integer (i)    length of dpss
C
C  NMAX   Integer (i)    max length of dpss permitted (defines size of Z
C                        matrix in calling program)
C
C  NREQ   Integer (i)    power of 2 or alternate Singleton-factorable
C                        length for FFT
C
C  NREQMAX Int (i)       max length of FFT permitted (defines size of UR
C                        matrix in calling program)
C
C  K0     Integer (i)    minimum order for dpss (e.g., 0)
C
C  K1     Integer (i)    max order for dpss (e.g., 5)
C
C  Z(NMAX,K1-K0+1)  Real (i) the dpss of orders K0 to K1 in first (K1-K0+1)
C                        columns
C
C  X(NREQ) Real       workspace
C
C  U((NREQ/2)+1) Complex   workspace
C
C  UR((NREQMAX/2)+1,K1-K0+1)  Real (o)  the result: DPSWF at the Fourier 
C                        frequencies defined by the length NREQ, column
C                        by column for each dpss.
C
C  PAD     Logical (o)   if true, data padded with at least one zero
C
C  QFFT    Logical (o)   if true, NREQ a power of 2
C
C  IFAULT  Integer (o)   error indicator:
C                        0: successful completion
C                        1: NMAX < N or N < 2
C                        2: K0 < 0 or K1 > N-1
C                        3: failure in PADP2
C                        4: failure in COMTRAND2
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C
      INTEGER MFT, NREQ, KL, KU, K0, K1, K, J, N, NMAX, IF0, IF1,
     * N2, JJ, IFAULT, I, NREQMAX
C
      LOGICAL PCH, P2CH, PAD, QFFT
C
      DOUBLE PRECISION Z(NMAX, K1-K0+1), UR((NREQMAX/2)+1,K1-K0+1),
     * X(NREQ)
C
      DOUBLE COMPLEX U((NREQ/2)+1)
C
C  MAXIMUM NUMBER OF FREQUENCIES FOR DISCRETE FOURIER TRANSFORM OF
C  LENGTH NREQ. IF NREQ IS ODD, E.G. 7 THEN THERE ARE FOUR REAL 
C  PARTS AND THREE IMAGINARY PARTS. IF NREQ IS EVEN, E.G. 8, THEN THERE
C  ARE FIVE REAL PARTS AND THREE IMAGINARY PARTS.
C
c     write(0,*)'N,NMAX,NREQ,NREQMAX= ',N,NMAX,NREQ,NREQMAX
      IFAULT=1
      IF(NMAX .LT. N .OR. N .LT. 2) RETURN
      IFAULT=2
      IF(K0 .LT. 0 .OR. K1 .GT. N-1) RETURN
      MFT=(NREQ/2)+1
      N2=(NREQ+1)/2
      KL=K0+1
      KU=K1+1
      K=KU-KL+1
c     write(0,*)'K0,K1= ',K0,K1
C
C  CHECK WHETHER TO PAD WITH ZEROS AND WHETHER A POWER OF 2 
C
      PCH=.TRUE.
      P2CH=.TRUE.
C
      DO 1 J=1,K
         DO 5 I=1,N
  5          X(I)=Z(I,J)
         CALL PADP2(N, NREQ, X, PCH, PAD, P2CH, QFFT, IF0)
         IFAULT=3
         IF(IF0. NE. 0) RETURN
C
C  FOURIER TRANSFORM THE DPSS(J-1), SCALE BY EPSILON(K) AND TIME SHIFT
C  TO OBTAIN U(N,W;J-1)
C
      CALL COMTRAND2(X, U, N, NREQ, MFT, KL+J-1, QFFT, IF1) 
      IFAULT=4
      IF(IF1 .NE. 0) RETURN
C
C  U IS NOW REAL
C
         DO 10 JJ=1,N2
 10           UR(JJ,J)=REAL(U(JJ))
         IF(MOD(NREQ,2) .EQ. 0) UR(N2+1,J)=REAL(U(N2+1))
  1   CONTINUE
      IFAULT=0
      RETURN
      END
