C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : DSCRAG
C Description : DOES FFT UNSCRAMBLING ON DFORRT
C Maintainer : A. T. WALDEN
C Version no.: 1
C Date : 28 JAN 88
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE DSCRAG(XREAL,N,IPOW)
C
C  DOUBLE PRECISION VERSION OF D.M. MONRO (1975)
C  AS 83.4 ``SCRAM'' APPL.STATS., P159 MODIFIED
C  IN ACCORDANCE WITH D. M. MONRO (1976) APPL.
C  STATS. P168.
C
C  REQUIRED FOR ROUTINE DFORRT.
C
C  SUBROUTINE FOR UNSCRAMBLING FFT DATA
C
      IMPLICIT NONE
C
      INTEGER L(21), J(21), II, K, IPOW, KLOOP, KPOW, ITOP, JPOW,
     * J20, I, N
C
      DOUBLE PRECISION XREAL(N), TEMPR
C
      J(1)=1
      II=1
      DO 6 K=1,IPOW
      L(K)=II
      II=II*2
  6   CONTINUE
      KLOOP=1
      II=1
      KPOW=IPOW-1
      ITOP=2**KPOW
      JPOW=IPOW-2
C
C  PROPAGATE THE INITIAL VALUE FOR THE COUNTER FOR THIS
C  LOOP
C
  7   DO 8 K=KLOOP,JPOW
      J(K+1)=J(K)
  8   CONTINUE
C
C  J20 IS THE BIT REVERSE OF II
C
      J20=J(KPOW)
      DO 11 I=1,2
      IF(II-J20)9,10,10
C
C  PAIRWISE INTERCHANGE
C
  9   TEMPR=XREAL(II)
      XREAL(II)=XREAL(J20)
      XREAL(J20)=TEMPR
C
C  INCREMENT THE INNER LOOP
C
 10   J20=J20+ITOP
      II=II+1
 11   CONTINUE
      KLOOP=KPOW
C
C  INCREMENT AND TEST THE OUTER LOOPS
C
 12   J(KLOOP)=J(KLOOP)+L(KLOOP)
      IF(J(KLOOP)-L(KLOOP+1))7,7,13
 13   KLOOP=KLOOP-1
      IF(KLOOP)14,14,12
 14   RETURN
      END
