C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE  DTREND(N,AM,PH,SLP,IFL)
C
C	AM	: The amplitude spectrum.
C	PH	: The phase spectrum to be detrended.
C	SLP	: Slope of the linear phase trend on OUTPUT.
C	IFL	: Detrending switch  0 = No detrending.
C
C	This subroutine ignores the first and last points of the
C	phase spectrum when calculating the trend.  When the phase
C	correction is applied the first element (Zero frequency) is
C	not altered.
C
      DIMENSION AM(N),PH(N)
C
      N1=N-1                                                            
      CALL DRUM(N,PH)	!Ensure continuity of phase spectrum
      S1=0.0                                                            
      S2=0.0                                                            
      S3=0.0
      S4=0.0
      S5=0.0
      XK=1.0                                                            
      DO I=2,N1                                                      
         W=AM(I)
         Y=PH(I)
         WY=W*Y
         WXK=W*XK
         S1=S1+WY*XK
         S2=S2+WXK*XK
         S3=S3+WXK
         S4=S4+WY
         S5=S5+W
         XK=XK+1.0
      END DO
      SLP=(S1*S5-S4*S3)/(S2*S5-S3*S3)
C
      IF(IFL.EQ.0) RETURN
C
      S=SLP
      DO I=2,N
         PH(I)=PH(I)-S
         S=S+SLP
      END DO
C
      RETURN                                                            
C
      ENTRY RTREND(N,PH,SLP)                                            
      S=SLP                                                             
      DO I=2,N                                                       
         PH(I)=PH(I)+S
         S=S+SLP
      END DO
      RETURN                                                            
C
      ENTRY  DTREN(N,PH,SLP,IFL)
C     This entry ignores the amplitude spectrum.
      N1=N-1
      CALL DRUM(N,PH)	!Ensure continuity.
      S1=0.0
      S2=0.0
      S3=0.0
      S4=0.0
      AN2=FLOAT(N-2)
      XK=1.0
      DO I=2,N1
         Y=PH(I)
         S1=S1+Y*XK
         S2=S2+XK*XK
         S3=S3+XK
         S4=S4+Y
         XK=XK+1.0
      END DO
      SLP=(S1*AN2-S4*S3)/(S2*AN2-S3*S3)
C
      IF (IFL.EQ.0) RETURN
C
      S=SLP
      DO I=2,N
         PH(I)=PH(I)-S
         S=S+SLP
      END DO
C
      RETURN                                                            
C
      END                                                               
