C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
!
! Component name	: Fix Operator Time Zero
! Description 		: Generate sensible time zero in operator
! Maintainer		: Sue Raikes
! Version no.		: 1.1
! Date			: Feb 1988
! Component class 	: SUBROUTINE
! Source location 	: 
! Object location 	: 
! Documentn location 	: 
!
!% 
!% Optional additional information.	
!% 
	SUBROUTINE FOTZ(II,PWO,PHO,SA,TZA,TZO)
C
C	INPUT:
C		II .... Number of points in spectrum
C		PWO ... Operator power spectrum
C		PHO ... Operator phase spectrum
C		SA .... Operator sample interval
C		TZA ... Orig wavelet time zero
C
C	OUTPUT
C		PHO ... Whole sample time-shift removed
C		TZO ... Lead time for operator once fft'd
C	_______________________________________________________________________
C
	DIMENSION PWO(II),PHO(II),WT(513)

	N2=II-1
	SCON=3.141592654/FLOAT(N2)

	CALL DRUM(II,PHO)				!drum phase
c
c	set up for slope determination from 10:60Hz
C
	DF=500./(SA*N2)
	ID=INT(10./DF+1.2)
	LD=INT(60./DF+1.2)
	ND=LD-ID+1
	DO J=1,II
		WT(J)=SQRT(PWO(J))
	ENDDO
	ISL=0

	CALL DTREND(ND,WT(ID),PHO(ID),SLP,ISL)
C
C	now remove integral sample shift
C
	SHS=SLP/SCON
	ISH=INT(SHS)
	SLP=SCON*FLOAT(ISH)
	DO J=2,II
		PHO(J)=PHO(J)-SLP*(J-1)
	ENDDO
	
	TZO=(N2+ISH)*SA-TZA

999	CONTINUE
	RETURN
	END

