C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : GL_FTRD
C Description : Transforms time series into frequency domain
C Maintainer : S. DEREGOWSKI
C Version no.: 1
C Date : 1978
C Component class : SUBROUTINE
C Source location : GEOLIB:[GEOLIB.GL_LIB]
C Object location : GEOLIB:[GEOLIB]GL_LIB
C Documentation location : GRBS$DISK:[GEOLIB.TEXT.FFT]FFTPAK.TXT
C Category : FFT
C
C 
C Additional information:
C
C INPUT     N   -   transform window length in samples
C           KG  -   INTEGER output from GL_STWI
C           IR  -   ARRAY containing sin/cosine tables, output from GL_STWI
C           W2  -   ARRAY containing sin/cosine tables, output from GL_STWI
C	    C1  -   ARRAY - first half of series.
C           C2  -   ARRAY - second half of series.
C 
C OUTPUT    C1  -   ARRAY - Real part of tranformed array
C           C2  -   ARRAY - Imaginary part of transformed array
C          
C WORK      D   -   ARRAY of size N/2
C
C--
       SUBROUTINE FTRD1(N,KG,IR,W2,C1,C2,D)
       dimension  IR(N/2),W2(N/4+1),C1(N+1),C2(N+1),D(N/2)

c      write (0,*) ' FTRD1: N=',N, ' KG=',KG
c      write (0,*)(ir(ii),ii=1,n/2)

       N5=N/4
       N2=N5+N5
       N3=N+2
       N4=N2+1
       N6=N5+2
       RXN=1.0/FLOAT(N+N)
       S=SIN(6.2831853072*RXN)
       C=SQRT((1.-S)*(1.+S))
       N1=N+1
       DO1I=1,N2
       J=I+I
       D(I)=-RXN*C1(J-1)
 1     C1(I)=RXN*C1(J)
       DO8I=1,N2
       J=N1-I
       K=J-I
       C1(J)=RXN*C2(K+1)
 8     C2(J)=-RXN*C2(K)
       DO9I=1,N2
 9     C2(I)=D(I)
c     write(0,*)'into IDFT: N,KG ',N,KG
       CALL IDFT(N,KG,IR,W2,C1,C2)
c     write(0,*)'out of IDFT'
       DO2I=2,N2
       NI=N3-I
       X1I=C1(I)
       X1N=C1(NI)
       X2I=C2(I)
       X2N=C2(NI)
       C1(I)=X1I+X1N
       C2(I)=X2N-X2I
       C1(NI)=-X2I-X2N
 2     C2(NI)=X1N-X1I
       X=C1(1)
       Y=C2(1)
       C1(1)=X-Y
       C1(N1)=-X-Y
       C2(1)=0.0
       C2(N1)=0.0
       X=C1(N4)
       C1(N4)=-C2(N4)
       C2(N4)=-X
       J=2
       L=0
       M=1
       GOTO5
 3     M=M1
       IF(N5.LT.M)GOTO6
       J=M+M
       L=J-1
       I=J-1
       CS=W2(N6-M)
       SN=W2(M)
 4     IN=N3-I
       CO1=C1(IN)
       CO2=C2(IN)
       CE1=C1(I)
       CE2=C2(I)
       X=CE1*CS+CE2*SN
       Y=CE2*CS-CE1*SN
       C1(I)=0.5*(CO1+X)
       C2(I)=0.5*(CO2+Y)
       C1(IN)=0.5*(CO1-X)
       C2(IN)=0.5*(Y-CO2)
       IF(L.LT.I)GOTO3
 5     M1=M+1
       X=W2(N6-M1)
       Y=W2(M1)
       CS=C*X+S*Y
       SN=C*Y-S*X
       I=J
       GOTO4
 6     RETURN
       END
