C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Description : Computes power and phase spectra of a complex series
C Category : FFT
C
C 
C Additional information:
C
C
C INPUT     N  -   Length of arrays
C           X1 -   Real part of complex series (N+1 terms)
C           X2 -   Imaginary part of complex series (N+1 terms)
C
C OUTPUT    X1  -  Array containing N+1 terms of the power spectrum
C           X2  -  Array containing N+1 terms of the phase spectrum
C--
        SUBROUTINE PSPEC(N,X1,X2)
        DIMENSION X1(N+1),X2(N+1)
        XN=FLOAT(N+N)
        N1=N+1
        DO  I=1,N1
           A=X1(I)
           B=X2(I)
           X1(I)=XN*(A*A+B*B)
           X2(I)=ATAN2(B,A)
        ENDDO
        RETURN
        END
