C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SELEIGD(N, NDIM, MITS, PRECIS, D, E, E2, M, W, IND,
     * RV1, RV2, RV3, RV4, RV6, Z, IFAULT)
C
C  DETERMINES THOSE EIGENVECTORS OF A SYMMETRIC TRIDIAGONAL MATRIX
C  CORRESPONDING TO A SET OF ORDERED APPROXIMATE EIGENVALUES, USING
C  INVERSE ITERATIONS.
C
C  UP TO AND INCLUDING ''IFAULT = 0'' THE CODE IS NEW TO CONFORM TO
C  APPLIED STATISTICS STANDARDS. AFTER THIS THE CODE FOLLOWS SUBROUTINE
C  TINVIT IN B. T. Smith et al (1976) Matrix Eigensystem Routines ---
C  EISPACK Guide, Lecture Notes in Computer Science 6, Springer-Verlag, 
C  454-457, EXCEPT:
C
C  THE FOLLOWING CHANGES ARE MADE TO THE EISPACK ROUTINE TINVIT:
C    (1) ZERO, ONE, ONET3 ARE USED TO REPLACE 0.0, 1.0, 1.0E-3 IN TINVIT
C    (2) ZFLOAT REPLACE FLOAT IN TINVIT
C    (3) LINE '' IF (ITS .EQ. MITS) GOTO 830 '' REPLACES
C       '' IF (ITS .EQ. 5) GOTO 830 '' IN TINVIT
C    (4) PRECIS REPLACES MACHEP AND IFAULT REPLACES IERR IN TINVIT
C
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N       Integer     input      dimension of the matrix (N<NM)
C  NM      Integer     input      first dimension of Z in the calling
C                                 (sub)program, i.e., max possible N.
C  MITS    Integer     input      number of iterations allowed for
C                                 determining an eigenvector (typically 5).
C  PRECIS  Real        input      computational accuracy, defined as smallest
C                                 positive number such that 1+PRECIS>1
C  D       Real(N)     input      diagonal elements of tridiagonal matrix
C  E       Real(N)     input      E(2),...,E(N) contain subdiagonal
C                                 elements of symmetric tridiagonal matrix,
C                                 E(1) is arbitrary.
C  E2      Real(N)     input      E2(2),...,E2(N) contain squares of subdiag
C                                 elements of tridiagonal matrix with zeros
C                                 corresponding to negligible elements of E.
C                                 E(I) is considered negligible if it is not
C                                 larger than the product of PRECIS and the
C                                 sum of the magnitudes of D(I) and D(I-1).
C                                 E2(1) should contain 0.0 if the eigenvalues
C                                 are in ascending order, and 2.0 if in
C                                 descending order.
C  M       Integer     input      number of eigenvectors required
C  W       Real(M)    output      M eigenvalues in ascending order
C  IND     Integer(M) output      submatrix indices associated with corresp.
C                                 eigenvalues.
C  RV1     Real(N)  workspace
C  RV2     Real(N)  workspace
C  RV3     Real(N)  workspace
C  RV4     Real(N)  workspace
C  RV6     Real(N)  workspace
C  Z       Real(NM,M) output      holds M orthonormal eigenvectors of the
C                                 symmetric tridiagonal matrix corresponding
C                                 to the M eigenvalues in W.
C  IFAULT  Integer    output      0 : successful completion
C                                 if more than MITS iterations are required
C                                 to determine an eigenvector, subroutine
C                                 terminates the computation for that eigen
C                                 vector and sets IFAULT to -R where R is the 
C                                 index of the eigenvector. If this failure
C                                 occurs for more than one eigenvector, the
C                                 last occurrence is recorded in IFAULT.
C                                 Columns of Z are set to zero for failures.
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INTEGER I, J, M, N, P, Q, R, S, II, IP, JJ, NM, ITS, TAG,
     * IFAULT, GROUP, IND(M), MITS, NDIM
C
      DOUBLE PRECISION D(N), E(N), E2(N), W(M), Z(NDIM,M), RV1(N), 
     * RV2(N), RV3(N), RV4(N), RV6(N), U, V, UK, XU, X0, X1, EPS2, 
     * EPS3, EPS4, NORM, ORDER, PRECIS, ZFLOAT, ZERO, ONE, ONET3
C
      DATA ZERO,ONE,ONET3/0.0D0,1.0D0,1.0D-3/
C
      ZFLOAT(I)=DBLE(I)
C
      IFAULT=0
      IF(M .EQ. 0) GOTO 1001
      TAG=0
      ORDER=ONE-E2(1)
      Q=0
C
C  ESTABLISH AND PROCESS NEXT SUBMATRIX
C
100   P=Q+1
      DO 120 Q=P,N
            IF(Q .EQ. N) GOTO 140
            IF(E2(Q+1) .EQ. ZERO) GOTO 140
120   CONTINUE
C
C  FIND VECTORS BY INVERSE ITERATION
C
140   TAG=TAG+1
      S=0
C
      DO 920 R=1,M
            IF(IND(R) .NE. TAG) GOTO 920
            ITS=1
            X1=W(R)
            IF(S .NE. 0) GOTO 510
C
C  CHECK FOR ISOLATED ROOT
C
            XU=ONE
            IF(P .NE. Q) GOTO 490
            RV6(P)=ONE
            GOTO 870
490         NORM=ABS(D(P))
            IP=P+1
C
            DO 500 I=IP,Q
500           NORM=NORM+ABS(D(I))+ABS(E(I))
C
C  EPS2 IS THE CRITERION FOR GROUPING
C  EPS3 REPLACES ZERO PIVOTS AND EQUAL ROOTS ARE MODIFIED BY EPS3
C  EPS4 IS TAKEN VERY SMALL TO AVOID OVERFLOW
C
            EPS2=ONET3*NORM      
            EPS3=PRECIS*NORM
            UK=ZFLOAT(Q-P+1)
            EPS4=UK*EPS3
            UK=EPS4/SQRT(UK)
            S=P
505         GROUP=0
            GOTO 520
C
C  LOOK FOR CLOSE OR COINCIDENT ROOTS
C
510         IF( ABS(X1-X0) .GE. EPS2) GOTO 505
            GROUP=GROUP+1
            IF(ORDER*(X1-X0) .LE. ZERO) X1=X0+ORDER*EPS3
C
C  ELIMINATION WITH INTERCHANGES AND INITIALIZATION OF VECTOR
C
520         V=ZERO
            DO 580 I=P,Q
                  RV6(I)=UK
                  IF(I .EQ. P) GOTO 560
                  IF(ABS(E(I)) .LT. ABS(U)) GOTO 540
                  XU=U/E(I)
                  RV4(I)=XU
                  RV1(I-1)=E(I)
                  RV2(I-1)=D(I)-X1
                  RV3(I-1)=ZERO
                  IF (I .NE. Q) RV3(I-1)=E(I+1)
                  U=V-XU*RV2(I-1)
                  V=-XU*RV3(I-1)
                  GOTO 580
540               XU=E(I)/U
                  RV4(I)=XU
                  RV1(I-1)=U
                  RV2(I-1)=V
                  RV3(I-1)=ZERO
560               U=D(I)-X1-XU*V
                  IF(I .NE. Q) V=E(I+1)
580         CONTINUE
C
            IF(U .EQ. ZERO) U=EPS3
            RV1(Q)=U
            RV2(Q)=ZERO
            RV3(Q)=ZERO
C
C  BACK SUBSTITUTION
C
C  FOR I=Q STEP -1 UNTIL P DO
C
600         DO 620 II=P,Q
                 I=P+Q-II
                 RV6(I)=(RV6(I)-U*RV2(I)-V*RV3(I))/RV1(I)
                 V=U
620              U=RV6(I)
C
C  ORTHOGONALIZE WITH RESPECT TO PREVIOUS MEMBERS OF GROUP
C
            IF(GROUP .EQ. 0) GOTO 700
            J=R
            DO 680 JJ=1, GROUP
630             J=J-1
                IF(IND(J) .NE. TAG) GOTO 630
                XU=ZERO
C
                DO 640 I=P,Q
640                   XU=XU+RV6(I)*Z(I,J)
C
                DO 660 I=P,Q
660                   RV6(I)=RV6(I)-XU*Z(I,J)
C
680         CONTINUE
C
700         NORM=ZERO
C
            DO 720 I=P,Q
720               NORM=NORM+ABS(RV6(I))
C
            IF(NORM .GE. ONE) GOTO 840
C
C  FORWARD SUBSTITUTION
C
            IF(ITS .EQ. MITS) GOTO 830 ! DIFFERENT TO TINVIT
            IF(NORM .NE. ZERO) GOTO 740
            RV6(S)=EPS4
            S=S+1
            IF(S .GT. Q)S=P
            GOTO 780
740         XU=EPS4/NORM
C
            DO 760 I=P,Q
760               RV6(I)=RV6(I)*XU
C
C  ELIMINATION OPERATIONS ON NEXT VECTOR ITERATE
C
780         DO 820 I=IP,Q
                  U=RV6(I)
C
C  IF RV1(I-1) .EQ. E(I), A ROW INTERCHANGE WAS PERFORMED EARLIER IN
C  THE TRIANGULARIZATION PROCESS
C
                  IF(RV1(I-1) .NE. E(I)) GOTO 800
                  U=RV6(I-1)
                  RV6(I-1)=RV6(I)
800               RV6(I)=U-RV4(I)*RV6(I-1)
820         CONTINUE
C
            ITS=ITS+1
            GOTO 600
C
C  SET ERROR --- NON-CONVERGED EIGENVECTOR
C
830         IFAULT=-R
            XU=ZERO
            GOTO 870
C
C  NORMALIZE SO THAT SUM OF SQUARES IS 1 AND EXPAND TO FULL ORDER
C
840         U=ZERO
            DO 860 I=P,Q
860               U=U+RV6(I)**2
C
            XU=ONE/SQRT(U)
870         DO 880 I=1,N
880               Z(I,R)=ZERO
            DO 900 I=P,Q
900               Z(I,R)=RV6(I)*XU
C
            X0=X1
920   CONTINUE
C
      IF(Q .LT. N) GOTO 100
1001  RETURN
      END
