C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SPCMTX(N,LT2,C,NF1,LWL,IR,W2,XR,XI,ip,ic)
C      CALCULATION OF SPECTRAL MATRIX FOR LAG WINDOW LENGTH LWL
C      PAPOULIS LAG WINDOW APPLIED TO CORRELATIONS
#include <f77/iounit.h>

c     basically form all combos of cross of time domain responses
c     XR & XI, then compute the spectraof these xcorrs

      dimension XR(N,LT2),XI(N,LT2),W2(NF1),IR(NF1)
      dimension C(N,N,NF1)

c     DIMENSION XR(12,1035),XI(12,1035),W2(513),IR(1024)
c     DIMENSION C(12,12,513)
c     DIMENSION A(2070),B(2070),D(1026),WIN(513)

      real      WIN, A, B, D
      pointer   (wkWIN, WIN(1))
      pointer   (wkA, A(1))
      pointer   (wkB, B(1))
      pointer   (wkD, D(1))
      integer   jsz, ierr, ierrt, abort
      data      ierr/0/, ierrt/0/, abort/0/

c     write(0,*) ' SPCMTX: LT2=',LT2,' N=',N, ' LWL=',LWL,' NF1=',NF1
      LA=LT2+LT2
      XLA=1.0/FLOAT(LA)
      MLAG=LWL/2+1
c     write(0,*) ' SPCMTX: MLAG= ',MLAG

      call sizefloat(jsz)
      call galloc (wkWIN, jsz*LWL, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkA, jsz*LA, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkB, jsz*LA, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkD, 4*jsz*NF1, ierr, abort)
      ierrt = ierrt + ierr
 
      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from saneusp:'
         write(LERR,*)'Unable to allocate memory in routine spcmtx'
         write(LER ,*)'FATAL ERROR from saneusp:'
         write(LER ,*)'Unable to allocate memory in routine spcmtx'
         call ccexit (666)
      endif

c     write(0,*) ' SPCMTX: ipass, icall, mlag= ',ip,ic,mlag
      IF(NF1.LT.MLAG)WRITE(6,11)NF1,MLAG
   11 FORMAT('  *** WARNING ***  NF1=',I3,'   MLAG=',I3)
      IF(NF1.LT.MLAG)NF1=MLAG
      IF(NF1.GT.513) WRITE(6,11)NF1,MLAG
      IF(NF1.GT.513)RETURN
      RCP=2.0/FLOAT(LWL)
      FAC=1.0/3.14159265
      DPH=3.14159265*RCP
      TRI=1.0
      PHI=0.0
      DO 10 I=2,MLAG
      TRI=TRI-RCP
      PHI=PHI+DPH
   10 WIN(I)=FAC*SIN(PHI)+TRI*COS(PHI)
      NF=NF1-1
c     write(0,*) ' before STWI: NF=',NF
      CALL STWI(NF,KN,IR,W2)
c     write(0,*) ' after STWI: NF=',NF,' KN=',KN
      NF1=NF+1
      NF2=NF1+1
      LD=NF+NF
      DO 1 K=1,N
      DO 101 I=1,LT2
      J=I+LT2
      A(I)=XR(K,I)
      A(J)=XI(K,I)
  101 CONTINUE
c     write(0,*)' calling ZERO: LD=',LD
c     if (ip.eq.1 .and. ic.eq.0) then
c     do ii = 1,2*LT2
c     write(17,*)ii,a(ii)
c     enddo
c     write(17,888)
c     endif
      CALL ZERO(LD,D)
      CALL CROSS(LA,A,LA,A,MLAG,D)
c     if (ip.eq.1 .and. ic.eq.0) then
c     do ii=1,mlag
c     write(18,*)ii,d(ii)
c     enddo
c     write(18,888)
c88   format()
c     endif
      DO 201 I=2,MLAG
      J=LD+3-I
      D(I)=D(I)*WIN(I)
  201 D(J)=D(I)
c     write(0,*)' calling FTRD: NF1=',NF1,' KN=',KN
      CALL FTRD(NF1,KN,IR,W2,D,D(NF2))
c     write (0,*)(ir(ii),ii=1,nf1/2)
c     write (0,*)' '
      DO 301 I=1,NF1
      IF(D(I).LE.0.0)D(I)=-D(I)
      C(K,K,I)=XLA*D(I)
  301 CONTINUE
c     write (0,*)(ir(ii),ii=1,nf1/2)
      IF(K.GE.N) GOTO 1
      LINR=K+1
      DO 2 L=LINR,N
      DO 102 I=1,LT2
      J=I+LT2
      B(I)=XR(L,I)
      B(J)=XI(L,I)
  102 CONTINUE
c     write(0,*)' calling ZERO: LD=',LD
      CALL ZERO(LD,D)
      CALL CROSS(LA,A,LA,B,MLAG,D)
      DO 202 I=2,MLAG
      J=LD+3-I
  202 D(J)=D(I)*WIN(I)
      CALL CROSS(LA,B,LA,A,MLAG,D)
      DO 402 I=2,MLAG
  402 D(I)=D(I)*WIN(I)
c     write(0,*)' calling FTRD2: NF1=',NF1,' KN=',KN
      CALL FTRD(NF1,KN,IR,W2,D,D(NF2))
c     write(0,*)' done FTRD2'
      DO 302 I=1,NF1
      J=I+NF1
      C(K,L,I)=XLA*D(I)
      C(L,K,I)=XLA*D(J)
  302 CONTINUE
      C(L,K,1)=0.0
      C(L,K,NF1)=0.0
    2 CONTINUE
    1 CONTINUE

      call gfree (wkWIN)
      call gfree (wkA)
      call gfree (wkB)
      call gfree (wkD)

      RETURN
      END
