C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	SUBROUTINE SSCPH(IUW,LW,SI,ESP,II,WFIL_PREFIX,TITLE,WCOMM,
     +				NOW, PHW, PHINC, xtr, luwav, irec)
#include <f77/iounit.h>

C-------------------------------------------------------------
C	Calculates zero phase wavelet from input energy spectrum ESP 
C	of length II with freq increment FI - used by SANE
C	IUW = unit for wavelet output
C	IW  = position to write to
C	LW  = length of wavelet to plot; file output will be 25% longer
C	SI =  sample interval, ms
C	A 70 character string with i/p file info is written to wvlt file
C	NOW =  number of wavelets
C	PHW =  starting phase (deg)
C	PHINC =  phase increment (deg)
C-------------------------------------------------------------

        real  xtr(2*LW)
        integer luwav, irec
        CHARACTER*(*) WFIL_PREFIX

c	DIMENSION ESP(II),Z(1024),Z1(513),Z2(513),IR(513),W2(257)
	DIMENSION ESP(II)
        integer IR
        real    Z, Z1, Z2, W2
        pointer (wkZ, Z(1))
        pointer (wkZ1, Z1(1))
        pointer (wkZ2, Z2(1))
        pointer (wkIR, IR(1))
        pointer (wkW2, W2(1))
        integer   jsz, ierr, ierrt, abort

	CHARACTER*50 TITLE
	CHARACTER*70 WCOMM(3)
        CHARACTER*255 WFIL
        CHARACTER*2 WFIL_SUFFIX(10)

        integer lenth

        data      iree/0/, ierrt/0/, abort/0/
        DATA WFIL_SUFFIX / '_0','_1','_2','_3','_4','_5','_6','_7','_8',
     1                     '_9' /

	DEGRAD=3.1415926/180.0

C----WAVELET: 1/2 length LW
c    add 12.5% LW on either end
c    center at LW + 12.5% LW

        LADJ=LW/8
        LWO=LW+2*LADJ
        LH=LWO/2
        LZW=2.*LH+1

        call sizefloat(jsz)
        call galloc (wkZ, 4*jsz*(LWO+1), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkZ1, 4*jsz*II, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkZ2, 4*jsz*II, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkIR, 4*jsz*II, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkW2, 4*jsz*II, ierr, abort)
        ierrt = ierrt + ierr

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from saneusp:'
         write(LERR,*)'Unable to allocate memory in routine sscph'
         write(LER ,*)'FATAL ERROR from saneusp:'
         write(LER ,*)'Unable to allocate memory in routine sscph'
         call ccexit (666)
      endif

        IF (NOW .GT. 10) NOW = 10
        IF (NOW .LT. 1) NOW = 1
        IW = 1
        IUW = 10

C----SET UP FOURIER TABLES
 
c       write(0,*) ' sscph: PHW,PHINC=',PHW,PHINC

c---
c  II = NF+1
c---
	N=II-1

c       write(0,*) ' sscph: II=',II
c       write(0,*) ' sscph calling STWI: N=',N,' KG=',KG

	CALL STWI(N,KG,IR,W2)
c       write(0,*) ' after STWI: KG=',KG

        WRITE(LERR,701)

	DO K = 1, NOW

		PH = PHW*DEGRAD

C----COPY ESP TO WORKING ARRAY AND GET PHASE RE+IM PARTS

		DO J=1,II
	   		AMP=SQRT(ESP(J))
	   		Z1(J)=AMP*COS(PH)
	   		Z2(J)=AMP*SIN(PH)
		ENDDO

C----INVERT TFM
 
c       write(0,*) ' sscph calling RSTR'

		CALL RSTR(II,KG,IR,W2,Z1,Z2)

 
C----WAVELET: 1/2 length LW
c    add 12.5% LW on either end
c    center at LW + 12.5% LW
 
		LADJ=LW/8
		LWO=LW+2*LADJ
		LH=LWO/2
		LZW=2.*LH+1

c        write (0,*) ' LW=',LW,' LWO=',LWO,' LH=',LH,' LZW=',LZW

		JST=N-LH

		DO J=1,LH
	
			Z(J)=Z2(JST+J)
			Z(J+LH)=Z1(J)

		ENDDO

		Z(LZW)=Z1(LH+1)
 
C----GRAPH WAVELET
 
c     write(0,*) ' sscph calling MAXDAT'

c       	WFIL = WFIL_PREFIX(1:lenth(WFIL_PREFIX)) //
c    +                   '_cons' // WFIL_SUFFIX(IW) // '.wav'

c     write(0,*) ' PHW=', PHW
c     write(0,*) ' WFIL=', WFIL(1:lenth(WFIL))

c		WRITE(LERR,702)PHW,WFIL(1:lenth(WFIL))

		CALL MAXDAT(LW,Z(LADJ),ZMX)
c     write(0,*)'sscph: LW,ZMX,LZW= ',LW,ZMX,LZW

 		CALL DGRAPH(LERR,Z(LADJ),LW,ZMX)
 
C----WRITE OUT TO FILE
 
		TZ=LH*SI
		IFL=1

c		WCOMM(3)(1:41)='Constant phase wavelet from SANE spectrum'
c		WRITE(WCOMM(3)(42:58),9)PHW

  9     FORMAT(1X,'; Phase=',F5.1,'deg')

                do  ii = 1, LZW
                    xtr (ii) = Z(ii)
                enddo

                if (luwav .ge. 1) then
                   write(luwav,*)'"rec= ',irec
                   do ii=1,LZW
                      write(luwav,*)ii,Z(ii)
                   enddo
                   write(luwav,888)
888                format()
                endif

		IW = IW + 1

		PHW =  PHW + PHINC

		CALL ZERO(LZW,Z)
		CALL ZERO(II,Z2)

	ENDDO

999	CONTINUE

        call gfree (wkZ)
        call gfree (wkZ1)
        call gfree (wkZ2)
        call gfree (wkIR)
        call gfree (wkW2)

   	RETURN

  701 FORMAT(/,10X,'****CONSTANT PHASE WAVELET(S)*******')
  702 FORMAT(/,5X,'Constant Phase = ',F4.1,'deg',/,5X,
     1'Wavelet output to ',A,/)
  277 FORMAT ('  WAVELET WRITE FAILED, STATUS=',I4,' UNIT =',I4)

	END
