C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SSNGRPH(S,V,N,FI,SMX, out_sdb, out_vdb, iout,
     1                   luspec,irec)
#include <f77/iounit.h>
C      USED BY SSANE TO PLOT SIGNAL AND NOISE SPECTRA
C	SPECTRA WILL BE IN DB, 60DB DOWN IS LIMIT FOR NUMBERS, 30 FOR PLOT
C	IF BOTH THE INPUT SIGNAL AND NOISE ARE 0, THE PLOT WILL TERMINATE
C	------------------------------------------------------------------
      integer   luspec
      DIMENSION S(N),V(N), out_sdb(N), out_vdb(N)
      CHARACTER XLINE(55)*1
      CHARACTER BLANK*1,DOT*1,X*1
      logical   done
      DATA BLANK,DOT,X /' ','.','X'/
   1  FORMAT(/,5X,'Spectra are listed and plotted in dB',/,5X,
     1'Peak value = ',E10.4,' (',F7.2,'dB)',/,5X,
     2'Minimum plotted value is 30dB down relative to peak.',
     3/,1X,'F(hz) Signal=X Noise=.')

	PSC=1.8
	DB0=10.*ALOG10(SMX)			!ZERO DB
	ADJ=30.-DB0				!Min 60dB down
	WRITE(LERR,1)SMX,DB0

      if (luspec .gt. 0) then
         write(luspec,*)'"Record= ',irec,'"'
         write(luspec,*)'"Spectra are listed and plotted in dB"'
         write(luspec,*)'"Peak value = ',SMX,' ( ',DB0,' db )"'
         write(luspec,*)'"Minimum plotted value is 30dB down relative to
     1 peak"'
         write(luspec,*)'"Signal...'
         done = .false.
         do  i = 1, N
             F=FI*FLOAT(i-1)
             sdb = S(i)/SMX
             if (sdb .ne. 0.0 .AND. .not. done) then
                hold = 10.*alog10(sdb)
                write(luspec,*)F, hold
             elseif (sdb .eq. 0.0 .AND. .not. done) then
                write(luspec,*)F, hold
                done = .true.
             elseif (done) then
                write(luspec,*)F, hold
             endif
         enddo
         write(luspec,888)
888      format()
         write(luspec,*)'"Noise...'
         done = .false.
         do  i = 1, N
             F=FI*FLOAT(i-1)
             vdb = V(i)/SMX
             if (vdb .ne. 0.0 .AND. .not. done) then
                write(luspec,*)F, 10.*alog10(vdb)
             elseif (vdb .eq. 0.0 .AND. .not. done) then
                write(luspec,*)F, hold
                done = .true.
             elseif (done) then
                write(luspec,*)F, hold
             endif
         enddo
      endif

      DO 100 I=1,N
      DO JJ=2,55
        XLINE(JJ)=BLANK
	ENDDO
	IF(S(I).GT.0.)THEN
		SDB=10.*ALOG10(S(I))
		JJ=INT(1.+PSC*(ADJ+SDB))
			ELSE
		JJ=1
		SDB=-999.
			ENDIF
	IF(V(I).GT.0.)THEN
		VDB=10.*ALOG10(V(I))
		KK=INT(1.+PSC*(ADJ+VDB))
			ELSE
		VDB=-999.
		KK=1
			ENDIF
	IF(SDB.LT.-900.AND.VDB.LT.-900.)GO TO 999
      IF(JJ.LT.1)JJ=1
      IF(KK.LT.1)KK=1
      IF(JJ-KK)91,91,92
   91 DO J=1,JJ
   	XLINE(J)=X
	ENDDO
      IF(JJ.EQ.KK)GOTO93
      LL=JJ+1
      DO J=LL,KK
   	XLINE(J)=DOT
	ENDDO
      GOTO 93
   92 DO J=1,KK
       XLINE(J)=DOT
	ENDDO
      LL=KK+1
      DO J=LL,JJ
      XLINE(J)=X
	ENDDO
   93 CONTINUE
      F=FI*FLOAT(I-1)
      WRITE(LERR,111)F,SDB,VDB,XLINE
      iout = iout + 1
      out_sdb(iout) = SDB
      out_vdb(iout) = VDB
  111 FORMAT(1X,F5.1,2X,F7.2,1X,F7.2,2X,55A1)
  100 CONTINUE
  999 RETURN
      END
