C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : GL_STWI
C Description : Writes COSINE tables for subroutines GL_RSTR and GL_FTRD
C Maintainer : S. DEREGOWSKI
C Version no.: 1
C Date : 1978
C Component class : SUBROUTINE
C Source location : GEOLIB:[GEOLIB.GL_LIB]
C Object location : GEOLIB:[GEOLIB]GL_LIB
C Documentation location : GRBS$DISK:[GEOLIB.TEXT.FFT]FFTPAK.TXT
C Category : FFT
C
C 
C Additional information:
C
C Before calling the transform routines GL_RSTR or GL_FTRD the Sin/Cos
C tables must be set up by calling this subroutine. This routine need only 
C be called once in the User's program provided the location KG or the arrays 
C IR and W2 are not overwriten and provided only one transform window length
C is required. STWI must be called each time a change in the transform window
C length is made.
C
C The user must ensure that the dimensions are correctly set.
C
C INPUT     N2  -   N2=N/2 where N is transferm window length in samples
C
C OUTPUT    KG  -   INTEGER required by GL_FTRD and GL_RSTR
C           IR  -   ARRAY   containing sin/cosine tables
C           W2  -   ARRAY   containing sin/cosine tables
C 
C--
C     SUBROUTINE GL_STWI(NI,KG,IR,W2)
      SUBROUTINE STWI(NI,KG,IR,W2)
      dimension IR(NI),W2(NI)
c     DATA NSTORE/0/

c     write(*,*) ' STWI: NI=',NI,' NSTORE=',NSTORE
c     IF (NSTORE.EQ.NI) RETURN
      N=IABS(NI)
c     NSTORE=N
      IF (N.LE.0)RETURN
      I=2
      KG=1
2     I=I+I
      KG=KG+1
      IF(I.LT.N) GOTO2
      XN=I
      N=I
      N8=N/8
      N9=N8+1
      N4=N9+N8
      N5=N4+1
      S=SIN(6.2831853072/XN)
      C=SQRT((1.0-S)*(1.0+S))
c     write(*,*) ' STWI: NI=',NI,' XN=',XN,' S=',S,' C=',C
      W2(N9)=0.7071068
      W2(N4)=1.0
      W2(1)=0.0
      CS=1.0
      IF (N5.LE.2) W2(2)=1.0
      IF (N5.LE.2) GOTO 6
      DO 4 K=2,N8
      SN=W2(K-1)
      W2(K)=S*CS+C*SN
      CS=C*CS-S*SN
4     W2(N5-K)=CS
    6 CONTINUE
      M=N/2
      N2=N/2
      DO 5 I=1,N2
   5  IR(I)=0
      I=1
11    KF=M
      M2=M/2
      KI=M2+1
12    DO 13 K=KI,KF
13    IR(K)=IR(K)+I
      KI=KI+M
      KF=KF+M
      IF(N2.GE.KF) GOTO12
      IF(M2.LT.2) GOTO15
      M=M2
      I=I+I
      GOTO11
15    RETURN
      END
