C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : THOMLOOP_CROSS
C Description : FINDS EIGENCOEFF WITH MEAN REMOVAL
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 8 JULY 1988
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: SEE BELOW
C 
C--
C
      SUBROUTINE THOMLOOP_CROSS(N, NMAX, NREQ, NREQMAX, K0, K1, Z,
     *  X, XIN, Y, UR, D, S, QMEAN, IFAULT)
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  FOR EACH TRACE OR TIME SERIES THE SUBROUTINE CALCULATES THE 
C  EIGENCOEFFS FOR ORDERS K0 TO K1, AND THEN SUBTRACTS THEIR MEAN
C  IF DESIRED. THEN COMPUTES THE POWER
C  SPECTRUM BY AVERAGING OVER ORDERS.
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  (i/o) denotes input or output parameter
C
C  N        Integer (i)     length of dpss sequence
C
C  NMAX     Integer (i)     max permitted size for N (first dim of
C                           SDATM and Z)
C
C  NREQ     Integer (i)     number of terms for FFT (e.g., 2**p)
C                           or Singleton-compatible length
C
C  NREQMAX  Integer (i)     max permitted size of NREQ (e.g., 4096)
C                           (defines dim of D and Y in calling prog)
C
C  K0       Integer (i)     minimum order for dpss (e.g., 0)
C
C  K1       Integer (i)     maximum order for dpss (e.g., 5)
C
C  Z(NMAX,K1-K0+1)  Real  (i)  the dpss of orders K0 to K1 in first 
C                              (K1-K0+1) columns
C
C  X(NREQ)  Real            workspace
C
C  XIN(N)   Real            input time series
C
C  Y((NREQMAX/2)+1,K1-K0+1) complex (o) eigencoeffs at Fourier freq
C                                    defined by NREQ, by column for
C                                    different orders of dpss. If mean
C                                    removal required, the eigencoeffs
C                                    on output will have been mean 
C                                    corrected. This is not the case
C                                    for THOMLOOPA.
C
C  UR((NREQMAX/2)+1,K1-K0+1) real (i) dpswf in columns, at Fourier freq
C                                     defined by NREQ
C
C  D((NREQMAX/2)+1,K1-K0+1)  real (i) weights at Fourier freq defined by
C                                     NREQ, by column for different
C                                     orders of dpss
C
C  S((NREQ/2)+1)      real (o)  average spectra using weights over NTR
C                               traces or time series
C
C  QMEAN              logical (i)   if true, carry out Thomson's mean
C                                   removal
C
C  IFAULT     Integer  (o)     if IFAULT =0 then success
C                              1 if failure of EIGENCOEFF
C                              2 if failure of DJTMEANA
C                              3 if failure of SPECONA
C
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C
      INTEGER I, N, NL, NMAX, NREQ, K0, K1, K, N2, JJ,
     * IFAULT1, IFAULT2, IFAULT3, IFAULT, NREQMAX
C
      DOUBLE PRECISION  ZERO, XIN(N),
     * Z(NMAX, K1-K0+1), X(NREQ), UR((NREQMAX/2)+1,K1-K0+1),
     * D((NREQMAX/2)+1,K1-K0+1), S((NREQ/2)+1)
C
      DOUBLE COMPLEX CMU, Y((NREQMAX/2)+1,K1-K0+1)
C
      LOGICAL QMEAN
C
      DATA ZERO/0.0D0/
C
      K=K1-K0+1
      N2=(NREQ+1)/2
      IF(MOD(NREQ,2) .EQ. 0) N2=N2+1
C
C  COMPUTE THE EIGENCOEFFS FOR ORDERS K00 TO K10 OF XIN(.)
C
           CALL EIGENCOEFF(N,NMAX,NREQ,NREQMAX,
     *       K0,K1,Z,X,Y,XIN,QMEAN,IFAULT1)
C
C           WRITE(6,*) ' IFAULT1', IFAULT1
           IFAULT=1
           IF(IFAULT1 .NE. 0) RETURN
C
C  IF THOMSON'S MEAN REMOVAL TO BE USED , FIND CMU
C
           IF(QMEAN) THEN
            CALL DJTMEANA(N, NREQ, NREQMAX, K0, K1, UR, Y, D, 
     *          CMU,IFAULT2)
C           WRITE(6,*) ' IFAULT2', IFAULT2
               IFAULT=2
               IF(IFAULT2 .NE. 0) RETURN
C
C NOW SUBTRACT MEAN COMPONENT FROM EIGENCOEFFICIENT
C
               DO 5 JJ=1,N2
                 DO 10 I=1,K
                      Y(JJ ,I) = Y(JJ ,I)- CMU* UR(JJ, I)
 10              CONTINUE
  5            CONTINUE
           END IF
C
C  FORM UP SPECTRUM ESTIMATES WITH MEAN COMPONENT REMOVED IF REQUESTED
C
      CALL SPECON_CROSS(N, NREQ, NREQMAX, K0, K1, CMU, Y, UR, 
     *  D, S, IFAULT3)
C           WRITE(6,*) ' IFAULT3', IFAULT3
           IFAULT=3
           IF(IFAULT3 .NE. 0) RETURN
      IFAULT=0
      RETURN
      END
