C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE TRIDPSSD(N, NN, W, K0, K1, FV, MITS, IND, Z, IFAULT) 
C
C  ALGORITHM AS000 APPL. STATIST. (1987)
C
C  CALCULATES DISCRETE PROLATE SPHEROIDAL SEQUENCES FOR USE AS DATA
C  TAPERS.
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N      Integer     input        length of sequence to generate 
C  NN     Integer     input        first dimension of FV and Z in the 
C                                  calling (sub)program, i.e., maximum 
C                                  possible  N
C  W      Real        input        bandwidth, W < 1/2
C  K0     Integer     input        K0 smallest index number of dpss to 
C                                  calculate (normally zero)
C  K1     Integer     input        K1 largest index number of dpss to 
C                                  calculate (normally <[2NW])
C  FV     Real(NN,10) work arrays 
C  MITS   Integer     input        maximum number of iterations allowed 
C                                  to determine any eigenvector (typically
C                                  5) 
C  IND    Integer(N)  output       contains submatrix indices associated 
C                                  with corresponding eigenvalue (see 
C                                  TRIEIGD, SELEIGD)
C  Z  Real(NN,K1-K0+1) output      columns contain eigenvectors corresponding
C                                  to indices K0 to K1
C  IFAULT Integer      output      IFAULT=0 indicates successful completion
C                                  =1 if W > 1/2
C                                  =2 if N < 2
C                                  =3 if NN<N, i.e., matrices FV,Z too small 
C                                  =4 if K1 < K0 or K0 > N-1 or K1 > N-1
C                                  =5 indicates multiple eigenvalues in 
C                                     TRIEIGD
C                                  =6 indicates that more than MITS
C                                     iterations are required in SELEIGD
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INTEGER  N, NN, K1, K0, I, MU, ML, M, IND(K1-K0+1), II, J,
     * M2, MJ1, IFAULT, IERR, MITS
      DOUBLE PRECISION FV(NN,12), Z(NN,K1-K0+1), W, BL, BU, EIGHT, HALF, 
     * FLI, TEMP, ONE, PRECIS, EPS1, ZFLOAT, TWOPI, RN, CON, CC, RNM2 
C
      DATA EIGHT,HALF,ONE,PRECIS
     * /8.0D0,0.5D0,1.0D0,2.7D-12/
C
      ZFLOAT(I)=DBLE(I)
C
      IFAULT=1
      IF(W .GT. HALF) RETURN
      IFAULT=2
      IF(N .LT. 2) RETURN
      IFAULT=3
      IF(NN .LT. N) RETURN
      IFAULT=4
      IF(K1 .LT. K0) RETURN
      TWOPI=EIGHT*ATAN(ONE)
      RN=ZFLOAT(N)
      CON=TWOPI*W
      CC=COS(CON)
      RNM2=(RN-ONE)*HALF
C
C  SET UP DIAGONAL, SUB-DIAGONAL AND SQUARED SUB-DIAGONAL TERMS
C
c     write (0,*) ' inside TRIDPSSD: N=',N
      DO 10 I=1,N
           FLI=ZFLOAT(I-1)
           FV(I,1)= CC*(RNM2-FLI)**2
      IF(I .GT. 1) THEN
           FV(I,2)= FLI*(RN-FLI)*HALF
           FV(I,3)= FV(I,2)**2
      END IF
 10   CONTINUE
C
C  CHANGE TO ASCENDING ORDER OF MAGNITUDE
C
      MU=N-K0
      ML=N-K1
      M=MU-ML+1
C
C  LET TRIEIGD DETERMINE EPS1
C
      EPS1=-ONE
C
C  FIND EIGENVALUES
C
c     write (0,*) ' calling TRIEIGD'

      CALL TRIEIGD(N, PRECIS, EPS1, FV(1,1), FV(1,2), FV(1,3), 
     * BL, BU, ML, M, FV(1,10), IND, FV(1,7), FV(1,8), IERR ) 

      IFAULT=5
c     write (0,*) ' calling TRIEIGD: IERR= ',IERR
      IF(IERR .NE. 0) RETURN
C
C  FIND EIGENVECTORS
C
c     write (0,*) ' calling SELEIGD: N,NN,MITS,M= ',
c    1N,NN,MITS,M

      CALL SELEIGD(N, NN, MITS, PRECIS, FV(1,1), FV(1,2), FV(1,3), 
     * M, FV(1,10), IND, FV(1,4), FV(1,5), FV(1,12), FV(1,7), FV(1,9), 
     * Z, IERR) 

c     write (0,*) ' calling SELEIGD: IERR= ',IERR
      IFAULT=6
      IF(IERR .NE. 0) RETURN
C
C  EIGENVECTORS ALREADY STANDARDIZED, BUT CHANGE SIGN IF NECESSARY
C
      J=0
      DO 20 II=ML,MU
           J=J+1
           I=1+N-II
c     write (*,*) ' calling STDPOLD'
           CALL STDPOLD(N, Z(1,J), ONE,I-1)
 20   CONTINUE
C
C  NOW REORDER EIGENVECTORS 
C
      M2=M/2
      DO 25 J=1,M2
        MJ1=M-J+1
        DO 25 I=1,N
          TEMP= Z(I,MJ1)
          Z(I,MJ1)=Z(I,J)
 25       Z(I,J)=TEMP
C
      IFAULT=0
      RETURN
      END
