C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE TRIEIGD(N, PRECIS, EPS1, D, E, E2, LB, UB, M11, M,
     * W, IND, RV4, RV5, IFAULT)
C
C  DETERMINES THOSE EIGENVALUES OF A SYMMETRIC TRIDIAGONAL MATRIX
C  BETWEEN SPECIFIED BOUNDARY INDICES USING STURM SEQUENCING.
C
C  UP TO AND INCLUDING ''IFAULT=0'' THE CODE IS NEW TO CONFORM TO
C  APPLIED STATISTICS STANDARDS. AFTER THIS THE CODE FOLLOWS SUBROUTINE
C  TRIDIB IN B. T. Smith et al (1976) Matrix Eigensystem Routines ---
C  EISPACK Guide, Lecture Notes in Computer Science 6, Springer-Verlag,
C  507-510, EXCEPT:
C
C  THE FOLLOWING CHANGES ARE MADE TO THE EISPACK ROUTINE TRIDIB:
C    (1) ZERO, HALF, ONE, TWO REPLACE 0.0, 0.5, 1.0, 2.0 IN TRIDIB
C    (2) MIN, MAX, ZFLOAT REPLACE AMIN1, AMAX1, FLOAT IN TRIDIB 
C    (3) PRECIS REPLACES MACHEP AND IFAULT REPLACES IERR IN TRIDIB
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N       Integer     input      dimension of the matrix
C  PRECIS  Real        input      computational accuracy, defined as smallest
C                                 positive number such that 1+PRECIS > 1
C  EPS1    Real        input      specifies an absolute error tolerance for
C                                 the computed eigenvalues. If non-positive
C                                 on input it will be computed in the 
C                                 subroutine. This seems the best approach.
C  D       Real(N)     input      diagonal elements of tridiagonal matrix
C  E       Real(N)     input      E(2),...,E(N) contain subdiagonal
C                                 elements of symmetric tridiagonal matrix,
C                                 E(1) is arbitrary.
C  E2      Real(N)     input      E2(2),...,E2(N) contain squares of subdiag
C                                 elements of tridiagonal matrix. E2(1) is
C                                 arbitrary, but on output is set to zero.
C                                 If any of the elements in E are regarded
C                                 as negligible, the correponding elements
C                                 of E2 are set to zero, and so the matrix
C                                 splits into a direct sum of submatrices.
C  LB      Real       output      lower endpoint of interval containing
C                                 desired eigenvalues
C  UB      Real       output      upper endpoint of interval containing
C                                 desired eigenvalues
C  M11     Integer     input      lower index of set of desired eigenvalues
C                                 (assumes ordering corresponds to increasing
C                                 eigenvalue size)
C  M       Integer     input      number of eigenvalues required; upper
C                                 index set to M22=M11+M-1.
C  W       Real(M)    output      M eigenvalues in ascending order
C  IND     Integer(M) output      submatrix indices associated with corresp.
C                                 eigenvalues.
C  RV4     Real(N)  workspace
C  RV5     Real(N)  workspace
C  IFAULT  Integer    output      0 : successful completion
C                                 if exactly multiple eigenvalues prevent
C                                 the determination of an appropriate LB,
C                                 subroutine terminates with no eigenvalues
C                                 computed, and IFAULT is set to 3N+1.  
C                                 Then LB and UB define the interval contain-
C                                 ing all the eigenvalues.
C                                 If exactly multiple eigenvalues prevent
C                                 the determination of an appropriate UB,
C                                 subroutine terminates with no eigenvalues
C                                 computed, and IFAULT is set to 3N+2. 
C                                 Then UB defines the upper bound on the
C                                 interval containing all the eigenvalues. 
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INTEGER I, J, K, L, M, N, P, Q, R, S, II, M1, M2, M11, M22,
     * TAG, IFAULT, ISTURM, IND(M)
C
      DOUBLE PRECISION D(N), E(N), E2(N), W(M), RV4(N), RV5(N), U, V, 
     * LB, T1, T2, UB, XU, X0, X1, EPS1, PRECIS, ZFLOAT, 
     * ZERO, HALF, ONE, TWO 
C
      DATA ZERO,HALF,ONE,TWO/0.0D0,0.5D0,1.0D0,2.0D0/
C
c     ZFLOAT(I)=DBLE(I)
C
      IFAULT=0
      TAG=0
      XU=D(1)
      X0=D(1)
      U=ZERO

c     write(0,*) 'N=',N
c     write(0,*) 'PRECIS=', PRECIS
c     write(0,*) 'EPS1=', EPS1
c     write(0,*) 'D=', D
c     write(0,*) 'E=', E
c     write(0,*) 'LB=', LB
c     write(0,*) 'UB=', UB
c     write(0,*) 'M11=', M11
c     write(0,*) 'M=', M
c     write(0,*) 'W=', W
c     write(0,*) 'IND=', IND
c     write(0,*) 'RV4=', RV4
c     write(0,*) 'RV5=', RV5
c     write(0,*) 'IFAULT=', IFAULT
c     write(0,*) 'E2=', E2

C
C  LOOK FOR SMALL SUB-DIAGONAL ENTRIES AND DETERMINE AN INTERVAL
C  CONTAINING ALL THE EIGENVALUES
C
      DO 40 I=1,N
           X1=U
           U=ZERO
           IF(I .NE. N) U = ABS(E(I+1))
           XU=MIN(D(I)-(X1+U), XU)
           X0=MAX(D(I)+(X1+U), X0)
           IF(I .EQ. 1) GOTO 20
           IF( ABS(E(I)) .GT. PRECIS*(ABS(D(I))+ABS(D(I-1))))
     *       GOTO 40
 20        E2(I)=ZERO
 40   CONTINUE
C
      X1=MAX(ABS(XU),ABS(X0))*PRECIS*DBLE(N)
      XU=XU-X1
      T1=XU
      X0=X0+X1
      T2=X0
C
C  DETERMINE AN INTERVAL CONTAINING EXACTLY THE DESIRED EIGENVALUES
C
      P=1
      Q=N
      M1=M11-1
      IF(M1 .EQ. 0) GOTO 75
      ISTURM=1
 50   V=X1
      X1=(XU+X0)*HALF
      IF(X1 .EQ. V) GOTO 980
      GOTO 320
 60   IF( S-M1 ) 65, 73, 70
 65   XU=X1
      GOTO 50
 70   X0=X1
      GOTO 50
 73   XU=X1
      T1=X1
 75   M22=M1 + M
      IF(M22 .EQ. N) GOTO 90
      X0=T2
      ISTURM=2
      GOTO 50
 80   IF(S-M22) 65, 85, 70
 85   T2=X1
 90   Q=0
      R=0
C
C  ESTABLISH AND PROCESS NEXT SUBMATRIX, REFINING INTERVAL BY THE
C  GERSCHGORIN BOUNDS
C
100   IF( R .EQ. M) GOTO 1001
      TAG=TAG+1
      P=Q+1
      XU=D(P)
      X0=D(P)
      U=ZERO
C
      DO 120 Q=P,N
            X1=U
            U=ZERO
            V=ZERO
            IF(Q .EQ. N) GOTO 110
            U=ABS(E(Q+1))
            V=E2(Q+1)
110         XU=MIN(D(Q)-(X1+U),XU)
            X0=MAX(D(Q)+(X1+U),X0)
            IF(V .EQ. ZERO) GOTO 140
120   CONTINUE
C
140   X1=MAX(ABS(XU), ABS(X0))*PRECIS
      IF(EPS1 .LE. ZERO) EPS1=-X1
      IF(P .NE. Q) GOTO 180
C
C  CHECK FOR ISOLATED ROOT WITHIN INTERVAL
C
      IF(T1 .GT. D(P) .OR. D(P) .GE. T2) GOTO 940
      M1=P
      M2=P
      RV5(P)=D(P)
      GOTO 900
180   X1=X1*DBLE(Q-P+1)
      LB=MAX(T1, XU-X1)
      UB=MIN(T2, X0+X1)
      X1=LB
      ISTURM=3
      GOTO 320
200   M1=S+1
      X1=UB
      ISTURM=4
      GOTO 320
220   M2=S
      IF(M1 .GT. M2) GOTO 940

C
C  FIND ROOTS BY BISECTION
C
      X0=UB
      ISTURM=5
C
      DO 240 I=M1,M2
            RV5(I)=UB
240         RV4(I)=LB
C
C  LOOP FOR K-TH EIGENVALUE
C
C  FOR K=M2 STEP -1 UNTIL M1 DO
C
      K=M2
250      XU=LB
C
C  I=K STEP -1 UNTIL M1 DO
C
         DO 260 II=M1,K
               I=M1+K-II
               IF(XU. GE. RV4(I)) GOTO 260
               XU=RV4(I)
               GOTO 280
260      CONTINUE
C
280      IF(X0 .GT. RV5(K)) X0= RV5(K)
C
C  NEXT BISECTION STEP
C
300      X1=(XU+X0)*HALF
         IF( (X0-XU) .LE. (TWO*PRECIS *
     *      (ABS(XU) + ABS(X0)) + ABS(EPS1))) GOTO 420
c        IF(abs((X0-XU) - (TWO*PRECIS *
c    *      (ABS(XU)+ABS(X0))+ABS(EPS1))) .lt. .000000001)GOTO 420
C
C  IN LINE PROCEDURE FOR STURM SEQUENCE
C
320      S=P-1
         U=ONE
C
         DO 340 I=P,Q
               IF(U .NE. ZERO) GOTO 325
               V=ABS(E(I))/PRECIS
               GOTO 330
325            V=E2(I)/U
330            U=D(I)-X1-V
               IF(U .LT. ZERO) S=S+1
340      CONTINUE
C

         GOTO (60,80,200,220,360), ISTURM
C
C  REFINE INTERVALS
C
360      IF(S .GE. K) GOTO 400
         XU=X1
         IF(S .GE. M1) GOTO 380
         RV4(M1)=X1
         GOTO 300
380      RV4(S+1)=X1
         IF(RV5(S) .GT. X1) RV5(S)=X1
         GOTO 300
400      X0=X1
         GOTO 300
C
C  K-TH EIGENVALUE FOUND
C
420       RV5(K)=X1
       K=K-1
       IF(K .GE. M1) GOTO 250
C
C  ORDER EIGENVALUES TAGGED WITH THEIR SUBMATRIX ASSOCIATIONS
C
900   S=R
      R=R+M2-M1+1
      J=1
      K=M1
C
      DO 920 L=1,R
             IF(J .GT. S) GOTO 910
             IF(K .GT. M2) GOTO 940
             IF(RV5(K) .GE. W(L)) GOTO 915
C
             DO 905 II=J,S
                   I=L+S-II
                   W(I+1)=W(I)
                   IND(I+1)=IND(I)
905          CONTINUE
C
910          W(L)=RV5(K)
             IND(L)=TAG
             K=K+1
             GOTO 920
915          J=J+1
920   CONTINUE
C
940   IF(Q .LT. N) GOTO 100
      GOTO 1001
C
C  SET ERROR: INTERVAL CANNOT BE FOUND CONTAINING EXACTLY THE DESIRED
C  EIGENVALUES
C
980   IFAULT=3*N+ISTURM
1001  LB=T1
      UB=T2
      RETURN
      END
