C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	SUBROUTINE UNBAND(NX,X,SI,BXU,BXW,ACX0)
C	-----------------------------------------------------------------------
C
C	UNBAND is a subroutine to calculate the bandwidth of a seismic trace
C	or wavelet from its autocovariance
C
C	The main difference between this and the original SANEUSP code used in
C	COMPAIR, COMSPEC, SANE and MAST is that it provides an UNBIASSED
C	esitmate and so should be a much more reliable indicator of the true
C	data bandwidth and the correct choice of smoothing window length.
C
C							Sue Raikes 17/8/89
C	INPUT PARAMETERS:
C	NX............................Number of data samples NB max 2048
C	X.............................Array containing data trace/wavelet
C	SI............................Sample interval, in milliseconds
C	
C	OUTPUT PARAMETERS:
C	BXU...........................UNBIASSED estimate of bandwidth of X, Hz
C	BXW...........................Estimate of bandwidth (Hz) if X is WAVELET
C	ACX0..........................Zero-lag autocovariance of X
C
C	Requires CROSS from GEOLIB:[GEOLIB.STAT]STATLIB
C	------------------------------------------------------------------------
C
        real  X(*), si, BXU, BXW, ACX0
	real  XX(2048)
C
C     Calculate one-sided autocovariance
C
	CALL CROSS(NX,X,NX,X,NX,XX)
	ACX0=XX(1)			!zero-lag autocovariance
C
C	Check for possible over/underflows
C
	XMAX=1.0E+15
	XMIN=1.0E-10
	IF(XX(1).GT.XMAX)THEN
		RESC=1.0E-12
	ELSE IF(XX(1).LT.XMIN) THEN
		RESC=1.0E+06
	ELSE
		RESC=1.
	ENDIF

c       write(0,*) ' unband: X(1)=',X(1),' XX(1)=',XX(1),' RESC=',RESC
C
C	Scale if needed
C
	IF(ABS(RESC-1.).GT.0.001)THEN
          write (0,*) ' UNBAND rescaling data'
		DO J=1,NX
			XX(J)=XX(J)*RESC
		ENDDO
	ENDIF
C
C	Now calculate bandwidth
C
	G2=XX(1)*XX(1)
	SUM=0.5*G2
	FAC=1.0
	DEL=1.0/FLOAT(NX)
	DIV=SUM
	DO I=2,NX
		FAC=FAC-DEL  ! a taper
		DIV=DIV+XX(I)*XX(I)
		SUM=SUM+XX(I)*XX(I)*FAC
	ENDDO
	SUM=2.0*SUM
	DIV=2.0*DIV
	FS=1000./SI
C
C	BX -  DATA TRACE - standard unsmoothed estimate as used before
C	BXU - DATA TRACE - UNBIASSED estimate
C	BXW - WAVELET    - no truncation effects, only autocovariance
C
	BX=0.5*G2*FS/SUM
	BXU=5.0*BX/3.0 - DEL*FS
	BXW=0.5*G2*FS/DIV
C
C	Zero autocovariance array
C
	CALL ZERO(NX,XX)
	RETURN
	END

