C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C----------------------------------------------------------------------
C   PROGRAM SMEDIAN - Spatial Median Smooth

c   changes:

c   July 12, 2002: - fixed a one sample shift still present in the -median
c                    loop.  Also changed behaviour of -rs[] -re[] to
c                    be processing limits only.  All data is now passed by
c                    this program.
c   Garossino
c
c   Mar 21, 2002:  - fixed indexing problem in the inner loop that resulted
c                    in the first sample never being used in the calculation
c                    and never being populated on the way out.  Also the error
c                    resulted in the rest of the first row of samples being
c                    populated by the end of the previous trace.  Reported by
c                    Steve Lancaster
c   Garossino
c
c   Nov 27, 2000:  - removed odd window size constraint.  User can 
c                    now supply an even window length, of course that
c                    means an asymmetrical statistic weighted more to
c                    the high side. [Requested by Richard]
c
c                  - added implicit none and did general clean up so that
c                    I could understand the code at a glance
c   Garossino
c
c   Apr 10, 2000:  - added -st option
c                  - changed default from median to mean
c   Crider
C
C

      implicit none

c-----------------------------------------------------------------------
c
#include  <localsys.h>
#include  <save_defs.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
#include  <f77/iounit.h>


c-----------------------------------------------------------------------
c Standard USP Variables

      integer jerr, irs, ire, luin, luout, lbytes, nsamp, nsi
      integer ntrc, nrec, ns, ne, lbyout, iform, argis, nbyout
      integer nbytes
      integer itr ( SZLNHD ) 

      real UnitSc

      character   ntap*256, otap*256 ,name*7

      logical verbos

c Dynamic Memory Variables
      
      integer ner, iabort
      integer iheadr(1), istat(1)

      real udt(1), u2(1), xstat(1),tri(1)

      pointer ( udtadr, udt ), ( pxstat, xstat )
      pointer ( u2adr,u2 ), ( pist, istat ), ( pihd, iheadr )

c Local Variables

      integer LH, TH, in_ikp, pipep, ismthx, ismthz
      integer lntrc, lnrec, nrecc, ntrace, ierr
      integer mget, iget, ixsmth, izsmth, jrec, jdx
      integer jxstart, jxend, jt, jtstart, jtend
      integer icount, jxget, jtget, iavg, jxi, i, j
      integer ndx, jx
      integer ifmt_recind, l_recind, ln_recind
      integer ifmt_prrcnm, l_prrcnm, ln_prrcnm
      integer ifmt_grpelv, l_grpelv, ln_grpelv
      integer ifmt_srptel, l_srptel, ln_srptel
      integer ifmt_deptel, l_deptel, ln_deptel
      integer ifmt_stacor, l_stacor, ln_stacor
      integer ifmt_dstsgn, l_dstsgn, ln_dstsgn

      real dt, tmax, scale, vavg, vmedian

c
      logical geom, harm, mean, angle,ikp,stack, median
c
      equivalence (itr(1),tri(1))

c initialize variables

      DATA name /'SMEDIAN' /, pipep/3/
      LH = LINEHEADER
      TH = TRACEHEADER
      ikp=.false.

C-----------------------------------------------------------------------
C      get online help
C-----------------------------------------------------------------------
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt .0 .or. 
     :     argis ( '-help' ) .gt .0 )then
         call help(LER)
         stop
      end if

C-----------------------------------------------------------------------
C      open Printout File
C-----------------------------------------------------------------------
#include <f77/open.h>

C
      if(in_ikp().eq.1)ikp=.true.

      call gcmdln (ntap, otap, irs, ire, ismthx, ismthz, 
     :     verbos,mean, angle,stack,name,geom,harm,median)
c
c removed Nov 27, 2000 by request from Richard....Garossino
c      ismthx = ismthx/2*2+1
c      ismthz = ismthz/2*2+1
c ----------------------------

C-----------------------------------------------------------------------
C      get logical unit numbers for input and output
C-----------------------------------------------------------------------
      call getln (luin,  ntap, 'r', 0 )
      if(luin.eq.0)call sislgbuf(luin,'off')
      call getln (luout, otap, 'w', 1 )
      if(luout.lt.0)then
       write(ler, *)'Unable to open ',otap
       call lbclos(luin)
       stop
      endif

C-----------------------------------------------------------------------
C      read lineheader and save key values
C-----------------------------------------------------------------------
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if (lbytes .eq. 0) then
            write(LER, *)'SMEDIAN: no header read from unit ', luin
            write(LER, *)'FATAL'
            stop
      endif
#include <f77/saveh.h>
c     get line header values
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', lntrc , LINHED)
      call saver(itr, 'NumRec', lnrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
c
C-----------------------------------------------------------------------
c     build pointers to selected trace headers
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TH)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TH)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TH)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TH)
      call savelu('DePtEl',ifmt_DePtEl,l_DePtEl,ln_DePtEl,TH)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TH)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TH)
C-----------------------------------------------------------------------
C
C      verify command line parameters
C
C-----------------------------------------------------------------------
*     call cmdchk ( ns, ne, irs, ire, lntrc, lnrec )
      if(ns.eq.0)ns=1
      if(ne.eq.0)ne=ntrc
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire=nrec
C-----------------------------------------------------------------------
C
C      modify lineheader to agree with command line arguments
C
C-----------------------------------------------------------------------
c      nrecc = ire -irs + 1
c will now pass all records and only filter records between -rs and -re
c July 12, 2002 ...Garossino

      call savew(itr, 'NumRec', nrec, LINHED)
      ntrace = ne - ns + 1
      call savew(itr, 'NumTrc', ntrace,   LINHED)
      call savhlh(itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, lbyout                      )
c-----------------------------------------------------------------------
c     set general parameters
c
c
      dt = real (nsi) * unitsc
      tmax = dt * float( nsamp - 1 )
      scale = 1.0 / dt
C-----------------------------------------------------------------------
C
C      verbose listing of parameters
C
C-----------------------------------------------------------------------
c     if (verbos) then
        call verbal(nsamp,nsi,ntrc,nrec,iform,ntap,otap,ismthx,ismthz,
     :        irs,ire,ns,ne,mean,median,geom,harm)
c     end if
c-----------------------------------------------------------------------
c
c      get array space
c

      ner = 0
      ierr = 0
      iabort = 0
      mget=0
 
      if(stack)then
         ntrace = lnrec
         nrecc = lntrc
         ns = 1
         ne = lnrec
         irs = 1
         ire = lntrc
      else
         ntrace = lntrc
         nrecc  = lnrec
         ns     = 1
         ne     = lntrc
c the following were stated on the command line, it would be bad form
c to reset them here
c         irs    = 1
c         ire    = lnrec
      endif

      iget = nsamp*ntrace*SZSMPD
      call galloc(udtadr,iget,ierr,iabort)
      if (ierr .ne. 0) ner=ner+1
      mget=mget+iget
      call galloc(u2adr,iget,ierr,iabort)
      if (ierr .ne. 0) ner=ner+1
      mget=mget+iget

      iget = 4.*ixsmth*izsmth*SZSMPD
      call galloc(pxstat,iget,ierr,iabort)
      if(ierr.ne.0)ner=ner+1
      mget=mget+iget

      iget = ntrace*SZSMPD
      call galloc(pist,iget,ierr,iabort)
      if(ierr.ne.0)ner=ner+1
      mget=mget+iget
     
      iget = ITRWRD*ntrace*SZSMPD
      call galloc(pihd,iget,ierr,iabort)
      if(ierr.ne.0)ner=ner+1
      mget=mget+iget

      if(ner.ne.0)then
       write(lerr,*)'Unable to allocate work space. FATAL!'
       write(ler, *)'Unable to allocate work space. FATAL!'
       call lbclos(luin)
       stop
      endif
      write(lerr,*)'Allocated ',iget,' bytes (',iget/SZSMPD,' words)'

C-----------------------------------------------------------------------
C       skip unwanted records
C
       if(irs.gt.1)then
c          call skprec(1, irs - 1, luin, ntrc, itr, lbytes, nsamp, iform)
          call recrw(1, irs-1, luin, ntrc, itr, luout, nbytes )
          if ( nbytes .eq. 0 ) goto 999
       endif
C-----------------------------------------------------------------------
C
C-----Loop over Records
C
      jrec=irs
      nbyout=0

      do while(jrec.le.ire)
C
C       Initialize Output Array udt.
C
         do j = 0,ntrace-1
            ndx=j*nsamp

            do i = 1, nsamp
               udt(ndx+i) = 0.0
            end do  
            call vmov(0,0,iheadr,1,ITRWRD)
         end do  

C-----------------------------------------------------------------------
C
C       Read Record into 2D array and get trace header info
C

         do jx=ns,ne
            nbytes = 0
            call rtape (luin,itr,nbytes)
            if (nbytes .le. 0 ) then
               write(LER,*) 'read EOF on record',jrec,' terminating'
               call lbclos(luin)
               call lbclos(luout)
            end if

            if(nbyout.eq.0)nbyout=nbytes

            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat(jx),TH)
            jdx = (jx-1)*ITRWRD
            call vmov( itr, 1, iheadr(jdx+1), 1, ITRWRD)
            ndx=(jx-1)*nsamp
            if (istat( jx ).lt.30000 ) then
               call vmov(itr(ITHWP1),1,u2(ndx+1),1,nsamp)
            else
               do i=1,nsamp
                  u2(ndx+i)=0.
               end do
            endif
         end do 

c     Median/Mean Smoothing
         do jx = ns, ne

            ndx=(jx-1)*nsamp+1
c            ndx=(jx-1)*nsamp
            jxstart = jx - ismthx
            jxend   = jx + ismthx
            if ( jxstart .lt. ns) jxstart = ns
            if ( jxend .gt. ne) jxend = ne

c---
c  step down traces in time
c---
            do jt = 1,nsamp

               jtstart = jt - ismthz
               jtend   = jt + ismthz
               if (jtstart .lt. 1 ) jtstart = 1
               if (jtend .gt. nsamp )jtend = nsamp
               icount = 0
c---
c  build spatial trace
c---
               do jxget = jxstart, jxend

c this logic resulted in the first sample never being populated
c AND the last sample being populated in the first slot of the
c next trace.  I have removed the +1 to prevent this from 
c occuring.  Garossino, Mar 21,2002
c                 jdx=(jxget-1)*nsamp+1

                  jdx=(jxget-1)*nsamp
                  do jtget = jtstart, jtend
                     if(u2(jdx+jtget).ne.0.)then
                        icount = icount + 1
                        xstat(icount) = u2(jdx+jtget)
                     endif
                  end do
               end do

               if (icount .gt. 1) then

                  if ( mean ) then

                     vavg=0.0
                     do iavg = 1,icount
                        vavg = vavg + xstat(iavg)
                     end do
                     vavg=vavg/float(icount)

c this logic would never use the first sample in the average and
c would result in a shifted trace once the above correction was made
c for a completely populated output trace.  I had to subtract one
c from the index here to be able to use the initial sample and 
c not shift the trace in time.  Garossino, Mar 21, 2002.
c                     udt(ndx+jt) = vavg 

                     udt(ndx+jt-1) = vavg 

                  elseif ( median ) then

                     call median1(icount,xstat,vmedian)
                     udt(ndx+jt-1) = vmedian

                  elseif ( geom ) then

                     vavg=0.0
                     do iavg = 1,icount
                        vavg = vavg + alog ( abs(xstat(iavg)) )
                     end do
                     vavg=vavg/float(icount)
                     udt(ndx+jt-1) = exp (vavg) 

                  elseif ( harm ) then

                     vavg=0.0
                     do iavg = 1,icount
                        vavg = vavg + 1. / xstat(iavg)
                     end do
                     vavg=float(icount) / vavg
                     udt(ndx+jt-1) = vavg

                  endif
               else
                  udt(ndx+jt) = u2(ndx+jt)
               endif
            end do
c---

         end do  
C----------------------------------------------------------------------
C       APPEND TRACE HEADERS AND WRITE OUT AN EXTRAPOLATED RECORD
C-----------------------------------------------------------------------
         DO 540 jxi = 0,ntrace-1
            jdx=jxi*ITRWRD
            ndx=jxi*nsamp
            call vmov( iheadr(jdx+1), 1, itr, 1, ITRWRD)
            call vmov( udt(ndx+1), 1, itr(ITHWP1), 1, nsamp )
            call wrtape( luout, ITR, nbyout )
 540     continue
C---------------------------------------
C     END LOOP OVER INPUT RECORDS
C---------------------------------------
         jrec=jrec+1
      end do  

c------------------------
c  pass remainder of recs

      nbytes = nbyout
      call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999

      call lbclos(luin)
      call lbclos(luout)
      STOP

 999  continue

      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*) ' Abnormal Termination'
      write(LER,*) 'smedian: Abnormal Termination'
      stop
      END

      subroutine help(LER)
      write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'SMEDIAN - Apply 2D moving average(median) smoothing'    
      write(LER,*)
      write(LER,*)
     :'execute SMEDIAN by typing SMEDIAN followed by command line',
     :' parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
        write(LER,*)
     :' -N [ntap]  (default - pipe input)  : input data file name'
        write(LER,*)
     :' -O [otap]  (default - pipe output) : output data file name'
       write(LER,*)' '
       write(LER,*)
     :' -rs[irs]   (default = first)       : start record number'
       write(LER,*)
     :'                                      to process, earlier '
       write(LER,*)
     :'                                      records passed '
       write(LER,*)
     :'                                      untouched '
       write(LER,*)
     :' -re[ire]   (default = last)        : end record number'
       write(LER,*)
     :'                                      to process, later '
       write(LER,*)
     :'                                      records passed '
       write(LER,*)
     :'                                      untouched '
       write(LER,*)
     :' -xsm[xsmth] (default = 0)          : half the spatial window'
       write(LER,*)
     :'                                      length, in traces'
       write(LER,*)
     :' -zsm[zsmth] (default = 0)          : half the temporal window'
       write(LER,*)
     :'                                      length, in samples'
       write(LER,*)
     :' -median     (def = arith mean)   : use median smoothing'
       write(LER,*)
     :' -geom       (def = arith mean)   : use geometric mean smoothing'
       write(LER,*)
     :' -harm       (def = arith mean)   : use harmonic mean smoothing'
       write(LER,*)
     :' -st         (def = no)           : input data stacked'
       write(LER,*)
     :' -V                               : -V for verbose output.'
       write(LER,*)
     :'***************************************************************'
      return
      end
C***********************************************************************
      subroutine gcmdln(ntap, otap, irs, ire, ismthx, ismthz,
     :   verbos, mean, angle,stack,name,geom,harm,median)
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*),name*(*)
      integer irs, ire
      logical verbos,mean,angle,stack,median,geom,harm
      integer argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
*           call argi4 ( '-ns', ns ,   0  ,  0    )
*           call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4('-xsm', ismthx, 0, 0)
            call argi4('-zsm', ismthz, 0, 0)

            if (ismthx .eq. 0 .AND. ismthz .eq. 0) then
               write(LERR,*)'FATAL ERROR in smedian:'
               write(LERR,*)'Smoothing orders -xsm[] and -zsm[] cannot'
               write(LERR,*)'both be zero'
               write(LER ,*)'FATAL ERROR in smedian:'
               write(LER ,*)'Smoothing orders -xsm[] and -zsm[] cannot'
               write(LER ,*)'both be zero'
               call ccexit (666)
            endif

            verbos = ( argis( '-V' ) .gt. 0 )
            angle = ( argis( '-angle' ) .gt. 0 )
            mean = .true.
            median = ( argis( '-median' ) .gt. 0 )
            geom   = ( argis( '-geom' ) .gt. 0 )
            harm   = ( argis( '-harm' ) .gt. 0 )
            if(median) then
               mean   = .false.
               geom   = .false.
               harm   = .false.
            endif
            if(geom) then
               mean   = .false.
               median = .false.
               harm   = .false.
            endif
            if(harm) then
               mean   = .false.
               median = .false.
               geom   = .false.
            endif
            stack = ( argis( '-st' ) .gt. 0 )
C **********************************************************************
C ***** check for extraneous arguments and abort if found **************
C ***** (catch all manner of user typo's) ******************************
C **********************************************************************

        call xtrarg (name, ler, .FALSE., .FALSE.)
        call xtrarg (name, lerr, .FALSE., .TRUE.)


c
      return
      end
C***********************************************************************
c
        subroutine verbal
     :      (nsamp, nsi, ntrc, nrec, iform,ntap,otap,ismthx,ismthz,
     :              irs,ire,ns,ne,mean,median,geom,harm)
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform,irs,ire,ns,ne
      character ntap*(*), otap*(*)
      logical   mean,median,geom,harm
 
            write(LERR ,*)' '
            write(LERR ,*)' line header values after default check '
            write(LERR, *) ' # of samples/trace =  ', nsamp
            write(LERR ,*) ' sample interval    =  ', nsi
            write(LERR ,*) ' traces per record  =  ', ntrc
            write(LERR, *) ' records per line   =  ', nrec
            write(LERR ,*) ' format of data     =  ', iform
            write(LERR ,*) ' input data         =  ', ntap
            write(LERR ,*) ' output data set    =  ', otap
            write(LERR ,*)' '
            write(LERR ,*)' Program Run Parameters '
            write(LERR, *) ' xsmooth   =  ', ismthx
            write(LERR, *) ' zsmooth   =  ', ismthz
            write(LERR, *) ' First Rec =  ', irs
            write(LERR, *) ' Last Rec  =  ', ire
            write(LERR, *) ' First Tr  =  ', ns
            write(LERR, *) ' Last Tr   =  ', ne
            write(LERR, *) ' '
            if (median) then
              write(LERR, *) ' Using median smoother'
            elseif (geom) then
              write(LERR, *) ' Using geometric mean smoother'
            elseif (harm) then
              write(LERR, *) ' Using harmonic mean smoother'
            elseif (mean) then
              write(LERR, *) ' Using arithmetic mean smoother'
            endif
            write(LERR, *) ' '
            return
            end
