C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln(ntap,otap,htap,irs,ire,ns,ne,HorWord,LIWord,
     :     DIWord,LIinit,DIinit,LIinc,DIinc,pad,decrement,verbos)

#include <f77/iounit.h>

      integer     irs, ire, ns, ne, LIinit, DIinit
      integer     argis

      real        LIinc,DIinc,pad

      character   ntap*(*), otap*(*), htap*(*)
      character   HorWord*(*), LIWord*(*), DIWord*(*)

      logical     decrement, verbos
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present

      decrement =   (argis('-decrement') .gt. 0)
      call argi4 ( '-dstart', DIinit ,   1  ,  1    )
      call argr4 ( '-dinc', DIinc ,   1.  ,  1.    )
      call argstr( '-Dw', DIWord, 'TrcNum', 'TrcNum' )

      call argstr( '-Hw', HorWord, 'STOP', 'STOP' )

      call argi4 ( '-lstart', LIinit ,   1  ,  1    )
      call argr4 ( '-linc', LIinc ,   1.  ,  1.    )
      call argstr( '-Lw', LIWord, 'RecNum', 'RecNum' )
      call argstr( '-L', htap, ' ', ' ' )

      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )
      call argr4 ( '-pad', pad ,   0.  ,  0.    )
 
      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )
      
      verbos =   (argis('-V') .gt. 0)
      
      if(HorWord.eq.'STOP')then
         write(LERR,*)' '
         write(LERR,*)'LMHORIZON: You must specify a trace header'
         write(LERR,*)'          entry -Hw on the command line.'
         write(LERR,*)'          Since there is no way to know if'
         write(LERR,*)'          you are loading a datum or horizon'
         write(LERR,*)'          there is no possible default for '
         write(LERR,*)'          this parameter.  Enter a mneumonic'
         write(LERR,*)'          on the command line and try again.'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'LMHORIZON: You must specify a trace header'
         write(LER,*)'          entry -Hw on the command line.'
         write(LER,*)'          Since there is no way to know if'
         write(LER,*)'          you are loading a datum or horizon'
         write(LER,*)'          there is no possible default for '
         write(LER,*)'          this parameter.  Enter a mneumonic'
         write(LER,*)'          on the command line and try again.'
         write(LER,*)' '
         stop
      endif
 
      return
      end
 
