C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c does an XY regridding of each input record using a bilinear interpolation
c writes the results to an output file

c Changes: Sept 96: Garossino
c                   fixed arrays indexing.  First index had to be samples,
c                   was traces which caused program to screw-up when 
c                   nsamp .ne. ntrc.  Had to fix Index1 and 2 galloc and
c                   change order of nsamp and ntrc reference in call to 
c                   rsamp2d subroutine.
 
c Changes: Aug 02: Wade
c		    Added ikp "smart". Changed error message output from
c		    unit LOT (stdout) to LERR & LER, the printout file
c		    and stderr, respectively.
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
c     integer     itr ( SZLNHD )
      integer     itr

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     abort, errcd1, errcd2, errcd3
      integer     nsinc, bc, ipass, nsmpo, ntrco
      real        lastx, lasty
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1, bigar2, tmparr
      real        x1, y1, rem1, rem2, sys1, sys2
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkadr3, tmparr(1))
      pointer     (wkadrx, x1    (1))
      pointer     (wkadry, y1    (1))
      pointer     (wkrem1, rem1  (1))
      pointer     (wkrem2, rem2  (1))
      pointer     (wksys1, sys1  (1))
      pointer     (wksys2, sys2  (1))
      pointer     (wkitr, itr  (1))

      integer     mask1, mask2, index1, index2
      pointer     (wkmask1, mask1 (1))
      pointer     (wkmask2, mask2 (1))
      pointer     (wkindex1,index1(1))
      pointer     (wkindex2,index2(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum
      integer     stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
c     real        tri ( SZLNHD )
      real        tri
      real        oxi, oyi, oxo, oyo, dxi, dyi, dxo, dyo
      character   ntap * 256, otap * 256, name*5
      logical     verbos, heap1, heap2, heap3, blin
      logical     do_x, do_y, inverse, zero, velocity
      logical     ikp
      integer     argis,in_ikp
      pointer     (wktri,tri(1))
 
      data lbytes / 0 /, nbytes / 0 /, name/'XYTRP'/
      data abort /0/
      data do_x /.false./
      data do_y /.false./
 
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0)then
         call help()
         stop 100
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln( ntap, otap, dxi, dxo, dyi, dyo, nsinc, bc,
     1     oxi, oyi, oxo, oyo, inverse, zero, blin, verbos, velocity)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
      ikp = .false.
      if(in_ikp().eq.1)ikp=.true.
      if (ikp .and. (luin .eq. 0)) then
         call sislgbuf(luin,"off")
      endif
      if (ikp .and. (luout .eq. 1)) then
         call sislgbuf(luout,"off")
      endif

      ierr = 0
      imem = 0
      call galloc (wkitr, SZLNHD*SZSMPD, ierror, abort)
      ierr = ierr + ierror
      imem = imem + nsmpo*SZSMPD
      if (ierr .ne. 0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace:'
        write(LERR,*) imem,'  bytes'
	go to 999
      else
        write(LERR,*)' '
        write(LERR,*)'Allocating workspace:'
        write(LERR,*) imem,'  bytes'
      endif
 
c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'xytrp: no header read from unit ',luin
         write(LER,*)'FATAL'
         write(LERR,*)'xytrp: no header read from unit ',luin
         write(LERR,*)'FATAL'
         go to 999
      endif
 
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 5, LERR)
 
c-----
c     from input/output cell dimensions determine the output
c     grid dimensions
c     the input grid is made up of input records, each input
c     trace being called a "line". lines run along the Y-axis
c     with a sample every dyi. on input there will be "nsamp"
c     elements in each line.
c     successive lines move along the X-axis with spacing dxi. on
c     input there will be "ntrc" lines.
c-----

         if (dxo .ne. dxi .OR. oxo .ne. oxi) do_x = .true.
         if (dyo .ne. dyi .OR. oyo .ne. oyi) do_y = .true.
         lastx = float(nsamp  - 1) * dxi + oxi
         lasty = float(ntrc - 1) * dyi + oyi
         ntrco = nint ( (lasty - oyo) / dyo) + 1
         nsmpo = nint ( (lastx - oxo) / dxo) + 1

c-----
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumSmp', nsmpo, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)

      call savew(itr, 'MnLnIn', 1    , LINHED)
      call savew(itr, 'MxLnIn', ntrco, LINHED)
      call savew(itr, 'MnDpIn', 1    , LINHED)
      call savew(itr, 'MxDpIn', nsmpo, LINHED)
      call savew(itr, 'NTrLnS', nsmpo ,LINHED)
      idyo = dyo
      idxo = dxo
c - these are float values in the header, NOT integer
c - j.m.wade - 8/22/2002
c     call savew(itr, 'ILClIn', idyo  ,LINHED)
c     call savew(itr, 'CLClIn', idxo  ,LINHED)
      call savew(itr, 'ILClIn', dyo  ,LINHED)
      call savew(itr, 'CLClIn', dxo  ,LINHED)
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
      call wrtape ( luout, itr, lbyout  )
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsmpo * SZSMPD
 
c---------------------------------------------------
c  malloc big data  space we're going to use
      heap1 = .true.
      heap2 = .true.
      heap3 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      item1 = ntrc  * nsamp  * SZSMPD
      item2 = ntrco * nsmpo  * SZSMPD
      item3 = ntrc * nsmpo  * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadr1, item1, errcd1, abort)
      call galloc (wkadr2, item2, errcd2, abort)
      call galloc (wkadr3, item3, errcd3, abort)
 
      if (errcd1 .ne. 0) heap1 = .false.
      if (errcd2 .ne. 0) heap2 = .false.
      if (errcd3 .ne. 0) heap3 = .false.
 
      if (.not.heap1 .or. .not.heap2 .or. .not.heap3) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LER ,*) item3,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
c malloc more arrays
 
         ierr = 0
         imem = 0
         call galloc (wkadrx, nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*SZSMPD
         call galloc (wkadry, ntrco*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + nsmpo*SZSMPD
         call galloc (wksys1, ntrc*nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*nsamp*SZSMPD
         call galloc (wksys2, ntrco*nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*nsmpo*SZSMPD
         call galloc (wkrem1, nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*SZSMPD
         call galloc (wkrem2, ntrco*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + nsmpo*SZSMPD

         call galloc (wkmask1 , nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + nsmpo*SZSMPD
         call galloc (wkmask2 , ntrco*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*SZSMPD
         call galloc (wkindex1, nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + nsmpo*SZSMPD
         call galloc (wkindex2, ntrco*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + ntrco*SZSMPD
         call galloc (wkitr, SZTRHD+(nsmpo*SZSMPD), ierror, abort)
         ierr = ierr + ierror
         imem = imem + SZTRHD+(nsmpo*SZSMPD)
         call grealloc (wktri, nsmpo*SZSMPD, ierror, abort)
         ierr = ierr + ierror
         imem = imem + nsmpo*SZSMPD

         if (ierr .ne. 0) then
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) imem,'  bytes'
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) imem,'  bytes'
	    go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) imem,'  bytes'
         endif
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  dxi,dxo,dyi,dyo,ntap,otap,
     2                  ntrco,nsmpo,blin,do_x,do_y,oxi,
     3                  oxo,oyi,oyo,inverse,zero)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read X-Y data, interpolate, write X-Y data
c-----
      ipass = 1
c-----
c     process desired trace records
c-----
      DO  JJ = 1, nrec
 
          ic = 0
          do  kk = 1, ntrc
 
              nbytes = 0
              call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'  rec= ',jj,'  trace= ',kk
                 go to 999
              endif
              call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

c------
c     use previously derived pointers to trace header values
              call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    recnum , TRACEHEADER)
              call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    trcnum , TRACEHEADER)
              call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    stacor , TRACEHEADER)
c------
              if (stacor .eq. 30000) then
                  call vclr (tri,1,nsamp)
              endif
 
c----------------------
c  pack data into array
              ic = ic + 1
              istrc = (ic-1) * nsamp
              call vmov (tri,1, bigar1(istrc+1),1, nsamp)
 
          enddo
 
c-----------------------
c  here's the meat...
c  2D X-Y interpolation
c  using either bilinear
c  or 2S sinc
 
          call vclr  (bigar2, 1, nsmpo*ntrco)

          call vclr  (tmparr, 1, nsmpo*ntrc)

          call rsamp2d ( nsamp, ntrc, ipass, nsmpo, ntrco, oxi, oyi,
     1         dxi, dyi, dxo, dyo, oxo, oyo, nsinc, bc,
     2         bigar1, bigar2, tmparr, index1, index2,
     3         x1, y1, rem1, rem2, sys1, sys2, mask1, mask2,
     4         do_x, do_y, inverse, zero, blin )
 
c-----------------------
 
c---------------------
c  extract traces from
c  output array and
c  write output data
          do  kk = 1, ntrco
 
              istrc = (kk-1) * nsmpo
              call vmov (bigar2(istrc+1), 1, itr(ITHWP1), 1, nsmpo)

              call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    kk     , TRACEHEADER)
              call wrtape (luout, itr, obytes)
 
 
          enddo
 
 
      ENDDO
 
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)' Normal Termination '
      write(LERR,*)'processed',nrec,' record(s)',' with ',ntrc,' traces'
      write(LER,*)' '
      write(LER,*)'xytrp, Normal Termination'
      stop 0
    
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)' Abnormal Termination '
      write(LERR,*)'processed',nrec,' record(s)',' with ',ntrc,' traces'
      write(LER,*)' '
      write(LER,*)'xytrp, Abnormal Termination'
      write(LER,*)'end of xytrp, processed',JJ,' record(s)',
     :     ' with ',KK, ' traces'
      stop  100
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'xytrp does X-Y regridding or rebinning on a seismic record'
        write(LER,*)
     :'      (usually time slice data)'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute xytrp by typing xytrp and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -dxi[dxi]    (default = none)  : input delta X [sample spacing]'
        write(LER,*)
     :' -dxo[dxo]    (default = none)  : output delta X[sample spacing]' 
        write(LER,*)
     :' -dyi[dyi]    (default = none)  : input delta Y [trace spacing]'
        write(LER,*)
     :' -dyo[dyo]    (default = none)  : output delta Y[trace spacing]'
        write(LER,*)
     :' -oxi[oxi]    (default = 0.0)   : input X origin'
        write(LER,*)
     :' -oyi[oyi]    (default = 0.0)   : input Y origin'
        write(LER,*)
     :' -oxo[oxo]    (default = 0.0)   : output X origin'
        write(LER,*)
     :' -oyo[oyo]    (default = 0.0)   : output Y origin'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -B  include on cmnd line if fast bilinear interpolation, else'
        write(LER,*)
     :'     planer sinc interpolator used'
        write(LER,*)
     :' -vel  interpolating velocity, Q, etc data sets (non seismic)'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   xytrp -N[] -O[] -dxi[] -dxo[] -dyi[] -dyo[]'
        write(LER,*)
     :'               [ -oxi[] -oyi[] -oxo[] -oyo[] -B -vel -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln( ntap, otap, dxi, dxo, dyi, dyo, nsinc, bc,
     1     oxi, oyi, oxo, oyo, inverse, zero, blin, verbos, velocity)

#include <f77/iounit.h>

      character   ntap*(*), otap*(*)
      real        dxi,dxo,dyi,dyo,oxi,oyi,oxo,oyo
      logical     blin, inverse, zero, verbos, velocity
      integer     argis, nsinc, bc
 

      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argr4 ( '-dxi', dxi ,   0.  ,  0.    )
      call argr4 ( '-dxo', dxo ,   0.  ,  0.    )
      call argr4 ( '-dyi', dyi ,   0.  ,  0.    )
      call argr4 ( '-dyo', dyo ,   0.  ,  0.    )
      call argr4 ( '-oxi', oxi ,   0.  ,  0.    )
      call argr4 ( '-oyi', oyi ,   0.  ,  0.    )
      call argr4 ( '-oxo', oxo ,   0.  ,  0.    )
      call argr4 ( '-oyo', oyo ,   0.  ,  0.    )
      call argi4 ( '-ns', nsinc ,  8   ,  8     )
      call argi4 ( '-bc',   bc  ,  0   ,  0     )

            velocity =   (argis('-vel') .gt. 0)
            inverse =   (argis('-I') .gt. 0)
            zero    =   (argis('-Z') .gt. 0)
            blin    =   (argis('-B') .gt. 0)
            verbos  =   (argis('-V') .gt. 0)

      if (velocity) blin = .true.

      if (dxi .eq. 0.) then
         write(LERR,*)'xytrp: FATAL ERROR'
         write(LERR,*)'Must enter input delta x using -dxi[]'
         write(LER ,*)'xytrp: FATAL ERROR'
         write(LER ,*)'Must enter input delta x using -dxi[]'
         stop 100
      endif
      if (dxo .eq. 0.) then
         write(LERR,*)'xytrp: FATAL ERROR'
         write(LERR,*)'Must enter output delta x using -dxo[]'
         write(LER ,*)'xytrp: FATAL ERROR'
         write(LER ,*)'Must enter output delta x using -dxo[]'
         stop 100
      endif
      if (dyi .eq. 0.) then
         write(LERR,*)'xytrp: FATAL ERROR'
         write(LERR,*)'Must enter input delta y using -dyi[]'
         write(LER ,*)'xytrp: FATAL ERROR'
         write(LER ,*)'Must enter input delta y using -dyi[]'
         stop 100
      endif
      if (dyo .eq. 0.) then
         write(LERR,*)'xytrp: FATAL ERROR'
         write(LERR,*)'Must enter output delta y using -dyo[]'
         write(LER ,*)'xytrp: FATAL ERROR'
         write(LER ,*)'Must enter output delta y using -dyo[]'
         stop
      endif
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  dxi,dxo,dyi,dyo,ntap,otap,
     2                  ntrco,nsmpo,blin,do_x,do_y,oxi,
     3                  oxo,oyi,oyo,inverse,zero)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, ntrco, nsmpo
      character   ntap*(*), otap*(*)
      real        dxi,dxo,dyi,dyo,oxi,oxo,oyi,oyo
      logical     blin,inverse,zero,do_x,do_y
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input delta Y      =  ', dyi
            write(LERR,*) ' output delta Y     =  ', dyo
            write(LERR,*) ' output # Y-cells   =  ', ntrco
            write(LERR,*) ' input delta X      =  ', dxi
            write(LERR,*) ' output delta X     =  ', dxo
            write(LERR,*) ' input X origin     =  ',oxi
            write(LERR,*) ' input Y origin     =  ',oyi
            write(LERR,*) ' output X origin    =  ',oxo
            write(LERR,*) ' output Y origin    =  ',oyo
            write(LERR,*) ' output # X-cells   =  ', nsmpo
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (do_x .AND. .not.do_y) then
            write(LERR,*) ' interpolating in X-direction'
            elseif (do_y .AND. .not.do_x) then
            write(LERR,*) ' interpolating in Y-direction'
            elseif (do_x .AND. do_y) then
            write(LERR,*) ' interpolating in 2D'
            endif
            if (blin) then
            write(LERR,*) ' using bilinear interpolation'
            else
            write(LERR,*) ' using 2D sinc interpolation'
            endif
            if (inverse) then
            write(LERR,*) ' interpolating reciprocal input data'
            endif
            if (zero) then
            write(LERR,*) ' zero out edges of interpolation'
            endif
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
