C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
CABCD 123456  version f3 Jan1989
C***********************************************************************
C                  COMMON MIDPOINT MIGRATION AFTER STACK
C***********************************************************************
C    Author:   N. D. Whitmore, Jr.
C
C    Revised:  Mary Ann Thornton   9/10/91
C              Moved code to sun for maintenance/distribution
C              Changes are to include 4 header files and add calls to
C              saver and savew for retrieving or storing lineheader and
C              trace header values.  One include file is to date stamp
C              the printout at run time with the last revised date.
C              subroutines velscn, dskmtx,czero were unused and removed.
C    Revised:  Jim Childress       l/08/92
C              Initialized variables in data statements 
C    Revised:  N. D. Whitmore, Jr. 1/29/92
C              changed ixseg, IXSEGM, ixmax to allow migration of more
C              traces per line, but in x-segments
C    Revised:  Mary Ann Thornton   2/06/92  Version 2.3
C              changed ixseg back to 1 unless the length (after      
C              expansion exceeds 2000, then make ixseg = 2
C              this limit is because local memory is limited to 2048
C              and assembler routine uses local memory
C    Revised:  N.D. Whitmore, Jr.  2/07/92  Version 2.4
C              Changed code to allow up to 4 segments, checking the   
C              length of each segment as it is calculated (after the
C              xpand factor and percentage of overlap is added). The
C              limit is 2048.
C    Revised:  Mary Ann Thornton   3/25/92  Version 2.5
C              Call openpr with fullname of program for
C              compatibility with new OS6.1 on Cray2.
C    Revised:  Mary Ann Thornton   4/28/92  Version 2.6
C              Make the VEL array longer in the z direction in the
C              subroutine genvel. 
C    Revised:  Mary Ann Thornton   7/20/92  Version 2.7
C              Put in a check in GENVEL to give a message and stop if
C              the trace spacing and depth spacing for the velocity
C              tape has not been defined (either by line header or 
C              by the command line entries.)
C    Revised:  N.D. Whitmore, Jr.  8/07/92  Version 2.8
C              Changed first lines of velocity matrix
C    Revised:  Mary Ann Thornton   8/13/92  Version 3.0
C              Converted code to run on a 32 bit machine
C    Revised:  N.D. Whitmore, Jr.  12/18/92  Version 3.1
C              Put in an extra check for msk1         
C    Revised:  M.A. Thornton       02/01/93  Version 3.2
C              Make the horizontal segment size 4096 and call
C              the new routine FXCONT to replace CCONT
C              Add 4 new work arrays (using galloc) in XDCIMC
C    Revised:  M.A. Thornton       04/23/93  Version 3.3
C              Corrected subroutine xdcimc to call galloc only the first 
C              time through the subroutine.
C              Changed line header size to SZLNHD, added logical unit for
C              HP, changed nastat (msk) and istatstep (iextrp) to be hidden
C              command line arguments rather than reading from the cards.
C    Revised:  M.A. Thornton       04/23/93  Version 3.4
C              Moved the dummy array definition and the pointers to the 
C              main, passing the pointers to the appropriate subroutines,
C              allocating the space in xdcimc routine.
C    Revised:  M.A. Thornton       05/29/93  Version 3.5
C              Correct an error in a call to vmov in subroutine xfsmp   
C              (not enough parameters in the call/subr. never called)   
C    Revised:  Mary Ann Thornton     10/01/93  Version 4.0
C              Corrected the size of the 4 dynamically allocated arrays
C              (size based on aperture which changed from one call to
C              the next - chose largest ever allowed to use in calculation)
C              Corrected the size of an array ixp.
C              Changed size of maxnt from 3839 to maxna*maxnv
C              Moved some subroutines into separate files so the compile
C              could finish without running out of memory.
C              Removed unused subroutines xfsmp and flint and openzz
C              Added auditing.
C    Revised:  Mary Ann Thornton     11/09/93  Version 4.1
C              Added a zero depth point (see cmimag.F)
C    Revised:  Gary Murphy           12/13/93  Version 4.2
C              Added dx and dz to output line header (The actual change
C              was in fxcmsubs.F.
C    Revised:  Mary Ann Thornton     01/07/94  Version 4.3
C              Change to use dx (rather than dx0) for Dx1000 in line header
C              Add command line arguments to line header
C    Revised:  Mary Ann Thornton     02/16/94  Version 4.4
C              Program was failing on a line with 3526 traces. An array
C              work(6032) was changed to be work(4096*2) to accommodate
C              the limit of 4096 traces per horizontal segment.
C              (work is used for complex data,
C              izmax was changed from 100 to 105 so (2*izmax*izsegm)
C              would be >= 4096 (horizontal segment trace limit) 
C              The auditing was removed.
C    Revised:  Mary Ann Thornton     02/17/94  Version 4.5
C              The check for nabot limits was corrected, and a write    
C              statement added to show a change when natop/nabot exceeded
C              program limitation.
C    Revised:  Mary Ann Thornton     02/17/94  Version 4.6
C              The genvel routine was changed to keep checking the x and z
C              limits of the velocity array until it was within the limits
C              of the program.
C************************************************************************
#include <localsys.h>
#include <f77/hp.h>
	real itime, jtime
	integer icount, jcount
	common /debug/icount, jcount, itime, jtime
	data icount/0/, jcount/0/, itime/0./, jtime/0./
C PARAMETER AND DIMENSION STATEMENTS COMMON BLOCKS AND DATA STATEMENTS

      PARAMETER (THETA=89.,IMG=1,EPSLN=.3)

C * * * BEGIN MEMORY SPACE ALLOCATION * * * * * *

C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
CCCy  note ixmax must be a power of 2
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      data IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
     &    /0,    0,  0,   0,    0,    0,    0,    0,    0/
      data XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
     &    /0.,   0.,0.,   0., 0.,    0.,  0.,   0./
      data IXLN, IXLN0,IXLN1 /IXSEGM*0, IXSEGM*0, IXSEGM*0/
      data IXBIAS,IXST,IXST0 /IXSEGM*0, IXSEGM*0, IXSEGM*0/

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER*2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

C     data ISYS,IFMT,ITPFMT,MTXNAM,LINNUM/0,0,0,2*0,2*0/
      data ITPFMT,MTXNAM,LINNUM/0,2*0,2*0/

      data PRAY/0./, VELREF/0./

c     data MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT/0, 0, 0, 0, 0, 0, 0/
      data MSK,NA,NV,NATOP,NABOT/0, 0, 0, 0, 0/

      data VELRFL,VELINC,SLORFL,SLOINC/50*0.,50*0.,50*0.,50*0./
      data ANGL/JBMAX*0./

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------

      INTEGER INDREC(IXMAX*IXSEGM)

C * * * PWMBS COMMON (END) * * * *

c * * DATA ARRAYS NOT IN COMMON * *



C     WORK SPACE
      
CMAT      Parameter (NWORK=6064)
Cmat    This work area needs to be large enough to accomodate 
cmat    up to 4096 traces (ixmax is 4096)
      Parameter (NWORK = 4096*2 )
      REAL WORK1(nwork),WORK2(nwork),WORK3(nwork)
      COMPLEX CWORK1(nwork/2),CWORK2(nwork/2),CWORK3(nwork/2)
      REAL TRAMP(NSMAX)
CCCy  mixed radix fft tables -- (do not use for other space)
      integer ifftab(nwork)
      real    rfftab(3*nwork/2)

c     number of velocities per depth segment
      integer numvel(izsegm)

c     reciprocical of velocities per depth segment
      parameter (maxnv=63,maxna=65)
      real slop(maxnv,izsegm)

Cmat  velist, gwrk1,gwrk2,gwrk3,gwrk4,gwrk5,ivv,ivv2,ivp2,
CMAT  ixp,ixp2,map,gxr1,gxr2,sxr1,sxr2 all used in 
cmat  cmimag
      real velist(300*maxnv)
      REAL    GWRK1( 3*maxnv*(maxna+1) ),
     &        GWRK2( 2*maxna-1 ),
     &        GWRK3( maxnv*(maxna+1) ),
     &        GWRK4( maxnv*(maxna+1) ),
     &        GWRK5( maxna*maxna ), WORK(4*IXMAX)
      integer ivv (izmax*maxnv),    ivp2(izmax+1),
     &        ivv2(izmax*maxnv),
     &        ixp (izmax*maxnv+1),
     &        ixp2(izmax*maxnv+1),
     &        map(maxnv) 
      real    gxr1(ixmax+1, maxna), gxr2(ixmax+1,maxna),
     &        sxr1(ixmax+1, maxna), sxr2(ixmax+1,maxna)
cmat
      real  wpr(1),wnr(1),wni(1),wpi(1)
      pointer (ppwpr,wpr),(ppwnr,wnr),(ppwni,wni),(ppwpi,wpi)
      
c

      EQUIVALENCE(WORK1(1),CWORK1(1)),(WORK2(1),CWORK2(1))
      EQUIVALENCE(WORK3(1),CWORK3(1))

C     MINIMUM AND MAXIMUM VELOCITIES
      REAL VMIN(IZSEGM),VMAX(IZSEGM)

C     DOWNWARD CONTINUATION ARRAYS
      COMPLEX CRFL(IXMAX),CINC(IXMAX)

C     2D complex transpose array
      COMPLEX CIMAGE(IXMAX*IWMAX)

C     RESAMPLING ARRAYS
      INTEGER IXRSMP(IXMAX*4)
      REAL XRSMP(IXMAX*4)

      INTEGER IERR
      DATA IERR/0/


C    ASSIGN DEFAULTS NOT GIVEN BY PARAMETER STATEMENTS

C    PI:
                 DATA PI/3.14159265/


C    LOGICAL UNITS (COMMON: LUNITS)
                 DATA LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
     &               /   1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
     &                   8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
     &                  15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
     &                  22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
     &                  55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99 /

C    APERTURE CONTROL:
                 DATA NAPMIN,NAPMAX/1,65/

C    SYSTEM CONTROL (CMS=1,PE=0,CRAY=2)
                 DATA ISYS/2/

C    INTERNAL DATA FORMAT:
                 DATA IFMT/3/
C * * * END MEMORY SPACE ALLOCATION * * * * * * *


C * * * * * * * * * * EXECUTION BEGINS  * * * * * * * * * * * * * * * *



   

C   $ $ $ $ $ $     INITIALIZATION PHASE      $ $ $ $ $ $
C
      write(ler,*) 'F-X COMMON MIDPOINT DEPTH MIGRATION'

C $ $ $ $ $ $ $ $   PARAMETERIZATION PHASE     $ $ $ $ $ $


C    OPEN INPUT TAPE
C     READ INPUT CARDS
C      COMPUTE JOB CONSTANT PARAMETERS AND LOOP CONTROL
C       OPEN OUTPUT TAPE
       write(0,*) 'IFMT= ', IFMT
       write(0,*) 'ISYS= ', ISYS

cv6
      CALL CMJOBP ( BMWTHR, IDIPZ, PRCNT ,iextrp ,ixtap ,
     &              LUV, DXTAP , DZTAP )

C    TAPES OPEN,  CARDS READ, LOOP CONTROL DETERMINED



C   $ $ $ $ $ $ $      EXECUTION PHASE         $ $ $ $ $ $
C


C    COMPUTE VELOCITY INDEX MATRIX and velocity tables

cv8d   WRITE(LUPRT,*) 'GENERATING VELOCITY INDEX MATRIX'
c      write(ler,*) 'before genvel'
       CALL GENVEL(IERR,VMIN,VMAX,SLOP,NUMVEL,velist,
     &             indrec,DXTAP,DZTAP,maxna,maxnv,LUV)
c      write(ler,*) 'after genvel'
       IF(IERR.NE.0) THEN
        WRITE(LUPRT,*) 'ERROR IN GENERATING DIGITIZED MODEL'
        CALL CCEXIT(100)
       ENDIF

C     ALLOCATE DISK WORK FILES


c        WRITE(LUPRT,*) 'ALLOCATING DIRECT ACCESS DISK FILES'

C         OPEN LUHDR
          nsmp=ITRWRD
          OPEN(UNIT=LUHDR,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         OPEN LUDAT
          NSMP=IWMAX*2
          OPEN(UNIT=LUDAT,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         OPEN LURFL
          NSMP=IXMAX*2
          OPEN(UNIT=LURFL,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         LUINC
          NSMP=IXMAX*2
          OPEN(UNIT=LUINC,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)



c     WRITE(LUPRT,*) 'SKIPPING LEAD IN TRACES'
C * * * * * * * SKIP OVER  IXBLK*IXSKP  INPUT TRACES  * * * * * * * * *
C *
      ISKIP=IXBLK*IXSKP
c     WRITE(LUPRT,*) 'IXBLK,IXSKP,ISKIP=',IXBLK,IXSKP,ISKIP
      IF(ISKIP.GT.0) CALL SKIPT(LU14,ISKIP)
C *
C * * * * * * * *  TRACE SKIPPING COMPLETED   * * * * * * * * * * *
C
C * * * * * * * * * * *  PROCESS DATA * * * * * * * * * * * * * * *

C     LOOP 10: OVER BLOCKS (RECORDS)

      DO 10 JBLK=1,JXBLK

C      COMPUTE BLOCK DEPENDENT PARAMETERS/VECTORS
c      WRITE(LUPRT,*)'BLOCK(RECORD)=',JBLK
       WRITE(LUPRT,*)'              '
       CALL PWBLKP(JBLK)
C***   WRITE(LUPRT,*) 'BLOCK PARAMETERS BUILT'
Cmat   NWBYT is multiplied by 8, used in call dawrte, where it is 
Cmat   divided by 4 (this particular variable used to write complex
Cmat   words)
       NWBYT=NW*8

C      READ TRACE, WRITE HEADERS TO DISK, DFT DATA AND EITHER:
C      WRITE (OMEGA) DATA TO DISK
C      TRANSPOSE (OMEGA) DATA

       NBYTES=0
       IFLG=1
CCCy   compute the starting frequency offset (times 2) for fft
       nf0 =f0*2. + itbeg
c       build time ramp
        n1ramp = 48./dtms
        n2ramp = (tend-48.)/dtms
        n3ramp = n2ramp +48./dtms
        call rampt(tramp,n1ramp,n2ramp,n3ramp,ndft)

       DO 21 JNTR=1,JXNTR
CCCy    clear data and read trace
        if(jntr.eq.1) call vclr(data,1,(ndft+itbeg))
        CALL RTAPE(LU14,TRACE,NBYTES)
        call vmul(data(itbeg),1,tramp,1,data(itbeg),1,ndft)
         if(nbytes.le.0) then
         write(luprt,*) 'read error on input tape'
         write(luprt,*) 'trace = ',jntr
         call ccexit(100)
         endif

C       GET STATICS FROM FIRST/LAST TRACE TO COMPUTE RAY PARAMETER
        IF(JNTR.EQ.1)THEN
           CALL SAVER(ITRH, 'StaCor', I125, 1) 
           STAT1 = FLOAT(I125)/1000.
        ENDIF
        IF(JNTR.EQ.JXNTR)THEN
           CALL SAVER(ITRH, 'StaCor', I125, 1) 
           STAT2 = FLOAT(I125)/1000.
        ENDIF
C
C       fft input trace

         if(JNTR.eq.1) then
         write(luprt,*) 'itbeg,t0,tdft,f0,ndft,nw,iflg='
     &   ,               itbeg,t0,tdft,f0,ndft,nw,iflg
         endif
         call rfftmr(data(itbeg),1,ndft,iflg,ifftab,rfftab)
         call vmov(data(nf0),1,cwork1,1,nw*2)

        IF(JNTR.EQ.JXNTR/2) THEN
c        WRITE(LUPRT,*) 'AFTER DFT',JNTR
        ENDIF

C        WRITE TRACE HEADER TO DISK
Cmat     ITRWRD multiplied by 4, dawrte divides by 4
         CALL DAWRTE(JNTR,ITRH,LUHDR,ITRWRD*4)

       IF(IXSEG.GT.1 .OR. IWSEG.GT.1) THEN
C        WRITE TRANSFORMED TRACE DATA TO DISK
         CALL DAWRTE(JNTR,CWORK1,LUDAT,NWBYT)
       ENDIF

       IF(IXSEG.EQ.1 .AND. IWSEG.EQ.1) THEN
        JXW=-JXNTR+JNTR
        DO 121 JW=1,NW
        JXW=JXW+JXNTR
 121    CIMAGE(JXW) =CWORK1(JW)
       ENDIF

  21   CONTINUE

C      PRINT RAY PARAMETER COMPUTED FROM TRACE HEADERS
       PRAY1=(STAT2-STAT1)/(DX*(JXNTR-1))
c      WRITE(LUPRT,*)
c    & 'RAY PARAMETER (COMPUTED FROM TRACE HEADERS)=',PRAY1

C      RDFT'S DONE- IF ON THE PERKIN-ELMER RELEASE THE STAR PARTITION
C                   IF ON CMS CLOSE LUHDR,LUDAT

C      LOOP 20: HORIZONTAL SEGMENTS

       DO 20 IXS=1,IXSEG

c      WRITE(LUPRT,*) 'BEGIN HORIZONTAL SEGMENT',IXS
       NXLN=IXLN(IXS)
       NX=IXLN0(IXS)
       NX8=NX*8
       NXLN1=IXLN1(IXS)
       JXST=IXST(IXS)-1

C       LOOP 31: OMEGA SEGMENTS
        DO 31 IWS=1,IWSEG
c          WRITE(LUPRT,*) 'BEGIN OMEGA SEGMENT',IWS
           JW1=IWBEG(IWS)
           JW2=IWEND(IWS)
C          IF NECESSARY READ REFLECTED (OMEGA) DATA AND TRANSPOSE --
           IF(IXSEG.GT.1 .OR. IWSEG.GT.1) THEN
             DO 41 JX=1,NXLN
               KXBIAS=JX+JXST
               CALL DAREAD(KXBIAS,CWORK1,LUDAT,NWBYT)
               JXW=-NXLN+JX
               DO 141 JW=JW1,JW2
                  JXW=JXW+NXLN
  141          CIMAGE(JXW)=CWORK1(JW)
   41        CONTINUE
           ENDIF

C          LOOP 42: OVER OMEGA
C          COMPUTE INCIDENT FIELD AND DELAY REFLECTED FIELD
C          AND WRITE TO DISK
           IFLAG=0
           DO 42 JW=JW1,JW2
C            REFLECTED FIELD
             KX1=1+(JW-JW1)*NXLN
             CALL CRSMP(CIMAGE(KX1),DX ,NXLN,
     &                   CWORK2(1),DX0,NX,
     &       IXRSMP,XRSMP,IFLAG)
             IFLAG=1
C            WRITE(0,*) 'FILT,JW=',FILT(JW),JW
             DO 342 JX=1,NX
               CWORK3(JX)=filt(jw)*CWORK2(JX)
  342        CONTINUE
             CALL DAWRTE(JW,CWORK3,LURFL,NX8)
   42      CONTINUE

   31   CONTINUE
C
C      COMPUTE RIMAGE
C
#ifdef CRAYSYSTEM
       cptime1 = second()
#endif
cv6
       CALL CMIMAG (JBLK, IXS, IMG, PRCNT, EPSLN,
     &   INDREC, CINC, CRFL, BMWTHR, IDIPZ, VMIN, VMAX, iextrp,ixtap ,
     &            numvel , slop,maxna,maxnv,gwrk1,gwrk2,gwrk3,
     &            gwrk4, gwrk5, work, ivv2,ivv,ixp,ivp2,ixp2,map,
     &            gxr1,gxr2,sxr1,sxr2,
     &            ppwpr,ppwnr,ppwni,ppwpi )
#ifdef CRAYSYSTEM
       cptime2 = second()
       cptim12 = cptime2 - cptime1
       WRITE(LUPRT,*) 'CP TIME IN CMIMAG =',CPTIM12
       WRITE(    0,*) 'CP TIME IN CMIMAG =',CPTIM12
#endif
C
   20  CONTINUE
       write(luprt,*) 'completed processing record #',jblk
       write(ler,*)     'completed processing record #',jblk

C      SKIP JXSKIP TRACES:
       IF(JXSKIP.GT.0) THEN
         call skipt(lu14,jxskip)
       ENDIF


   10 CONTINUE


C * * * * * * * * DATA PROCESSING COMPLETED * * * * * * * * * * * *



C   $ $ $ $ $ $       CLOSING PHASE          $ $ $ $ $ $ $


C    CLOSE DISKS
      CALL DACLOS(LUMTX)
      CALL DACLOS(LUHDR)
      CALL DACLOS(LUDAT)
      CALL DACLOS(LURFL)
      CALL DACLOS(LUINC)

C    CLOSE TAPES
      CALL LBCLOS(LU14)
      CALL LBCLOS(LU24)

C   PROGRAM COMPLETE
       write(luprt,*) 'program complete'
       write(ler,*)     'program complete'
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)     '                '
C      write(ler,*)' icount = ', icount
C	write(ler,*)' jcount = ', jcount
C	write(ler,*)' itime = ', itime
C	write(ler,*)' jtime = ', jtime

      STOP
      END

C * * PWMBS BLOCK ( START ) * * * * * * * * * * * * * * * * * * * * *

      BLOCK DATA pwbloc
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C * * BEGIN PWMBS COMMON  * * *

C     DEPTH COMMON ---------------------------------------------------
C
C J D IZMAX=MAXIMUM NUMBER OF OUTPUT SAMPLES (PARAMETER)
C J D IZSEGM=MAXIMUM NUMBER OF VERTICAL SEGMENTS (PARAMETER)

C J R IZSEG=NUMBER OF VERTICAL SEGMENTS (DEFAULT=1)
C J C IZB(IZS)=BEGINING INDEX OF SEGMENT IZS
C J C JZROW(IZS)=NUMBER OF ROWS IN SEGMENT IZS
C J C IZLN=NUMBER OF DEPTHS EXTRAPOLATED
C J C IZXTR=NUMBER OF Z ROWS TO APPEND BELOW DIGITIZED MODEL
C J C JZLN=NUMBER OF DEPTH SAMPLES OUTPUT
C J C ZBEG(IZS)=STARTING DEPTH OF SEGMENT IZS
C J C ZEND(IZS)=ENDING DEPTH OF SEGMENT IZS
C J C DZ(IZS)=DEPTH SPACING OF SEGMENT IZS
C J I DZOUT=OUTPUT DEPTH SPACING
C J I ZMAX=MAXIMUM DEPTH (=JZLN*DZOUT)
C J R ZDEP=DEPTH OF DIGITIZED MODEL
C J C ZTABLE(IZMAX)=DEPTH TABLE OF ACTUAL DEPTHS USED IN CONTINUATION


C     WIDTH COMMON ---------------------------------------------------
C
C J D JBMAX=MAXIMUM NUMBER OF BLOCKS (PARAMETER)
C J D IXSEGM=MAXIMUM NUMBER OF HORIZONTAL SEGMENTS/BLOCK (PARAMETER)
C J D IXMAX=MAXIMUM X WIDTH (IN DX0 OR DX UNITS) (PARAMETER)

C J I IXSEG=NUMBER OF HORIZONTAL SEGMENTS/BLOCK
C J R NTR=NUMBER OF TRACES PER RECORD ON INPUT TAPE
C J R NREC=NUMBER OF RECORDS ON INPUT TAPE
C J C IXLEN=WIDTH OF INDEX DATASET (AFTER HOIZONTAL PADDING)
C J I IXBLK=NUMBER OF BLOCKS TO SKIP (DEFAULT=0)
C J I IXSKP=NUMBER OF TRACES/BLOCK TO SKIP (DEFAULT=NTR)
C J I JXBLK=NUMBER OF BLOCKS TO PROCESS
C           (DEFAULT=NREC-((IXBLK*IXSKP/NTR)
C J I JXNTR=NUMBER OF TRACES PER BLOCK TO PROCESS (DEFAULT=NTR)
C J I JXSKIP=NUMBER OF TRACES PER BLOCK TO SKIP (DEFAULT=0)
C J C IXLN(IXS)=NUMBER OF TRACES/SEGMENT TO PROCESS
C J C IXLN0(IXS)=NUMBER OF X'S/SEGMENT TO PROCESS AFTER RESAMPLING
C J C IXLN1(IXS)=NUMBER OF OUTPUT TRACES/SEGMENT
C J C IXBIAS(IXS)=(STARTING INDEX PER SEGMENT)-1
C     (IXBIAS(1)=0,IXBIAS(N)=IXBIAS(N-1)+IXLN1(N-1), N=2,IXSEG)
C J C IXST(IXS)=STARTING TRACE LOCATION (PER SEGMENT)
C J C IXST0(IXS)=STARTING MATRIX INDEX (PER SEGMENT) = IXST(IXS)/XPAND
C J I XOVPC=PER CENT OVERLAP PER SEGMENT
C J I DX=TRACE SPACING (DEFAULT=GROUP INTERVAL)
C J I XPAND=HORIZONTAL EXPANSION (OR COMPRESSION) FACTOR (DEFAULT=1.0)
C J C DX0=HORIZONTAL SPACING TO BE USED IN MIGRATION (DX0=DX*XPAND)
C J I XBEGIN=LOCATION OF FIRST TRACE RELATIVE TO THE GEOLOGIC MODEL
C            (IF XBEGIN<0, THEN THE DEPTH INDEX MATRIX IS EXTENDED
C            HOIZONTALLY BY -XBEGIN )
C J R XWTH =WIDTH OF DIGITIZED MODEL
C J D XSHOT=LOCATION OF SOURCE (RELATIVE TO A BLOCK) -- THIS IS VALID
C           ONLY WITH COMMON SHOT MIGRATION (OTHERWISE,XSHOT=0.0)
C J D XSHFT=LATERAL SHIFT OF DIGITIZED MODEL PER BLOCK-- THIS IS VALID
C           ONLY WITH COMMON SHOT MIGRATION (OTHERWISE,XSHFT=0.0)


C     TIME COMMON ------------------------------------------------------
C
C J R ISI=INTEGER SAMPLE RATE IN MS ON INPUT TAPE
C J R NSAMP=NUMBER OF TIME SAMPLES ON INPUT TAPE
C B C ITPAD=ZERO SAMPLES TO PAD ON IXS SEG. OF JBLK BLOCK
C B C NDFT=NSAMP+IPAD0=NUMBER OF SAMPLES TO DFT
C J C ITBEG=BEGINNING TIME SAMPLE TO MIGRATE (ITBEG=TBEG/DTMS+1)
C J C DTMS=SAMPLE RATE IN MS ( DEFAULT=FLOAT(ISI) OR INPUT)
C J C DT=DTMS/1000.
C J I TBEG=BEGINING TIME TO MIGRATE (MS) (DEFAULT=0)
C J I TEND=ENDING TIME TO MIGRATE (MS) (DEFAULT=END OF DATA)
C J I TPAD0=EXTRA TIME TO PAD (MS) (DEFAULT=0)
C               (=TPAD0/DTMS+ABS(PRAY)*WIDTH(JBLK)*1000.)
C B C TIMEMS=TEND-TBEG+ITPAD*DTMS
C B C TIMES=TIMEMS/1000.
C B C TDFT=NDFT=REAL NUMBER OF SAMPLES TO DFT
C J D T0=REAL STARTING SAMPLE TO DFT=0.0


C     FREQ COMMON ------------------------------------------------
C
C J C IWSEGM=MAXIMUM NUMBER OF FREQUENCY SEGMENTS (PARAMETER)
C J C IWMAX=MAXIMUM NUMBER OF FREQUENCIES (PARAMETER)

C J C IWSEG=NUMBER OF FREQUENCY SEGMENTS TO TRANSPOSE AT A TIME
C B C IWBEG(IWS)=STARTING INDEX FOR THE IWS FREQUENCY SEGMENT
C B C IWEND(IWS)=ENDING   INDEX FOR THE IWS FREQUENCY SEGMENT
C B C IWMIN=STARTING OMEGA INDEX TO PROCESS (IWMIN=1)
C B C NW=ENDING OMEGA INDEX TO PROCESS=NUMBER OF FREQUENCIES
C        (NW=(FMAX-FMIN)*TIMES)
C B C FILT( )=TRAPEZOIDAL FREQUENCY FILTER
C B C F0=REAL MININUM FREQUENCY INDEX TO DFT(=FMIN*TIMES+1.)
C J I FMIN=MINIMUM FREQUENCY TO MIGRATE
C         =POINT ONE   IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I F2  =POINT TWO   IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I F3  =POINT THREE IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I FMAX=POINT FOUR  IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C         =MAXIMUM FREQUENCY TO MIGRATE
C B C DF = CHANGE IN FREQUENCY=1/TIMES
C B C SCALF=FOURIER TRANSFORM SCALING FACTOR =DT*DF
C J C OMMIN=2*PI*FMIN =MINIMUM ANGULAR FREQUENCY TO MIGRATE
C J C OMMAX=2*PI*FMAX =MAXIMUM ANGULAR FREQUENCY TO MIGRATE
C B C DOMEGA=2*PI/TIMES =CHANGE IN ANGULAR FREQUENCY
C B C OMEGA(JWL)=ANGULAR FREQUENCY FOR INDEX JWL
C B C OMEGA(JWL)=OMMIN+(JWL-1)*DOMEGA
C J D PI=3.14159....


C     LUNITS ---LOGICAL UNITS
C J D LUSTR (=  1): ST100
C J D LUMXC (= 62): DIGITIZED MODEL
C J D LUSYS (=  3): TEMP LU TO CHECK FOR SYSTEM VOLUME WITH CHKSYS
C J D LU4   (=  4): NOT USED
C J D LUIPT (= 64): PARAMETER INPUT
C J D LUPRT (= 66): PRIMARY PRINTER OUTPUT
C J D LU7   (=  7): NOT USED
C J D LU8   (=  8): NOT USED
C J D LU9   (=  9): NOT USED
C J D LUAPX (= 10): FPS APX (MAY NOT BE USED)
C J D LUAPR (= 11): FPS APR (MAY NOT BE USED)
C J D LUAPS (= 12): FPS APRS (MAY NOT BE USED)
C J D LUAPC (= 13): FPS APC (MAY NOT BE USED)
C J D LU14  (= 14): REFLECTED FIELD TAPE INPUT (TIME)
C J D LU15  (= 15): INCIDENT FIELD TAPE INPUT (TIME- NOT USED)
C J D LU16  (= 16): NOT USED
C J D LU17  (= 17): NOT USED
C J D LU18  (= 18): NOT USED
C J D LU19  (= 19): NOT USED
C J D LU20  (= 20): NOT USED
C J D LU21  (= 21): NOT USED
C J D LU24  (= 24): DEPTH SECTION OUTPUT (DEPTH)
C J D LU25  (= 25): DOWNWARD CONTINUED INCIDENT FIELD (TIME- NOT USED)
C J D LU26  (= 26): DOWNWARD CONTINUED REFLECTED FIELD (TIME- NOT USED)
C J D LU35  (= 35): NOT USED
C J D LUMTX (= 45): VELOCITY INDEX
C J D LUHDR (= 55): TRACE HEADER
C J D LUDAT (= 65): TRACE DATA (AFTER DFT)
C J D LUINC (= 75): INCIDENT FIELD
C J D LURFL (= 85): REFLECTED FIELD
C J D LUDEP (= 95): DEPTH SECTION (NOT PRESENTLY USED)
C J D LU98  (= 98): DEPTH SECTION (NOT PRESENTLY USED)
C J D LU99  (= 99): DEPTH SECTION (NOT PRESENTLY USED)


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS

C J D NSMAX=MAXIMUM NUMBER OF TIME SAMPLES (PARAMETER)

C J D IHEAD(SZLNHD) = LINE HEADER (FULL WORDS)
CCCy
C J D THEAD(3000) = LINE HEADER (FULL WORDS)
ccms
C J D THEAD(3000) = LINE HEADER (HALF WORDS)
C J D ITRH(128) = TRACE HEADER PORTION OF TRACE
C J D TRACE(NSMAX+64)= HEADER + DATA
C J D DATA(NSMAX) = DATA PORTION OF TRACE


C     MISCL COMMON ---------------------------------------------------
C     (THIS COMMON BLOCK CONTAINS THE REMAINDER OF THE PARAMETERS AND
C     ARRAYS WHICH ARE NOT CATEGORIZED BY THE COMMON BLOCKS ABOVE)
C
C J D ISYS=SYSTEM TYPE (1=CMS, 0=PERKIN-ELMER, 2=cray) SET IN BLOCK DATA
C J D IFMT=INTERNAL FORMAT = 3
C J R ITPFMT=INPUT TAPE FORMAT (AT THIS TIME, THIS MUST BE 3)
C
C     MODEL AND LINE NUMBER
C J I MTXNAM( )=NAME OF DIGITIZED MODEL
C J R LINNUM( )=LINE NUMBER
C
C     IMAGING CONTROL PARAMETERS
C J I MSK=EXTRAPOLATION APERTURE DECREMENT (USE EVERY 'MSK' POINT)
C J I NA=NUMBER OF POINTS/(HALF APERTURE) IN MIGRATION KERNEL
C         (DEFAULT=15, SHOULD BE GREATER THAN 10, <66)
C J D NAPMIN=MINIMUM NO OF POINTS IN APERTURE
C J D NAPMAX=MAXIMUM NO OF POINTS IN APERTURE
C
C     VELOCITY PARAMETERS
C J I NV =NUMBER OF VELOCITIES
C J I VELRFL( )=REFLECTED FIELD VELOCITIES
C J I VELINC( )=INCIDENT FIELD VELOCITIES (DEFAULT VELINC=VELRFL)
C J C SLORFL( )=REFLECTED FIELD SLOWNESS (SLORFL=1./VELRFL)
C J C SLOINC( )=INCIDENT FIELD SLOWNESS (SLOINC=1./VELINC)
C J I VELREF=REFERENCE VELOCITY
C
C     ANGLE PARAMETERS
C J I ANGL(JBMAX)=BEAM ANGLE (FOR A BLOCK)
C B C PRAY=RAY PARAMETER FOR A BLOCK


C     PWMBS COMMON:


C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER *2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------

C * * END PWMBS COMMON  * * * *


C    ASSIGN DEFAULTS NOT GIVEN BY PARAMETER STATEMENTS

C    PI:
c                DATA PI/3.14159265/


C    LOGICAL UNITS (COMMON: LUNITS)
c                DATA LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
c    &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
c    &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
c    &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
c    &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
c    &               /   1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
c    &                   8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
c    &                  15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
c    &                  22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
c    &                  55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99 /

C    APERTURE CONTROL:
c                DATA NAPMIN,NAPMAX/1,65/

C    SYSTEM CONTROL (CMS=1,PE=0,CRAY=2)
c                DATA ISYS/2/

C    INTERNAL DATA FORMAT:
c                DATA IFMT/3/


C     THAT'S ALL
      END

C * * PWMBS BLOCK ( END   ) * * * * * * * * * * * * * * * * * * * * *
