/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _UtDefs_h   
#define _UtDefs_h

#include <localsys.h>

#include <mod_defs.h>

#ifndef C_COMMENTS_DISALLOWED

/* define the Fortran entry point names */

#endif

#ifdef FTN_TO_C_UPPERCASE
#define F_GALLOC GALLOC
#define F_GREALLOC GREALLOC
#define F_GCALLOC GCALLOC
#define F_GFREE  GFREE
#define F_GETPPS  GETPPS
#define F_STOINT  STOINT
#define F_STOFLT  STOFLT
#define F_CTOINT  CTOINT
#define F_INTTOC  INTTOC
#define F_ICCHAR  ICCHAR
#define F_EBCASC  EBCASC
#define F_ASCEBC ASCEBC
#define F_SISR4 SISR4
#define F_R4SIS R4SIS
#define F_FGTIME FGTIME
#define F_FGDATE FGDATE
#define F_MOVE MOVE
#define F_PIPCNT PIPCNT
#define F_PIPCHK PIPCHK
#define F_QFORM QFORM
#define F_SAVELU SAVELU
#define F_SAVCHK SAVCHK
#define F_SAVER SAVER
#define F_SAVEW SAVEW
#define F_SAVER2 SAVER2
#define F_SAVEW2 SAVEW2
#define F_SHWHED SHWHED
#define F_PUTFP PUTFP
#define F_GETFP GETFP
#define F_PUTFP2 PUTFP2
#define F_GETFP2 GETFP2
#define F_GETRIN GETRIN
#define F_PUTRIN PUTRIN
#define F_IKPCHK IKPCHK
#define F_IN_IKP IN_IKP
#define F_SSCANF FSSCNF
#define F_WALCLK WALCLK
#define F_LUDSK LUDSK
#define F_LUTTY LUTTY
#else

#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define F_GALLOC galloc_
#define F_GREALLOC grealloc_
#define F_GCALLOC gcalloc_
#define F_GFREE  gfree_
#define F_GETPPS  getpps_
#define F_STOINT  stoint_
#define F_STOFLT  stoflt_
#define F_CTOINT  ctoint_
#define F_INTTOC  inttoc_
#define F_ICCHAR  icchar_
#define F_EBCASC  ebcasc_
#define F_ASCEBC ascebc_
#define F_SISR4 sisr4_
#define F_R4SIS r4sis_
#define F_FGTIME fgtime_
#define F_FGDATE fgdate_
#define F_MOVE move_
#define F_PIPCNT pipcnt_
#define F_PIPCHK pipchk_
#define F_QFORM qform_
#define F_SAVELU savelu_
#define F_SAVCHK savchk_
#define F_SAVER saver_
#define F_SAVEW savew_
#define F_SAVER2 saver2_
#define F_SAVEW2 savew2_
#define F_SHWHED shwhed_
#define F_PUTFP putfp_
#define F_GETFP getfp_
#define F_PUTFP2 putfp2_
#define F_GETFP2 getfp2_
#define F_GETRIN getrin_
#define F_PUTRIN putrin_
#define F_IKPCHK ikpchk_
#define F_IN_IKP in_ikp_
#define F_SSCANF fsscnf_
#define F_WALCLK walclk_
#define F_LUDSK ludsk_
#define F_LUTTY lutty_

#else

#define F_GALLOC galloc
#define F_GREALLOC grealloc
#define F_GCALLOC gcalloc
#define F_GFREE gfree
#define F_GETPPS  getpps
#define F_STOINT  stoint
#define F_STOFLT  stoflt
#define F_CTOINT  ctoint
#define F_INTTOC  inttoc
#define F_ICCHAR  icchar
#define F_EBCASC  ebcasc
#define F_ASCEBC ascebc
#define F_SISR4 sisr4
#define F_R4SIS r4sis
#define F_FGTIME fgtime
#define F_FGDATE fgdate
#define F_MOVE move
#define F_PIPCNT pipcnt
#define F_PIPCHK pipchk
#define F_QFORM qform
#define F_SAVELU savelu
#define F_SAVCHK savchk
#define F_SAVER saver
#define F_SAVEW savew
#define F_SAVER2 saver2
#define F_SAVEW2 savew2
#define F_SHWHED shwhed
#define F_PUTFP putfp
#define F_GETFP getfp
#define F_PUTFP2 putfp2
#define F_GETFP2 getfp2
#define F_GETRIN getrin
#define F_PUTRIN putrin
#define F_IKPCHK ikpchk
#define F_IN_IKP in_ikp
#define F_SSCANF fsscnf
#define F_WALCLK walclk
#define F_LUDSK ludsk
#define F_LUTTY lutty
#endif
#endif

#ifndef C_COMMENTS_DISALLOWED

/* define the C entry point names */

#endif

#ifndef FTN_TO_C_NAME_COMPATABILITY
#define C_SAVELU savelu
#define C_SAVCHK savchk
#define C_SAVER saver
#define C_SAVEW savew
#define C_SAVER2 saver2
#define C_SAVEW2 savew2
#define C_GETPPS getpps
#define C_IN_IKP in_ikp
#define C_SHWHED shwhed
#else
#define C_SAVELU savelu_c
#define C_SAVCHK savchk_c
#define C_SAVER saver_c
#define C_SAVEW savew_c
#define C_SAVER2 saver2_c
#define C_SAVEW2 savew2_c
#define C_GETPPS getpps_c
#define C_IN_IKP in_ikp_c
#define C_SHWHED shwhed_c
#endif

#ifndef C_COMMENTS_DISALLOWED

/* not machine dependent - name differently than the Fortran entry */

#endif

#define C_QFORM q_format
#define C_PUTFP putreal
#define C_GETFP getreal
#define C_PUTFP2 putreal2
#define C_GETFP2 getreal2
#define C_GETLN c_getln
#define C_CMDCHK c_cmdchk

/* - added the pgi check to make sure we are not using PGI fortran */
/*						- Joe M. Wade 9/22/00 */

#if (defined(__STDC__) || defined(__cplusplus)) && ! defined(pgi)

#include <localsys.h>
/* - removed 10/24/01 (confused the itanium compiler) - Joe M. Wade
*/
#ifdef SUNSYSTEM
#include <varargs.h>
#endif

#ifdef _NO_PROTO
    extern void save_cmd_args();
    extern void save_hlh();
    extern void show_hlh();
    extern int C_SAVELU();
    extern int C_SAVCHK();
    extern int C_IN_IKP();
    extern int savr();
    extern int savr2();
/*
    extern void C_GETFP2();
    extern void C_PUTFP2();
*/
    extern void C_GETPPS();
    extern void C_SHWHED();
    extern void putreal();
    extern void getreal();
    extern void putreal2();
    extern void getreal2();
    extern int get_hw_val();
    extern int get_indexed_hw_val();
    extern int put_hw_val();
    extern int put_indexed_hw_val();
#else
#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
  extern "C" {
#endif
    extern void save_cmd_args(int, char **);
    extern void save_hlh(char *, int, int  *);
    extern void show_hlh(char *);
    extern int C_SAVELU(char *, int *, int *, int *, int);
    extern int C_SAVCHK(char *, int *, int *, int *, int);
    extern int C_IN_IKP();
    extern int savr(int *, char *, char *, int, int );
    extern int savr2(int *, int, int, int, char *, int, int );
/*
    extern void C_GETFP2(char *, int, int, int, float *, int);
    extern void C_PUTFP2(char *, int, int, int, float, int);
*/
    extern void C_GETPPS(int *, int *);
    extern void C_SHWHED(int *, int, int);
    extern void getreal(char *, char *, float *, int);
    extern void putreal(char *, char *, float, int);
    extern void getreal2(char *, int, int, int, float *, int);
    extern void putreal2(char *, int, int, int, float, int);
    extern int get_hw_val(char *buffer, char *keystr, int hdr_type, ...);
    extern int put_hw_val(char *buffer, char *keystr, int hdr_type, ...);
    extern int get_indexed_hw_val(char *buffer, int format, int index, int length, int hdr_type, ...);
    extern int put_indexed_hw_val(char *buffer, int format, int index, int length, int hdr_type, ...);
#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
  }
#endif	/* End of ANSI C or C++ function prototypes. */

#endif
#endif
#endif
