C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c avgain reads records of data, computes gain crvs and averages them 
c temporally and/or spatially to derive a single balancing gain curve 
c for each record. The curves are written to the output and can be 
c applied with program VMULT.
c**********************************************************************c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
      integer     itr ( SZLNHD ),z(1),abort1
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne,ptrc,TH
      integer     static,argis,getnwin
      real        havg(1),bigar1(1),trhdrs(1),a(1),b(1),work(1)
      real        weight(1),tempo(1),tweight(1)
      character   ntap * 256, otap * 256, name*6
      logical     verbos, query, agc,dead(1),h,stack,box
      pointer     (pbigar, bigar1),(phdrs,trhdrs)
      pointer     (pdead,dead),(pa,a),(pw,weight),(pww,work)
      pointer     (ptempo,tempo),(phavg,havg),(pz,z),(pb,b)
      pointer     (ptw,tweight)
 
      data name/'AVGAIN'/
c +===========================================================+
c | read program parameters from command line card image file |
c +===========================================================+
      h = (argis('-H').gt.0.or.argis('-h').gt.0)
      query = ( ( argis ( '-?' ) .gt. 0 ).or.h)
      if ( query )then
            call help(ler)
            stop
      endif
 
#include <f77/open.h>
 
      TH = TRACEHEADER
      call gcmdln(ntap,otap,irs,ire,mode,lwin,ovlp,scale,
     : agc,lsmooth, stack,box,verbos)

      if(scale.eq.0)scale = 15
      sscale = scale
      scale = 2047. * scale *0.01


      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c +===========================+
c | read line header of input |
c | save certain parameters   |
c +===========================+
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'AVGAIN: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif


c +==============================================+
c | Set up locations and offsets for, then read  |
c | some lineheader info.  Set up locations and  |
c | offsets for trace header info                |
c +==============================================+
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsi  ,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec ,LINEHEADER)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINEHEADER)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(lsmooth.lt.0)lsmooth=0
      if(lsmooth.ne.0.and.lsmooth/2*2.eq.lsmooth)lsmooth=lsmooth-1


      lname = 6
      call hlhprt (itr, lbytes, name, lname, LERR)

c +==============================================================+
c | ensure that command line values are compatible with data set |
c | (i.e. start/end traces; start/end records)                   |
c +==============================================================+
      ns = 1
      ne = ntrc
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      if(stack.and.ntrc.ne.1.and.lsmooth.ne.0)then
       write(LER,*)'Stacked data flag set for data with num trcs',
     :' per rcd = ',ntrc
       write(LER,*)'Flag will be ignored.'
       write(LERR,*)'Stacked data flag set for data with num trcs',
     :' per rcd = ',ntrc
       write(LERR,*)'Flag will be ignored.'
      endif
      ptrc = ntrc
      if(stack.and.ntrc.eq.1.and.lsmooth.ne.0)then
       ptrc = nrec
      endif

c
c added by jev per rlc request - 7/29/97 
c
 
      if (ntrc .eq. 1 .and. lsmooth .ne. 0 .and. .not. stack) then

       write (LER,*) 'FATAL ERROR'
       write (LER,*) 'Spatial smoothing requested for stacked data ',
     :               'without STACK flag being set.'
       write (LER,*) 'Set STACK flag (-st) or remove -l flag and ',
     :               'resubmit'
       write (LERR,*) 'FATAL ERROR'
       write (LERR,*) 'Spatial smoothing requested for stacked data ',
     :               'without STACK flag being set.'
       write (LERR,*) 'Set STACK flag (-st) or remove -l flag and ',
     :               'resubmit'
       stop

      endif

c +----------------------------------+
c | malloc space we are going to use |
c +----------------------------------+

      ierr = 0
      ner = 0
      abort1 = 0

      iget = ptrc * nsamp * ISZBYT
      call galloc (pbigar, iget, ierr, abort1)
      memsum=iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pa, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      iget =ptrc*ISZBYT
      call galloc (pdead, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pw, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(ptw, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      iget = ptrc*ITRWRD*ISZBYT
      call galloc (phdrs, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      if(ptrc.gt.nsamp)then
       iget = ptrc*3*ISZBYT
      else
       iget = nsamp*ISZBYT
       if(ptrc.gt.nsamp/3)iget=nsamp*3*ISZBYT
      endif
      call galloc(pb     , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pww, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(ptempo , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      if (ner.ne.0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c +==============================================================+
c | modify line header to reflect actual number of traces output |
c +==============================================================+
      nrecc=ire - irs+1
      call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecc,LINEHEADER)
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LINEHEADER)

c +---------------------+
c | number output bytes |
c +---------------------+
      obytes = SZTRHD + nsamp * ISZBYT
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c +-------------------------------------+
c | Compute sample interval in seconds. |
c | Handle microseconds if necessary    |
c +-------------------------------------+
      dt = float (nsi) * unitsc
      sr = float (nsi)
c +-----------------------------------+
c | Compute window length in samples  |
c | and number of windows.            |
c +-----------------------------------+
      if(lwin.eq.0)then
        lwin = 1.0/dt
      else
        lwin = lwin/sr
      endif
      if (lwin .gt. nsamp .OR. lwin .lt. 2) then
         write(LERR,*)'FATAL ERROR in avgain:'
         write(LERR,*)'Temporal window= ',lwin,' points...'
         write(LERR,*)'Must lie between 2 and ',nsamp
         write(LER ,*)'FATAL ERROR in avgain:'
         write(LER ,*)'Temporal window= ',lwin,' points...'
         write(LER ,*)'Must lie between 2 and ',nsamp
         stop 666
      endif
      ywin = ((float(lwin)-1.)/2.)*2.+1.
      lwin = ywin
      ovlp = ovlp*.01
      if(ovlp.eq.0)ovlp=.5
      if(mode.gt.4)mode=0

c     if( verbos ) then
       jwin = lwin * sr
       xlap = ovlp*100
       call verbal(nsamp, nsi, ntrc, nrec,mode,jwin,xlap,
     :             sscale,agc,lsmooth,stack,ntap,otap,lwin)
c     end if
      igap = lwin * ovlp
      nwin=0
      iend=lwin
      istrt=1
      nwin = getnwin(istrt,lwin,igap,nsamp)
c------------------------------------------
c  now allocate the work arrays for getavg         
c-----------------------------------------
      ner = 0
      ier = 0
      abort1 = 0
      iget = nwin*ptrc*ISZBYT
      call galloc(phavg , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner = ner+1
      call galloc(pz , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner = ner+1

      if (ner.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
      endif

c +================================+
c |     BEGIN PROCESSING           |
c | first skip unwanted records    |
c +================================+
       if(stack)then
         irs = 1
         ire = 1
       endif
      if(irs.gt.1)then
       iget=(irs-1)*ptrc+1
       call sisseek(luin,iget)
      end if
c +=======================================+
c | compute the spatial smoothing weights |
c +=======================================+
      if(lsmooth.gt.0)then
       lpts=lsmooth
       if(lpts.lt.3)lpts=3
       xnorm = lpts-1
       xnorm = lpts
       do i=1,lpts
        weight(i)=1./xnorm
       end do
       if(.not.box)then
        call bldweight(weight,lpts)
       endif
      else
       lpts=ptrc
      endif
c +================================+
c |  process desired trace records |
c +================================+
      do jj = irs, ire
       do i=1,ptrc
        dead(i)=.false.
       end do
       do i=1,ptrc
        j=(i-1)*nsamp
        do kk=1,nsamp
         a(j+kk)=0.
        end do
       end do
       do kk = 1,ptrc
        nbytes = 0
        call rtape( luin, itr, nbytes)
        if(nbytes .eq. 0) then
         write(LERR,*)' Premature end of file on input'
         write(LERR,*)'Abnormal Termination'
         write(LERR,*)' at sequential record ',jj
         write(LERR,*)' at sequential trace ',kk
         write(LER,*)' '
         write(LER,*)'AVGAIN:'
         write(LER,*)' Premature end of file on input'
         write(LER,*)' at sequential record ',jj
         write(LER,*)' at sequential trace ',kk
         write(LER,*)' '
         write(LER,*)' Abnormal Termination'
         write(LER,*)'WARNING'
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,static,TH)
        if (static .eq. 30000) then
          call vclr (itr(ITHWP1),1,nsamp)
          dead(kk)=.true.
        end if
        istrc = (kk-1)*nsamp
        call vmov (itr(ITHWP1),1, bigar1(istrc+1),1,nsamp)
        isthd = (kk-1)*ITRWRD
        call vmov(itr,1,trhdrs(isthd+1),1,ITRWRD)
       end do    
       ierr = 0
c +===============================+
c | Compute the temporal averages |
c +===============================+
       do i=1,nwin
         ndx = (i-1)*ptrc
        do j=1,ptrc
         mdx = ndx + j
         havg(mdx)=0.
        end do
       end do
       call getavg (ptrc, nsamp, bigar1, a,mode,lwin,nwin,igap,
     :   havg, z, dead, ierr)
       if(ierr.ne.0)then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace for getavg'
        write(LERR,*)' '
        call lbclos ( luin )
        call lbclos ( luout )
        stop
       endif
c +========================================+
c | do the spatial smoothing, if requested |
c +========================================+
       if(lsmooth.gt.0)then
        jpts = ptrc+lpts
        do isamp=1,nwin
         do j=1,jpts
          b(j)     = 0.
          tempo(j) = 0.
          work(j)  = 0.
         end do
         kpts = 0
         ione=0
c +--------------------------------------+
c | Find the valid averages and put them |
c | in the buffer to be smoothed         |
c +--------------------------------------+
         do j=1,ptrc
          jl=(j-1)*nwin+isamp
          if(.not.dead(j).and.havg(jl).ne.0.0)then
           kpts=kpts+1
           tempo(kpts)=havg(jl)
          endif
         end do

c +--------------------------------------+
c | Make sure we have enough samples for |
c | smoothing. need at least 2 times the |
c | spatial smoothing length             |
c +--------------------------------------+
         if(kpts.ge.lpts+lpts)then
          ipt=lpts/2+1
          ipt1=ipt-1
          call vmov(tempo,1,b(ipt),1,kpts)
          call vmov(b(ipt+1),1,b(ipt1),-1,ipt1)
          call vmov(b(kpts+ipt-2),-1,b(kpts+ipt),1,ipt1)
          lc=0
          lb = kpts+ipt1+ipt1
          call fold(lpts,weight,lb,b,lc,work)
          mpts = lpts
         else
c +--------------------------------------+
c | otherwise reset the smoothing length |
c | and handle the shortened length      |
c +--------------------------------------+
          mpts=kpts/2
          mpts = (mpts+1)/2*2-1
cprg---
c   trap for havg arrays that have only 1 nonzero value for a given
c   window position. otherwise this would cause kpts = 1 which leads
c   to mpts = -1 and NaNs later on
          if (mpts .lt. 1) mpts = 1
cprg---
          if(kpts.gt.3)then
           xnorm=mpts-1
           if (xnorm .eq. 0) xnorm = 1
           do i=1,mpts
            tweight(i)=1./xnorm
           end do
           ipt = mpts/2+1
           ipt1=ipt-1
           if(.not.box)then
            call bldweight(tweight,mpts)
           endif
           call vmov(tempo,1,b(ipt),1,kpts)
           call vmov(b(ipt+1),1,b(ipt1),-1,ipt1)
           call vmov(b(kpts+ipt-2),-1,b(kpts+ipt),1,ipt1)
           lc=0
           lb = kpts+ipt1+ipt1
           call fold(mpts,tweight,lb,b,lc,work)
           do m=1,mpts
            tweight(m)=0.
           end do
          else
           if(mpts.le.1)then
            do i=1,ptrc
             work(i)=tempo(1)
            end do
           endif
           if(mpts.eq.2)then
            avg = tempo(1)+tempo(2)
            avg = avg/2. 
            do i=1,ptrc
             work(i)=avg
            end do
           endif
          endif 
         endif
c +---------------------------------------+
c | pick up the smoothed averages and put |
c | them back into the average matrix     |
c | The starting point is the fold point  |
c | in the work buffer                    |
c +---------------------------------------+
         mpt = mpts-1
         if(kpts.gt.0)then
          do j=1,ptrc
           ndx=(j-1)*nwin+isamp
           if(.not.dead(j).and.havg(ndx).ne.0.0)then
            mpt=mpt+1
            havg(ndx)=work(mpt)
           endif
          end do
         endif 
        end do
       endif
c +===================================+
c | put the averages into the output. |
c | i.e., do temporal interpolation   |
c +===================================+
       do itrace=0,ptrc-1
        ib=itrace*nwin
        ia=itrace*nsamp
        do kk=1,nwin
         if(kk.eq.1)then
          li=z(kk)
          do j=1,li
           a(j+ia)=havg(kk+ib)
          end do
         else
          j=z(kk)
          li=z(kk-1)
          xm = j-li
          aa=havg(kk+ib-1)
          bb=havg(kk+ib)
          slope=(bb-aa)/xm
          r=0
          do m=li+1,j
           r=r+1
           a(m+ia)=aa+slope*r
          end do
         endif
        end do
        li=z(nwin)
        if(li.lt.nsamp)then
         do j=li+1,nsamp
          a(j+ia)=havg(nwin+ib)
         end do
        endif
       end do
       do i=1,ptrc
        ist=(i-1)*nsamp
        do j=1,nsamp
         if(a(ist+j).ne.0.0)then
          a(ist+j)=scale/a(ist+j)
         else
          a(ist+j)=1.
         end if
        end do
       end do
c +====================+
c | write output data  |
c +====================+

c +================================+
c | If only gain curves requested, |
c | output them                    |
c +================================+
       if(agc)then
        do i=0,ptrc-1
         isthdr = i*ITRWRD+1
         istsmp = i*nsamp+1
         call vmov(trhdrs(isthdr),1,itr,1,ITRWRD)
         j=0
         do while (bigar1(istsmp+j).eq.0)
          a(istsmp+j)=1.
          j=j+1
         end do
         call vmov(a(istsmp),1,itr(ITHWP1),1,nsamp)
         call wrtape (luout, itr, obytes)
        end do
       else
c +==============================+
c | otherwise, apply the gain to |
c | the data and output.         |
c +==============================+
        do i=0,ptrc-1
         ndx=i*nsamp
         do j=1,nsamp
          b(j)=bigar1(ndx+j)*a(j+ndx)
         end do
         isthdr = i*ITRWRD+1
         call vmov(trhdrs(isthdr),1,itr,1,ITRWRD)
         call vmov(b,1,itr(ITHWP1),1,nsamp)
         call wrtape(luout,itr,obytes)
        end do
       endif
      end do

c +======================+
c | close data files and |
c | end processing       |
c +======================+
      write(LERR,*)'avgain normal end'
      write(LER ,*)'avgain normal end'
      call lbclos ( luin )
      call lbclos ( luout )
      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'avgain computes the average amplitude decay for a record of   '
        write(LER,*)
     :'data and writes either the scaled data or the gain curves'
        write(LER,*)
     :'to the output data set.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute avgain by typing avgain and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -md[md]      (default = 0)        : averaging mode'
        write(LER,*)
     :'                                     0 = AAA'
        write(LER,*)
     :'                                     1 = rms' 
        write(LER,*)
     :'                                     2 = GMAA'
        write(LER,*)
     :'                                     3 = median  '
        write(LER,*)
     :' -w[lwin]    (default = 1 sec)     : window length (ms or us)'
        write(LER,*)
     :' -s[scale]   (default = 15 %   )   : scale ave amp to s % 2047'
        write(LER,*)
     :' -tstep [tstep] (default = 50%)    : window step size, in %'
        write(LER,*)
     :' -l[lsmooth]  (default = none)     : spatial smoothing (trcs)'
        write(LER,*)
     :'                                     0 = no smoothing       '
        write(LER,*)
     :' -box        (default = no)        : if present, spatial window'
        write(LER,*)
     :'                                     changed from sin^2 to box '
        write(LER,*)
     :' -st          (default = no)       : if present, data is treated'
        write(LER,*)
     :'                                     as single rcrd of N traces'
        write(LER,*)
     :' -agc            (default = no)    : if present, output gain'
        write(LER,*)
     :'                                     curves only'

        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   avgain -N[ntap] -O[otap] -rs[irs] -re[ire] -md[md]'
        write(LER,*)
     :'     -w[lwin] -tstep[tstep] -l[lsmooth] -agc -box -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,mode,lwin,ovlp,scale,
     : agc,lsmooth,stack,box,verbos)
c-----
c     get command arguments
c
c     ntap    - C*100    input file name
c     otap    - C*100    output file name
c     irs     - I*4      starting record index
c     ire     - I*4      ending record index
c     mode    - I*4      average mode 
c                        0=arith  
c                        1=rms
c                        2=geometric
c                        3=median
c     lwin    - I*4      window length (default = ltrace/3)
c     ovlp    - R*4      window overlap (50%)
c     scale   - R*4      %2047 for scaling
c     agc     - L        F=output scaled data T=output gain traces
c     lsmooth - I*4      length of spatial smoothing window
c     stack   - L        stacked data flag 
c     verbos    L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     irs, ire
      integer     mode, lwin
      real        ovlp,scale
      logical     verbos,agc,stack,box
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-md', mode,  0, 0 )
            call argi4 ( '-w' , lwin,  0, 0)
            call argr4 ( '-tstep', tstep, 0.0,0.0)
            if(tstep.ne.0.0)then
             ovlp = 100. - tstep
            else
             tstep= 50.
             ovlp = 50.
            end if
            stack = (argis('-st').gt.0)
            call argr4 ( '-s', scale, 0.0,0.0)
            call argi4 ( '-l', lsmooth, 0, 0)
            agc =   (argis('-agc') .gt. 0)
            box = (argis('-box').gt.0)
            verbos =   (argis('-V') .gt. 0)
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec,mode,lwin,ovlp,
     :                  scale, agc,lsmooth,stack,ntap,otap,lw)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     stack - L*4     stacked data flag
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, lw
      real  ovlp,scale
      logical agc,stack
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if(mode.eq.0)then
             write(LERR,*)' averaging method    =  AAA'
            endif
            if(mode.eq.1)then
             write(LERR,*)' averaging method    =  RMS '
            endif
            if(mode.eq.2)then
             write(LERR,*)' averaging method    =  GMAA'
            endif
            if(mode.eq.3)then
             write(LERR,*)' averaging method    =  median'
            endif
            if(mode.eq.4)then
             write(LERR,*)' averaging method    =  AM    '
            endif
            write(LERR,*) ' window length       = ',lw,' pts'
            write(LERR,*) ' window length       = ',lwin,' ms'
            write(LERR,*) ' window step size    = ',100-ovlp,' %'
            write(LERR,*) ' scaling             = ',scale,' %'
            if (lsmooth .ne. 0) then
            write(LERR,*)' Spatial smoothing    = ',lsmooth,
     :                   ' traces '
            endif
            if(agc)then
            write(LERR,*) ' output contains gain curves only'
            endif
            if(stack)then
             write(LERR,*)' input data is stacked '
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
      subroutine bldweight(weight,lweight)
c +===================================================================+c
c |  subroutine to build a set of sine squared function. 
c |  inputs are
c |  lweight  =  length of the function, assumed odd.
c |  returned is
c |   weight  = stored 2-sided sine squared vector
c +===================================================================+c
      real weight(*)
      integer lweight

      pihalf = 3.141592654/2.
      lpts = lweight/2
      wtl = float(lpts)
      wtl1=pihalf/(2*wtl+1)
      one=1.
      call vramp(one,one,weight,1,lpts)
      call vsmul(weight,1,wtl1,weight,1,lpts)
      call vsin(weight,1,weight,1,lpts)
      call vsq(weight,1,weight,1,lpts)
      weight(lpts+1)=.5
      m=lweight
      do i=1,lpts
       weight(m)=weight(i)
       m=m-1
      end do
      sum = 0.
      do i=1,lweight
       sum = sum + weight(i)
      end do
      sumx = 1./sum
      sum = 0.
      do i=1,lweight
       weight(i) = weight(i)*sumx
      end do
      return
      end
