C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine funcs (X, P, np, xmin, xmax, itype)

c  fitting routine for a polynomial of degree np-1 with np coefficients
c  of type = itype

c  in this case  p1 = 1; p2 = x; p3 = x**2; p4 = x**3; ...
c  which are the basis functions

      real       pi2
      parameter  (mmax = 50, pi2 = 6.2831853)
      real       p(mmax)
      integer   itype

      p(1) = 1.
      xmax1 = 1.1 * xmax
      xmin1 = 0.9 * xmin

      if (itype .eq. 0) then
         do  10  j = 2, np
             p(j) = p(j-1) * x
10       continue
      elseif (itype .eq. 1) then
         do  11  j = 2, np
             p(j) = p(j-1) * exp(x)
11       continue
      elseif (itype .eq. 2) then
         do  12  j = 2, np
             p(j) = p(j-1) * exp(x**2)
12       continue
      elseif (itype .eq. 3) then
         do  13  j = 2, np
             p(j) = sin( float(j-1) * pi2 * x/xmax)
13       continue
      elseif (itype .eq. 4) then
         do  14  j = 2, np
             p(j) = cos( float(j-1) * pi2 * x/xmax)
14       continue
      elseif (itype .eq. 5) then
         do  15  j = 2, np
            if (x .ne. 0.) then
                p(j) = sin( float(j-1) * pi2 * x/xmax)/x
            else
                p(j) = 0.
            endif
15       continue
      elseif (itype .eq. 6) then
         do  16  j = 2, np
             p(j) = p(j-1) * alog(x + xmin1)
16       continue
      elseif (itype .eq. 7) then
         do  17  j = 2, np
             p(j) = 1./ (xmax1 - x)**j
17       continue
      elseif (itype .eq. 8) then
         do  18  j = 2, np
             p(j) = 1./ (x - xmin1)**j
18       continue
      elseif (itype .eq. 9) then
         do  19  j = 2, np
             p(j) = p(j-1) * exp(-x)
19       continue
      endif

      return
      end
