C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c +==================================================================+ c
c |  Subroutine to compute and apply balancing operator in time-     |
c |  and spatially-variant fashion.  Input includes                  |
c |  Dhold   -  R*4()  - Matrix of input data to be worked on        |
c |                      Columns are nsamp long, number of rows is   |
c |                      ndo                                         |
c |  winwork - R*4()   - work vector                                 |
c |  sum     - R*4()   - vector to hold spectral sums. Length is n2+2|
c |  opratr  - R*4()   - vector to hold n3-length balancing operator |
c |  data    - R*4()   - output matrix, same size as Dhold           |
c |  iovlp   - I*4     - temporal overlap parameter, in samples.     |
c |  nsamp   - I*4     - length of columns of Dhold and data         |
c |  nwin    - I*4     - number of temporal windows to do            |
c |  jslide  - I*4     - length of temporal window                   |
c |  ndo     - I*4     - number of traces to process                 |
c |  iopt    - I*4     - spectral mean option (0 = geometric)        |
c |                                           (1 = arithmetic)       |
c |  scale   - L*4     - amplitude preserve option                   |
c |  dead    - L*4()   - vector of dead trace identifiers            |
c |  taper   - R*4()   - (one-sided)taper for windowing for fft      |
c |  taperl  - I*4     - fraction of window length to taper          |
c |  stack   - R*4()   - stk of input data (used to infill dead zone)|
c |  ierr    - I*4     - memory allocation error if >0               |
c |                                                                  |
c +==================================================================+ c
      subroutine balance(Dhold, winwork,sum, opratr,data,iovlp,nsamp,
     :nwin,jslide,ndo,iopt,scale,dead,taper,taperl,pad,stack,ierr)
      real Dhold(*),winwork(*),sum(*),opratr(*),data(*)
      real taper(*),stack(*),taperl
      logical scale,dead(*),pad
      real weight(1),pstak(1)
      integer iopt,nsamp,nwin,jslide
      POINTER (pweight,weight),(ppstak,pstak)

      ner = 0
      ierr = 0
      iab = 0
      call sizefloat(isz)
      call galloc(pweight,ndo*isz,ierr,iab)
      call galloc(ppstak,  nsamp*isz,ierr,iab)
      if(ierr.ne.0)ner=ner+1
      if(ner.ne.0)return
      ndx=-nsamp
      do i=1,ndo
       ndx=ndx+nsamp
       do j=1,nsamp
        data(j+ndx)=0.
       end do
      end do
      ierr = 0
      nmove=jslide+iovlp
      lwind=nmove
c +============================================================+
c | Loop over number of time window, computing spectral mean,  |
c | the balancing operator, and applying opertor, merging each |
c | window into the output trace by linear interpolation       |
c +============================================================+
      do kk=1,nwin
c +======================================================+
c | For each time through, compute the number of samples |
c | to move from input matrix to work vector             |
c +======================================================+
       do mm=1,nmove
        winwork(mm)=0.
        pstak(mm)=0.
       end do
       if(kk.eq.1)then
        ilast=nmove
        ifirst = 1
        if(jslide.eq.nsamp)nmove=nsamp
        jmove=nmove
       else
        ifirst=ilast-iovlp+1
        ilast=ifirst+nmove-1
        jmove=nmove
        if(ilast.gt.nsamp)then
         jmove=nsamp-ifirst+1
        endif
       endif
       n2=64
       do while(n2.lt.jmove)
        n2=n2+n2
       end do
       do i=1,n2+2
        sum(i)=0.
       end do
c +====================================================+
c | Compute the running product or sum of data spectra |
c +====================================================+
       ierr = 0
       xn = 0.
       jjj=0
       do kkk=1,ndo
        if(.not.dead(kkk))then
         ndx=(kkk-1)*nsamp
         jjj = jjj + 1
         call vmov(Dhold(ndx+ifirst),1,winwork,1,jmove)
         if(pad)then
          call vmov(stack(ifirst),1,pstak,1,jmove)
         endif
         sumw=0.
         do i=1,jmove
          sumw=sumw+abs(winwork(i))
         end do
         if(sumw.eq.0.and.pad)then
           do i=1,jmove
            winwork(i)=pstak(i)
           end do
           do i=1,jmove
            sumw=sumw+winwork(i)
           end do
         endif 
         if(sumw.ne.0.0)then
          ltaper=jmove*taperl
          if(ltaper.gt.0)then
           call build_taper(ltaper,taper)
          endif
          call spbl1(jmove,winwork,n2,sum,weight(jjj),iopt,
     :      taper,ltaper,ierr)
          xn=xn+1
          if(ierr.ne.0)then
           ierr = 1
           call gfree(pweight)
           call gfree(ppstak)
           return
          endif
         endif
        endif
       end do
c +==============================+
c | Build the balancing operator |
c +==============================+
       if(xn.ne.0)then
        call spbl2(n2,sum,iopt,xn,opratr,ierr)
        if(ierr.ne.0)then
         ierr = 2
         call gfree(pweight)
         call gfree(ppstak)
         return
        endif
       endif
c +===================================+
c | Convolve the filter with the data |
c | for the current window            |
c +===================================+
       ndx=-nsamp
       jjj = 0
       do kkk=1,ndo
        mdx = (kkk-1)*nsamp
        ndx=ndx+nsamp
        if(.not.dead(kkk))then
         jjj = jjj + 1
         if(xn.ne.0.)then
          call vmov(Dhold(ndx+ifirst),1,winwork,1,jmove)
          call spbl3(jmove,winwork,n2,opratr,weight(jjj),scale,ierr)
          if(ierr.ne.0)then
           ierr=3
           call gfree(pweight)
           call gfree(ppstak)
           return
          endif
         else
          call vclr(winwork,1,jmove)
         endif
c +=================================================+
c | If this is the first window, save the processed |
c | data into the hold buffer, else taper the       |
c | processed data into the hold buffer             |
c +=================================================+
         if(kk.eq.1)then
          do i=1,jmove
           data(i+mdx)=winwork(i)
          end do
          iend = jmove
         else
          jj=ifirst-1
          xj=iovlp-1
          do i=1,iovlp
           jj=jj+1
           x1=(i-1)/xj
           x2=1.0-x1
           data(jj+mdx)=data(jj+mdx)*x2 + winwork(i)*x1
          end do
          do i=iovlp+1,jmove
           jj=jj+1
           if(jj.le.nsamp)then
           data(jj+mdx)=winwork(i)
           endif
          end do
         endif   ! endif for putting data into output
        endif   ! endif for dead trace check
       end do   ! end do for applying operator to all traces
      end do  ! end of loop over windows
      call gfree(pweight)
      call gfree(ppstak)
      return
      end
