C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
c
c
c  Changes:
c
c  Sept 30, 2002 -- Garossino
c     allowed mutint.F to see tmst and tf so that the mute could
c     be augmented by a header variable start time if desired.  In this 
c     case the -hws entry would be queried for an additive start time.
c     Requested by Kenney Gullette [Houston]
c
c  Nov 21, 2000 -- Garossino
c     added -maxd command line option to define maximum distance to mute
c     as requested by Steve Harris[Calgary]
c   
c
c  Mar 17, 1998--Garossino
c           fixed the muteaa.F routine for -off case when ramps are used.
c           the code was running off both the beginning and end of the
c           tri[] array as there was no policemen set to catch the ramp
c           or the start time for that matter running off either end.
C
C     PROGRAM MODULE MUTE
C
C**********************************************************************C
C
C MUTE READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES A USER-SPECIFIED MUTE, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, MUTEAA
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare Standard USP variables

      integer itr ( SZLNHD )
      integer lhed( SZLNHD )
      integer luin, nbytes, lbytes, luout, lbyout
      integer nsamp, nsi, ntrc, nrec, iform
      integer irs, ire, ns, ne, JJ, KK
      integer argis, jerr, ii

      real UnitSc

c declare local variables

      integer nramp, nrampj, n2zero, lucrd
      integer RI(SZLNHD), NC(SZLNHD), iflg(SZLNHD)
      integer ifmt_ONword, l_ONword, ln_ONword, iONword
      integer ifmt_OFFword, l_OFFword, ln_OFFword, iOFFword
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_keywrd, l_keywrd, ln_keywrd
      integer ifmt_strwrd, l_strwrd, ln_strwrd
      integer ifmt_liword, l_liword, ln_liword
      integer ifmt_diword, l_diword, ln_diword

      integer mindis, maxdis, keyval
      integer nreout,ntrout,dstsgn,istatic,ikeywrd
      integer limin, limax, dimin, dimax, li, di
      integer nf, ier, irimin, irimax, j, i, k, itrc
      integer irec, istrwrd, itmON, itmOFF, itm

      real head( SZLNHD )
      real tri ( SZLNHD )
      real samp, dist, dists, tm, vm, si, tf, tmst
      real dist_min, dist_max, dist2, tmul, dmul, wt
      real rONword, rOFFword, tmute
      real xx(63,70), tt(63,70)

      character   name * 4,ntap *255,otap * 255, mfile * 255
      character   keywrd * 6
      character   strwrd * 6
      character   liword * 6, diword * 6
      character   ONword*6, OFFword*6, freq_flag*2

      logical     verbos,restore,offset,disco,off,dstabs,flat
      logical     refl,flt,threed


      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )
      data name/'MUTE'/
      DATA     NBYTES , LBYTES  /
     :           0    ,   0     /, restore/.false./
      DATA threed/.false./

c---------------------------------
c  get online help if necessary
c---------------------------------
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0 )then
         call help ()
         stop
      endif

c---------------------------------
c  open printout file
c---------------------------------
#include <f77/open.h>

C**********************************************************************C
C     read in command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,ns,ne,irs,ire,tm,vm,nramp,mindis,disco,
     1           verbos,restore,offset,mfile,lucrd,keywrd,ONword,
     2           OFFword,off,dstabs,tmul,dmul,flat,refl,strwrd,
     3           flt,liword,diword,limin,limax,dimin,dimax,maxdis)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      lbytes = 0
      CALL RTAPE (LUIN, ITR, LBYTES )
      if(lbytes .eq. 0) then
         write(LERR,*)'MUTE: no header read on ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt( ITR , LBYTES, NAME, 4, LERR)

#include <f77/saveh.h>

      call saver ( itr, 'DgTrkS', freq_flag, LINHED )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(ONword,ifmt_ONword,l_ONword,ln_ONword,TRACEHEADER)
      call savelu(OFFword,ifmt_OFFword,l_OFFword,ln_OFFword,TRACEHEADER)
      call savelu( keywrd ,ifmt_keywrd,l_keywrd,ln_keywrd,TRACEHEADER)
      if (strwrd(1:1) .ne. ' ')
     1call savelu( strwrd ,ifmt_strwrd,l_strwrd,ln_strwrd,TRACEHEADER)

      if (liword .ne. ' ' .OR. diword .ne. ' ') then
          threed = .true.
          if (liword .ne. ' ') then
              call savelu( liword ,ifmt_liword,l_liword,ln_liword,
     1                     TRACEHEADER)
          endif
          if (diword .ne. ' ') then
              call savelu( diword ,ifmt_diword,l_diword,ln_diword,
     1                     TRACEHEADER)
          endif
      endif

      dist_min =  dmul * float(iabs (mindis) )
      if ( iabs(maxdis) .gt. 0 ) then
         dist_max = dmul * float(iabs(maxdis))
      else
         dist_max = 1.e32
      endif

      SI    =  tmul * float ( NSI )
      tm    =  tmul * tm

c handle units 

      samp = tmul * ( real (nsi) * unitsc )
      tm   = unitsc * tm
      tf   = unitsc

      samp  = tmul * samp
      NRAMP = ( NRAMP / NSI ) + 1

C**********************************************************************C
C     CHECK DEFAULT VALUES AND SET PARAMETERS; update line header
C**********************************************************************C
       IF (threed) THEN
          if (ire .eq. 0) ire = 99999999
          if ( ne .eq. 0)  ne = 99999999
          limin = irs
          limax = ire
          dimin = ns
          dimax = ne
       ELSE
          call cmdchk ( ns,ne,irs,ire,ntrc,nrec )
          nreout =  nrec
          ntrout =  ntrc
          call savew( itr, 'NumRec', nreout , LINHED)
          call savew( itr, 'NumTrc', ntrout , LINHED)
       ENDIF

c verbos printout

      call verbal( ntap, nsamp, nsi, ntrc, nrec, iform, otap, irs, ire, 
     :      ns, ne, off, offset, disco, mfile, restore, ONword, OFFword,
     :      tmul, dmul, tm, vm, mindis, maxdis, nramp, keywrd, flt, 
     :      threed)

c modify header as needed

         call savhlh ( itr, lbytes, lbyout )
         call wrtape ( luout, itr, lbyout )

c for time-offset mute go get all functions, put them
c in time and offset arrays ready for interpolation
c between RI's

      IF (offset) THEN
         if (disco) then
            call rddsco (XX, TT, nc, nf, RI, iflg, lucrd, LERR, ier)
         elseif (flat) then
            call rdflat (XX, TT, nc, nf, RI, lucrd, LERR, ier)
         else
            call rdtdfn (XX, TT, nc, nf, RI, lucrd, LERR, ier)
         endif
         if (ier .ne. 0) then
            write(LERR,*)'Something bad in time-offset function file'
            write(LERR,*)'Check functions in this file'
            call ccexit (668)
         endif
         irimin = RI(1)
         irimax = RI(nf)
         write(LERR,*)'Min RI # = ',irimin
         write(LERR,*)'Max RI # = ',irimax
         write(LERR,*)'Number Functions= ',nf
         write(LERR,*)' '
         write(LERR,*)'Time-Offset Functions:'
         do  j = 1, nf
 
           if (nc(j) .ne. nc(1)) then
             write(LERR,*)' Number pairs ',nc(j),' for ',j,'th function'
             write(LERR,*)' differs from the first function: ',nc(1)
             call ccexit(665)
           endif
           write(LERR,*)' '
           write(LERR,*)(TT(i,j),i=1,nc(j))
           write(LERR,*)(XX(i,j),i=1,nc(j))
           write(LERR,*)' '
         enddo
         write(LERR,*)'Trace Header Key Values'
         write(LERR,*)(ri(j),j=1,nf)
         write(LERR,*)' '

      ENDIF


c MAIN PROCESSING LOOP:  read trace, do mute, write trace

      DO j = 1, nrec

         DO k = 1, ntrc

            nbytes = 0
            call rtape(luin,itr,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',j,'  trace= ',k
               go to 999
            endif
            call vmov (head(ITHWP1), 1, tri, 1, nsamp)
            
            call saver2(lhed,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :           TRACEHEADER)
            call saver2(lhed,ifmt_RecNum,l_RecNum,ln_RecNum,irec,
     :           TRACEHEADER)
            call saver2(lhed,ifmt_DstSgn,l_DstSgn,ln_DstSgn,dstsgn, 
     :           TRACEHEADER)
            call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,istatic,
     :           TRACEHEADER)
            call saver2(lhed,ifmt_keywrd,l_keywrd,ln_keywrd,ikeywrd, 
     :           TRACEHEADER)
            if (strwrd(1:1) .ne. ' ') then
               call saver2(lhed,ifmt_strwrd,l_strwrd,ln_strwrd,istrwrd, 
     :              TRACEHEADER)
               tmst = tf * float (istrwrd)
            else
               tmst = 0
            endif
            if (liword(1:1) .ne. ' ') then
               call saver2(lhed,ifmt_liword,l_liword,ln_liword,li, 
     :              TRACEHEADER)
            endif
            if (diword(1:1) .ne. ' ') then
               call saver2(lhed,ifmt_diword,l_diword,ln_diword,di, 
     :              TRACEHEADER)
            endif

            if (flt) then

               call getfp2(lhed,ifmt_ONword,l_ONword,ln_ONword,
     1                     rONword  , TRACEHEADER)
               call getfp2(lhed,ifmt_OFFword,l_OFFword,ln_OFFword,
     1                     rOFFword  , TRACEHEADER)
            else

               call saver2(lhed,ifmt_ONword,l_ONword,ln_ONword,
     :                     iONword,TRACEHEADER)
               rONword = iONword
               call saver2(lhed,ifmt_OFFword,l_OFFword,ln_OFFword, 
     :                     iOFFword,TRACEHEADER)
               rOFFword = iOFFword

            endif
            
c     mute only selected trcs & recs
            IF (threed) THEN
               JJ = li
               KK = di
            ELSE
               JJ = J
               KK = K
            ENDIF

            IF (JJ .ge. IRS .AND. JJ .le. IRE) THEN
               
               IF (KK .ge. NS .AND. KK .le. NE) THEN

                  if (verbos .AND. itrc .eq. 1) then
                    if (threed) irec = li
                    write(LERR,*)'Mutine gather rec/LI/DI ',
     1              irec,li,di
                  endif

                  dists = dmul * float( dstsgn )
                  
                  if (dstabs) then
                     dists  = abs (dists)
                  else
                     dists  =      dists 
                  endif
                  
                  dist  = abs ( dists )
                  dist2 =  dist * dist
                  
                  IF (restore) THEN

c restore all mutes if present with ramps (the +1 is to account for
c sample one being time zero) be sure to restore dead traces to dead.
                     
                     itmON  = rONword  / nsi + 1
                     itmOFF = rOFFword / nsi + 1

c---prg
c   we start the ramp 1 sample above the on mute time; it remains a
c   constant slope and stops when it hits the first sample
c---prg
                     if (itmON .gt. 1 .AND. itmON .lt. nsamp) then
                        if (nramp .ge. itmON) then
                            nrampj = itmON - 1
                        else
                            nrampj = nramp
                        endif
                        n2zero = itmON - nrampj
                        if (n2zero .gt. 1) call vclr (tri, 1, n2zero)
                        ii = itmON
                        do  i = 1, nrampj
                           ii = ii - 1
                           wt = float(nramp-i) / float(nramp)
                           tri(ii) = tri(ii) * wt
                        enddo  
                     endif
   
c---prg
c   we start the ramp 1 sample below the off mute time; it remains a
c   constant slope and stops when it hits the last sample
c---prg
                     if (itmOFF .gt. 1 .AND. itmOFF .lt. nsamp) then
                        if (itmOFF+nramp .gt. nsamp) then
                            nrampj = nramp - (itmOFF+nramp - nsamp)
                        else
                            nrampj = nramp
                        endif
                        n2zero = nsamp - (itmOFF + nrampj)
                        if (n2zero .ge. 1) 
     1                  call vclr(tri(itmOFF+nrampj+1),1,n2zero)
                        do  i = 1, nrampj
                           wt = float(nramp-i) / float(nramp)
                           tri(itmOFF+i) = tri(itmOFF+i) * wt
                        enddo     
                     endif

                     if ( istatic .eq. 30000 ) 
     :                    call vclr ( tri, 1, nsamp )

                  ELSE

c do mute from scratch
                     
                     IF ( offset ) then
                        
                        keyval = ikeywrd
                        
                        if (istatic .ne. 30000 ) THEN
                           
                           call mutint (TT,XX,nc,nf,RI,keyval,
     &                          si, tri, nramp, tmute,
     &                          irimin, irimax, dists,
     &                          off,nsamp, tmst, tf )
                           itm = tmute
c     write(0,*)dist,itm

                           if ( off ) then
                              iOFFword = itm
                              if(itm .lt. 0 )iOFFword = 1
                              if(itm .gt. (nsamp-1)*nsi)
     :                             iOFFword = (nsamp-1)*nsi
                              if ( flt ) then
                              rOFFword = iOFFword
                              call putfp2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,rOFFword,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,iOFFword,TRACEHEADER)
                              endif
                           else
                              iONword = itm
                              if(itm .lt. 0 )iONword = 1
                              if(itm .gt. (nsamp-1)*nsi)
     :                             iONword = (nsamp-1)*nsi
                              if ( flt ) then
                              rONword = iONword
                              call putfp2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,rONword,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,iONword,TRACEHEADER)
                              endif
                           endif

                        else

                           if ( off ) then
                              if ( flt ) then
                              call putfp2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,0.0,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,0,TRACEHEADER)
                              endif
                           else
                              if ( flt ) then
                              call putfp2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,0.0,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,0,TRACEHEADER)
                              endif
                           endif

                        endif
                        
                     ELSE

c this must make sure the mute header entries are zero to start with

                        if ( off .and. freq_flag .ne. 'fk' ) then
                           if ( flt ) then
                           call putfp2(lhed,ifmt_OFFword,l_OFFword,
     :                          ln_OFFword,0.0,TRACEHEADER)
                           else
                           call savew2(lhed,ifmt_OFFword,l_OFFword,
     :                          ln_OFFword,0,TRACEHEADER)
                           endif
                        elseif ( freq_flag .ne. 'fk' ) then
                           if ( flt ) then
                           call putfp2(lhed,ifmt_ONword,l_ONword,
     :                          ln_ONword,0.0,TRACEHEADER)
                           else
                           call savew2(lhed,ifmt_ONword,l_ONword,
     :                          ln_ONword,0,TRACEHEADER)
                           endif
                        endif
                        
                        if (istatic .ne. 30000 .AND. 
     :                       dist .ge. dist_min .AND. 
     :                       dist .le. dist_max ) then

                           CALL MUTEAA ( NSAMP, tm, vm, dist, SAMP, 
     :                          NRAMP, TRI, TMUTE, off, refl, strwrd, 
     :                          tmst, freq_flag )
                           
                           itm = tmute / unitsc
                           
                           if ( off .and. freq_flag .ne. 'fk' ) then
                              iOFFword = itm
                              if(itm .lt. 0 )iOFFword = 1
                              if(itm .gt. (nsamp-1)*nsi)
     :                             iOFFword = (nsamp-1)*nsi
                              if ( flt ) then
                              rOFFword = iOFFword
                              call putfp2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,rOFFword,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_OFFword,l_OFFword
     :                             ,ln_OFFword,iOFFword,TRACEHEADER)
                              endif
                           elseif ( freq_flag .ne. 'fk' ) then
                              iONword = itm
                              if(itm .lt. 0 )iONword = 1
                              if(itm .gt. (nsamp-1)*nsi)
     :                             iONword = (nsamp-1)*nsi
                              if ( flt ) then
                              rONword = iONword
                              call putfp2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,rONword,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,iONword,TRACEHEADER)
                              endif
                           endif
                           
                        else
                           
                           if ( off .and. freq_flag .ne. 'fk' ) then
                              if ( flt ) then
                              call putfp2(lhed,ifmt_OFFword,l_OFFword,
     :                             ln_OFFword,0.0,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_OFFword,l_OFFword
     :                             ,ln_OFFword,0,TRACEHEADER)
                              endif
                           elseif ( freq_flag .ne. 'fk' ) then
                              if ( flt ) then
                              call putfp2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,0.0,TRACEHEADER)
                              else
                              call savew2(lhed,ifmt_ONword,l_ONword,
     :                             ln_ONword,0,TRACEHEADER)
                              endif
                           endif
                           
                        endif

                     ENDIF

                  ENDIF

c           end of J & K filter loop
               ENDIF
            ENDIF
            
            call vmov   (tri, 1, head(ITHWP1), 1, nsamp)
            CALL WRTAPE ( LUOUT, ITR, NBYTES )
            
         ENDDO
         
         if(verbos) then
            write(LERR,*)'Muted Rec  ', irec
         endif
         
      ENDDO
      
 999  continue
      call lbclos(luin)
      call lbclos(luout)
      stop
      end
