C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c pad take input compressed ensembles and expand them into USP-type
c records with an equal number of traces/record, or
c the reverse
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     itr  ( SZLNHD )
      integer     str  ( SZLNHD )
      integer     ltr  ( SZLNHD )

      integer     nsamp, nsi, ntrci, nreci, iform, obytes
      integer     ntrco, nreco
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     cur_keywrd
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 256, otap * 256, name*3, keywrd*6
      logical     verbos, query, rev, inline, next, dead, use, rnum
      logical     tail, place
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
c     equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'PAD'/
      data inline/.true./, str/SZLNHD * 0/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,verbos,rev,use,keywrd,nreco,ntrco,rnum,
     1            tail,place)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'pad: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(keywrd,ifmt_keywrd,l_keywrd,ln_keywrd,TRACEHEADER)
      write(LERR,*)'keywrd,ifmt_keywrd,l_keywrd,ln_keywrd= ',
     1              keywrd,ifmt_keywrd,l_keywrd,ln_keywrd

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrci, LINHED)
      call saver(itr, 'NumRec', nreci, LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'CDPFld', ifold, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if (ntrco .eq. 0) then
          ntrco = ntrci
      endif
      if (nreco .eq. 0) then
          nreco = nreci
      endif
      if (rev) then
         nreco = 1
         ntrco = nreci * ntrci
      endif
 
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 3, LERR)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrci, nreci, iform,
     1                  use,tail,rev,rnum,ntap,otap)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
         dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
 
c-----
c     process desired trace records
c-----
      ic = 0
      ir  = 1
      lnd = 0
      cur_keywrd = 0

      IF (.not. rev .AND. .not. tail) THEN

      DO  1000 JJ  = 1, 1
 
            ind = 0
            dead = .false.
            next = .true.

            do while (1.eq.1)
 
20              continue

                if (next) then

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 998
                  endif
                  mbytes = nbytes
                  lnd = lnd + 1

                else

                  call move (1, itr, ltr, mbytes)
                  next = .true.
                  ind = 0

                endif
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

c------
c strip out any
c dead traces
c go back & read
c next trace
c------
                  if     (stacor .eq. 30000) then
                         if (place) then
                            go to 21
                         else
                            next = .true.
                            go to 20
                         endif
                  endif

21                continue

                  call saver2(itr,ifmt_keywrd,l_keywrd, ln_keywrd,
     1                        ikeywrd , TRACEHEADER)

c------

                  if (ikeywrd .eq. cur_keywrd .OR. ind .eq. 0) then

                      ind = ind + 1
                      call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            ili , TRACEHEADER)
                      call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            idi , TRACEHEADER)
                      if (rnum) then
                      call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            ind    , TRACEHEADER)
                      else
                      call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            irecnum, TRACEHEADER)
                      endif
                      call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            ili , TRACEHEADER)
                      call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            idi , TRACEHEADER)
                      call wrtape (luout, itr, mbytes)
                      next = .true.
                      cur_keywrd = ikeywrd

                  else

                      call move (1, ltr, itr, mbytes)
                      do  i = ind+1, ntrco
                         
                      if (rnum) then
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      else
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            irecnum, TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            0      , TRACEHEADER)
                      endif
                      call savew2(str,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            ili , TRACEHEADER)
                      call savew2(str,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            idi , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, mbytes)

                      enddo
                      next = .false.
                      ind = 0
                      ir = ir + 1
                      go to 20

                  endif

 1002          continue

               enddo
c1001          continue
 
c-----------
c finish up current rec
c-----------
               write(LERR,*)'Input rec= ',jj,'  ind,ntrco= ',ind,ntrco

               if (ind .ne. ntrco) then
                   do  i = ind+1, ntrco
                       if (rnum) then
                       call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                             ir     , TRACEHEADER)
                       call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                             i      , TRACEHEADER)
                       else
                       call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                             irecnum, TRACEHEADER)
                       call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            0      , TRACEHEADER)
                       endif
                       call savew2(str,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                             ili , TRACEHEADER)
                       call savew2(str,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                             idi , TRACEHEADER)
                       call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                             30000  , TRACEHEADER)
                       call wrtape (luout, str, mbytes)
                   enddo
                   ind = ntrco
               endif

 
 1000 CONTINUE

c-----------
c finish up last non-dead rec
c-----------
  998 continue
              write(LERR,*)'Input rec= ',jj,' output rec= ',ir,
     1                     '  ind,ntrco= ',ind,ntrco

              if (ind .ne. ntrco) then
                  do  i = ind+1, ntrco
                      if (rnum) then
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      else
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            irecnum, TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            0      , TRACEHEADER)
                      endif
                      call savew2(str,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            ili , TRACEHEADER)
                      call savew2(str,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            idi , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, mbytes)
                  enddo
              endif
              write(LERR,*)'Finished rec ',ir
c-----------
c finish up dead recs
c-----------
              write(LERR,*)'Input rec= ',jj,'  ir,nreco= ',ir,nreco
              if (ir .ne. nreco .AND. use) then
                DO  j = ir+1, nreco
                  do  i = 1, ntrco
                      if (rnum) then
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            j      , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      else
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            irecnum, TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            0      , TRACEHEADER)
                      endif
                      call savew2(str,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            ili , TRACEHEADER)
                      call savew2(str,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            idi , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, mbytes)
                  enddo
                ENDDO
              endif
              write(LERR,*)'pad: finished output rec ',ir
      go to 999


      ELSEIF ( rev .AND. .not. tail ) THEN

      DO  2000 JJ  = 1, nreci

            do 2001  kk = 1, ntrci
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  mbytes = nbytes

c------
c     use previously derived pointers to trace header values

                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  if     (place .AND. (stacor .eq. 30000)) then
                      if (kk .eq. 1) then
                         lnd = lnd + 1
                         call wrtape (luout, itr, mbytes)
                      endif
                  elseif (stacor .ne. 30000) then

                      lnd = lnd + 1
                      call wrtape (luout, itr, mbytes)
                  endif

 2001          continue
 
 
 2000 CONTINUE

      ELSEIF ( tail ) THEN
 
         DO WHILE (.true.)
 
               do  kk = 1, ntrci
    
                     nbytes = 0
                     call rtape( luin, itr, nbytes)

                     if(nbytes .eq. 0) then
                        krem = ntrci - kk + 1
                        write(LERR,*)'End of file on input:'
                        if (kk .le. 1) then
                           write(LERR,*)'No padding necessary'
                        else
                           write(LERR,*)'  Padding ',krem,' traces'
                           call savew2 (itr,ifmt_RecNum,l_RecNum,
     1                                 ln_RecNum,JR, TRACEHEADER)
                           call savew2 (itr,ifmt_StaCor,l_StaCor,
     1                                 ln_StaCor,30000, TRACEHEADER)
                           call vfill (0.0, itr(ITHWP1), 1, nsamp)
                           it = KR
                           do  ij = kk, ntrci
                               it = it + 1
                            call savew2 (itr,ifmt_TrcNum,l_TrcNum,
     1                                  ln_TrcNum, it, TRACEHEADER)
                               call wrtape (luout, itr, obytes)
                           enddo
                        endif
                        go to 999
                     endif

                     call saver2 (itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                            JR, TRACEHEADER)
                     call saver2 (itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                            KR, TRACEHEADER)
                     lnd = lnd + 1
                     call wrtape (luout, itr, obytes)
               enddo
         ENDDO

      ENDIF
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      if (rev ) then
            write(LERR,*)'end of reverse pad, processed ',lnd,
     :               ' total live input traces'
            write(LER ,*)'end of reverse pad, processed ',lnd,
     :               ' total live input traces'
      else
            write(LERR,*)'end of forward pad, processed ',lnd,
     :               ' total live input traces'
            write(LER ,*)'end of forward pad, processed ',lnd,
     :               ' total live input traces'
      endif

      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'pad (un)pack data into constant width records for processing'
        write(LER,*)
     :'       2D & 3D tools; take care of premature EOFs'
        write(LER,*)
     :'see manual pages for details ( online by typing xman )'
        write(LER,*)' '
        write(LER,*)
     :'execute pad by typing pad and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)     : output data file name'
        write(LER,*)
     :' -K [keywrd]  (RecNum)         : trc header to key on'
        write(LER,*)
     :' -ntrc [ntrc] (input hdr)      : output traces/rec'
        write(LER,*)
     :' -nrec [nrec] (input hdr)      : output records'
        write(LER,*) ' '
        write(LER,*)
     :' -rnum  include on command line to renumber output traces'
        write(LER,*)
     :'        (i.e. renumber RecNum & TrcNum)'
        write(LER,*)
     :' -R  include on command line to reverse operation'
        write(LER,*)
     :' -tail if unexpected EOF hit pad out last record'
        write(LER,*)
     :' -use use line header info to determine how many records pad'
        write(LER,*)
     :' -P  if record is all dead keep 1 trace as record placeholder'
        write(LER,*)
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   pad -N[ntap] -O[otap] -K[keywrd] -ntrc[] -nrec[]'
        write(LER,*)
     :'              [ -R -V -rnum -use -tail -P ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,verbos,rev,use,keywrd,nrec,ntrc,rnum,
     1                  tail,place)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     rev     L        undo previous pad
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), keywrd*6
      logical     verbos, rev, use, rnum, tail, place
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program pad might be invoked in the following way:
 
c     pad  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into pad and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-K', keywrd, 'RecNum', 'RecNum' )
            call argi4 ( '-ntrc', ntrc, 0 , 0 )
            call argi4 ( '-nrec', nrec, 0 , 0 )
            use    =   (argis('-U') .gt. 0)
            rev    =   (argis('-R') .gt. 0)
            place  =   (argis('-P') .gt. 0)
            rnum   =   (argis('-rnum') .gt. 0)
            tail   =   (argis('-tail') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  use,tail,rev,rnum,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
      logical     rev, rnum, tail, use
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' re pack data       =  ',rev
            write(LERR,*) ' renumber traces    =  ',rnum
            if ( tail )
     1      write(LERR,*) ' if EOF encountered pad last rec'
            if ( use )
     1      write(LERR,*) ' pad mode: use input line header info to dete
     2rmine total number records to pad'
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

c-----
c    write out printout file in case program bombs later
c-----
c           call flush (LERR)
 
      return
      end
 
