C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do spatial 
c interpolation

      subroutine untrp (ntrc, ntrco, ntrcm, nsamp, bigar1,
     1                   tabl1, tabl2, tablh1, tablh2, itrhdr,
     2                   zz, iz, zzh, izh, icinit, cubic, nover,
     3                   icinith, sii, sio, sr, LNTRHD, SZSMPD,
     4                   ifmt_StaCor,l_StaCor,ln_StaCor)

#include <f77/iounit.h>
      
      integer    LNTRHD, SZSMPD
      real       bigar1(nsamp,ntrcm)
      integer*2  itrhdr(LNTRHD,ntrcm)
      real       zz(*), tabl1(*), tabl2(*)
      real       zzh(*), tablh1(*), tablh2(*)
      integer    iz(*)
      integer    izh(*)
      real       work1, work2
      pointer    (wkwork1, work1(1))
      pointer    (wkwork2, work2(1))
      logical    cubic


      ntrc1 = ntrc + 1
      ntrco1 = ntrco + 1
      nrat  = ntrco/ntrc

      item = max(LNTRHD,ntrcm) * SZSMPD
      errcdt = 0
      bytot  = 0
      call galloc (wkwork1, item, errcd, abort1)
      errcdt = errcdt + errcd
      bytot  = bytot + item
      call galloc (wkwork2, item, errcd, abort1)
      errcdt = errcdt + errcd
      bytot  = bytot + item
c----
c   interpolate record
c----


      DO  100  i = 1, nsamp

          do  1  j = 1, ntrc

              work1 (j) = bigar1(i,j)
1         continue

          call vclr (work2, 1, ntrco)
          if ( cubic ) then
             call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrco,
     1                               iz, zz, icinit)
             icinit = 1
          else
             call vmov (work1, nover, work2, 1, ntrco)
          endif

          do  2  j = 1, ntrco

              bigar1(i,j) = work2(j)
2         continue

100   CONTINUE


c----
c   interpolate headers
c----
c     icinit = 1

      DO  200  i = 1, LNTRHD

          do  5  j = 1, ntrc

              wrk      = float( itrhdr(i,j))
              work1(j) = wrk + sign(.1, wrk)
5         continue

          call vclr (work2, 1, ntrco1)
          if ( cubic ) then
             call fcuint (tablh1, work1, ntrc1 , tablh2, work2, ntrco1,
     1                                  izh, zzh, icinith)
             icinith = 1
          else
             call vmov (work1, nover, work2, 1, ntrco)
          endif

          do  6  j = 2, ntrco1

              itrhdr(i,j-1) = work2(j-1)
6         continue

200   CONTINUE


      call gfree (wkwork1)
      call gfree (wkwork2)
      return
      end
