/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Package	:	sisio
	Module	:	_initial.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Initializes the sisio file information table iff necessary.

	_initialize();


	$Header: /m/s1/dmk/xlate/sisio/RCS/_initial.c,v 4.1 90/07/13 08:57:59 dmk Exp $

	$Log:	_initial.c,v $
	Revision 4.1  90/07/13  08:57:59  dmk
	MODSET: 4.1
	Added code to initialize message prefix and .filename for stdin/stdout.
	
	Revision 2.1  88/07/12  15:06:01  dmk
	MODSET: 2.1
	Added brains when setting cwlen.  Now sets cwlen to WORDSIZE rather
	than 8.
	
	Revision 1.1  88/06/27  11:22:46  dmk
	Initial revision
	
*/


#include	<stdio.h>
#include	<errno.h>
#include	<stdlib.h>
#include	"sisio.h"

#define	MODULE	"_initialize"


void _initialize()

{
	int	unit;
	int	isdisk;

/* we use this in _error to see if we've got a system error code to print
					- joe m. wade 3/30/95 
*/
	errno = -1;

	if ( _sisinit ) return;

	/*
		Set initial error message prefix.
	*/

	(void) strcpy( _msg_prefix, "" );

	/*
		Initialize all units.
	*/

	for ( unit = 0; unit <= MAXUNIT; unit++ )
		_fitinit( unit );

	/*
		Preconnect unit 0 as stdin.
	*/

	isdisk = _isdisk( 0 );
	if ( isdisk >= 0 )
	{
		_sisfit[ 0 ].filedes = 0;
		_sisfit[ 0 ].isopen = TRUE;
		_sisfit[ 0 ].isdisk = isdisk;
		_sisfit[ 0 ].filename = (char *) malloc( (unsigned) strlen("stdin")+1 );
		(void) strcpy( _sisfit[ 0 ].filename, "stdin" );

		if ( _sisfit[ 0 ].trwhen == W_ALWAYS || ( _sisfit[ 0 ].trwhen
				== W_IFDISK && _sisfit[ 0 ].isdisk ) )
			_sisfit[ 0 ].cwlen = 4;
		else
			_sisfit[ 0 ].cwlen = WORDSIZE;

/* don't use large buffering unless we're coming from disk */
		if ( ! _sisfit[ 0 ].isdisk && _sisfit[ 0 ].largebuf )
			_sisfit[ 0 ].largebuf = FALSE;

		if ( _sisfit[ 0 ].largebuf )
		{
			_sisfit[ 0 ].buffer = (char *) malloc( LGBUFSIZE );
			_sisfit[ 0 ].bufsize = LGBUFSIZE;
		}
		else
		{
			_sisfit[ 0 ].buffer = (char *) malloc( SMBUFSIZE );
			_sisfit[ 0 ].bufsize = SMBUFSIZE;
		}
		if ( _sisfit[ 0 ].buffer == NULL )
		{
			_error( MODULE, 0, E_NOBUFFER );
			return;
		}
	}

	/*
		Preconnect unit 1 as stdout.
	*/

	isdisk = _isdisk( 1 );
	if ( isdisk >= 0 )
	{
		_sisfit[ 1 ].filedes = 1;
		_sisfit[ 1 ].isopen = TRUE;
		_sisfit[ 1 ].isdisk = isdisk;
		_sisfit[ 1 ].filename = (char *) malloc( (unsigned) strlen("stdout")+1 );
		(void) strcpy( _sisfit[ 1 ].filename, "stdout" );

		if ( _sisfit[ 1 ].trwhen == W_ALWAYS || ( _sisfit[ 1 ].trwhen
				== W_IFDISK && _sisfit[ 1 ].isdisk ) )
			_sisfit[ 1 ].cwlen = 4;
		else
			_sisfit[ 1 ].cwlen = WORDSIZE;

/* don't use large buffering unless we're coming from disk */
		if ( ! _sisfit[ 1 ].isdisk && _sisfit[ 1 ].largebuf )
			_sisfit[ 1 ].largebuf = FALSE;

		if ( _sisfit[ 1 ].largebuf )
		{
			_sisfit[ 1 ].buffer = (char *) malloc( LGBUFSIZE );
			_sisfit[ 1 ].bufsize = LGBUFSIZE;
		}
		else
		{
			_sisfit[ 1 ].buffer = (char *) malloc( SMBUFSIZE );
			_sisfit[ 1 ].bufsize = SMBUFSIZE;
		}
		if ( _sisfit[ 1 ].buffer == NULL )
		{
			_error( MODULE, 1, E_NOBUFFER );
			return;
		}
	}

	_sisinit = TRUE;
}
