/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Package	:	sisio
	File	:	_readpipe.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_readpipe reads nbyte bytes from file into buffer.  Since _readpipe
	keeps trying until nbytes bytes are read or an I/O error occurs,
	it is suitable for reading from pipes.

	Calling sequence:

	nread = readpipe( file, buffer, nbytes );

	arg	i/o	type	description
	-----------------------------------
	nread	result	int	Number of bytes read, 0 if EOF, -1 if error.
	file	input	int	File descriptor.
	buffer	output	char *	The address of the area to read into.
	nbytes	input	unsign	The number of bytes to read.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_readpipe.c,v 4.1 90/07/13 09:07:57 dmk Exp $

	$Log:	_readpipe.c,v $
	Revision 4.1  90/07/13  09:07:57  dmk
	MODSET: 4.1
	Initial revision.
	
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int	_readpipe( file, buffer, nbytes )

	int		file;
	char *		buffer;
	unsigned	nbytes;

{
	int	bytesrd, thisrd;

	bytesrd = 0;
#ifdef DEBUG
	printf("_readpipe: file = %d, nbytes = %d\n",file,nbytes);
#endif
	while ( bytesrd < nbytes )
	{
		thisrd = read( file, buffer + bytesrd,
			( unsigned ) ( nbytes - bytesrd ) );
#ifdef DEBUG
	printf("_readpipe: actual read = %d bytes\n",thisrd);
#endif
		if ( thisrd < 0 ) return( thisrd );
		if ( thisrd == 0 ) return( bytesrd );
		bytesrd += thisrd;
	}

#ifdef DEBUG
	printf("_readpipe: bytes read = %d\n",bytesrd);
#endif
	return( bytesrd );
}
