/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ut_defs.h>
/*
	This routine is designed to be a generic memory allocation
	routine callable by fortran with a fortran pointer specified
	as the first argument. 

	arguments:
	  ptr    (i/o)	fortran pointer. the contents are changed to 
			 point at the newly allocated memory.
	  size   (i)    size in bytes of memory request.
	  errcod (o)	error code (0=success. !=0 for error)	
			 future values may mean something; right
			 now I just use -1 for failure and
			 the fortran pointer should have a value of zero.
	  abort  (i)	abort flag; nonzero denote abort request; 0
			 denotes use of error code.


	written to get around all the screwed up methods of dynamically
	allocating memory for fortran on all the various unix boxes.

					- joe m. wade - 06/26/91
*/
/*
        changed long declarations to int; these are NOT the same!
                                                - joe m. wade 5/26/95
*/

void F_GALLOC(ptr,size,errcod,abort)
char **ptr;
int *size;
int *errcod;
int *abort;
{
	*ptr = (char *) malloc (*size);
	if (*ptr == 0) {
	  if (*abort != 0) {
	    fprintf(stderr,"galloc: memory allocation error - aborting...\n");
	    exit(1);
	    }
	  *errcod = -1;
	  }
	else 
	  *errcod = 0;
	return;
}
