/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <save.h>
#include <ut_defs.h>
#include <save_defs.h>

#ifndef CRAYSYSTEM
int F_SAVCHK(keystr,format,index,length,lintrc,length_of_keystr)
char *keystr;
unsigned length_of_keystr;
#else
int F_SAVCHK(keystr,format,index,length,lintrc)
_fcd keystr;
#endif
int	*lintrc;
int	*format,*index,*length;
{
	int status;
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));
	strncpy(c_keystr,keystr, length_of_keystr);
        c_keystr[length_of_keystr] = '\0';

	status = C_SAVCHK(c_keystr,format,index,length,*lintrc);
	free(c_keystr);
	(*index)++;
	return(status);
}
int C_SAVCHK(str,format,index,length,line_trace)
char *str;
int line_trace;
int *format,*index,*length;
{
	int headertype;
	struct hdr *hd;
        struct hdr *hdrtypes[] = { lhdr,
				  thdr,
				  vnlhdr,
				  vspn_hdr,
				  segy_lhdr,
				  segy_thdr,
				  NULL };
	
/*
   if line_trace was passed in, the loop should only get executed once. 
   Otherwise, we want to execute it for each type of header until we get
   a match.
*/
	if (line_trace > 0) {
	  hd = hdrtypes[line_trace];
	  headertype = line_trace;
	  }
	else {
	  hd = hdrtypes[0];
	  headertype = 0;
	  }
	do {
	    for(; hd->str != (char *)0; hd++){
#ifdef DEBUG
		fprintf(stderr,"SAVCHK: ");
		fprintf(stderr," type = %d, search key = %s, match key = %s\n",
			headertype,str,hd->str);
#endif
		if(strncmp(str,hd->str,strlen(hd->str)) == 0){
			*format = hd->ind;
			*index = hd->pos;
			*length = hd->length;
			return(headertype);
			}
		}
#ifdef DEBUG
	        fprintf(stderr,"SAVCHK: Warning - could not find key %s ",
				str);
	        fprintf(stderr,"in header type %d\n",headertype);
#endif
	  	hd = hdrtypes[++headertype];
	    } while (hd != NULL && line_trace < 0);

#ifdef DEBUG
	  fprintf(stderr,"SAVCHK: key %s was never found\n",str);
#endif

	  return((int) -1);
}
