#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "HelpObject.h"

void build_message();
static Widget CreateHelpWindow();
static Widget Help_Window=(Widget)NULL;
static Widget text=(Widget)NULL;
static Widget selectionBox = (Widget)NULL;

extern Boolean     help_version_text;
extern Boolean     help_context_text;
extern Boolean     help_windows_text;
extern Boolean     help_index_text;
extern Boolean     help_keys_text;
extern Boolean     help_tutorial_text;

char *help_path;
HelpList *listitems;
int  nlistitems;
char **version;
HelpItem *Whats_Next_Item = NULL;

static char *filename;    
static char *guide_file;

static Widget Top_Level_Shell = NULL;



static char *help_mess[] = {
       "           ",
       "How To Use Help:",
       "  depress the {Help key} while the",
       "  cursor is positioned on the object",
       "  you need help with.",
       "           ",
       ""};   /* note null string terminatior  */

static char *help_mess_context[] = {
       "Help On Context:",
       "  changes shape of pointer to question pointer.",
       "  user may move pointer to component and select with",
       "  mouse any available context sensitive component.",
       "  help for the component will be presented.",
       "           ",
       ""};   /* note null string terminatior  */


static char *help_mess_index[] = {
       "Index:",
       "  will display an index of all available",
       "  Help topics for this program version.",
       "           ",
       ""};   /* note null string terminatior  */


static char *help_mess_version[] = {
       "Help On Version:",
       "  will display the current version",
       "  of this program and any notes",
       "  reguarding this version's usage.",
       "           ",
       ""};   /* note null string terminatior  */


static char *help_mess_keys[] = {
       "Help On Keys:",
       "  will display information about ",
       "  special KEY usage.",
       "           ",
       ""};   /* note null string terminatior  */


static char *help_mess_tutorial[] = {
       "Tutorial:",
       "  will display application tutorial.",
       "           ",
       ""};   /* note null string terminatior  */


static char *help_mess_windows[] = {
       "Windows:",
       "  will display information about window usage.",
       "           ",
       ""};   /* note null string terminatior  */



static XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;


/*   User calls   */
/***********************************************************************/

void XuSet_Help_Shell(w)  /* give help system a parent  */
 Widget   w;
{
 Top_Level_Shell = w;
 return;
}


void XuSet_Guide_File(path)   /*  set guide help file path and name*/
 char *path;
{
 guide_file = path;
 return;
}


void XuSet_Help_Whats_Next(helpitem)   /* set current traveling help filename */
 HelpItem *helpitem;
{
 Whats_Next_Item = helpitem;
 return;
}


void XuSet_Help(w, stringtyp, string)   /* add a HELP callback to a widget   */
 Widget w;
 char *stringtyp;
 char *string;
{
 HelpItem *helpfile;

 helpfile = (HelpItem *)malloc(sizeof(HelpItem));
 helpfile->type = (char *)malloc(TYPELENGTH*sizeof(char));

 if(     strcmp(stringtyp,"File") == 0)  helpfile->type="File";
 else if(strcmp(stringtyp,"Text") == 0)  helpfile->type="Text";
 else if(strcmp(stringtyp,"Path") == 0)  helpfile->type="Path";
 else if(strcmp(stringtyp,"Guide") == 0) helpfile->type="Guide";
 else if(strcmp(stringtyp,"Script") == 0) helpfile->type="Script";

 helpfile->item = (char *)malloc((strlen(string)+1)*sizeof(char));
 strcpy(helpfile->item,string);

 XtRemoveAllCallbacks(w, XmNhelpCallback );
 XtAddCallback(w, XmNhelpCallback, XuHelper, helpfile );

 return;
}

/***********************************************************************/
#include <varargs.h>
#include <malloc.h>
#define new_node(type)    ((type *) malloc( sizeof( type ) ))

typedef struct linklist {
   char              *s;
   struct linklist   *next;
} Linklist, *Linklistptr;

static char *concat( va_alist )
 va_dcl
{
 va_list       args;
 Linklistptr   firstlink = NULL, link, nextlink;
 char          *s;
 int           sum = 0;

 va_start( args );

 while ( (s = va_arg( args, char * )) )  {
   if( !firstlink )  /* first link */
      link = firstlink = new_node( Linklist );
   else  {
      link->next = new_node( Linklist );  /* attach previous link */
      link = link->next;
   }
   link->s = s;
   link->next = NULL;
   sum += strlen( s );
 }

 if( sum > 0 )  {
    s = (char *) calloc( 1, sum + 1 );  /* zero fill new string space */

    for( link = firstlink;  link;  link = nextlink )  {
       (void) strcat( s, link->s );
       nextlink = link->next;
       (void) free( link );  /* chuck this link node */
    }
 }
 else return( (char *)'\0' );

 va_end( args );

 return( s );
}


static XmString str_array_to_xmstr(cs, n)
 char    *cs[];
 int     n;
{
 XmString     xmstr;
 int          i;

 if(n <= 0)
    return (XmStringCreate("",XmSTRING_DEFAULT_CHARSET));

 xmstr = (XmString)NULL;

 for (i=0; i < n; i++)   {
    if (i>0)
       xmstr = XmStringConcat(xmstr, XmStringSeparatorCreate());

    xmstr = XmStringConcat(xmstr,
                           XmStringCreate(cs[i], XmSTRING_DEFAULT_CHARSET));
 }

 return (xmstr);
}


static XmString str_array_to_xmstr_concat(cs, n, xmstr_in)
 char    *cs[];
 int     n;
 XmString     xmstr_in;
{
 XmString     xmstr;
 int          i;

 if(n <= 0) return((XmString) NULL);
    xmstr = XmStringConcat(xmstr_in, XmStringSeparatorCreate());

 for (i=0; i < n; i++)   {
    if(i>0)xmstr = XmStringConcat(xmstr, XmStringSeparatorCreate());
    xmstr = XmStringConcat(xmstr,
                           XmStringCreate(cs[i], XmSTRING_DEFAULT_CHARSET));
 }
 return (xmstr);
}



#include <varargs.h>
static XmStringTable create_string_table( count, list ) 
 int             count;
 HelpList        *list;
{
 XmStringTable	string_table;
 unsigned	i, j;

 string_table = (XmStringTable)XtMalloc( (count+1)*sizeof( XmString ) );

 for( i = 0, j=0;  i < count;  i++ ) {
     string_table[j] = XmStringCreateLtoR( list[i].title, 
                                           XmSTRING_DEFAULT_CHARSET);
     j++;
 }

 string_table[count] = (XmString)NULL;
 return( string_table );
}



static void free_string_table( table )
 XmStringTable	table;
{
 unsigned	i;

 for( i = 0;  table[i] != 0;  i++ )
     XmStringFree( table[i] );
 XtFree( table );
 return;
}




/*-------------------------------------------------------------
**      OpenFile
**              Open the present file.  Returns 0 if file
**                   exists and open is sucessful.
-------------------------------------------------------------*/
static int OpenFile()
{
 struct stat statbuf;         /* Information on a file. */
 int file_length;             /* Length of file.        */
 unsigned char * file_string; /* Contents of file.      */
 char  *mess;
 FILE *fp = NULL;             /* Pointer to open file   */


 if ((fp = fopen(filename, "r")) == NULL) {
    mess = concat("Help file ",filename," not located",NULL);
    build_message(Top_Level_Shell, mess);
    XtFree(mess);
    return(1);
 }

 if (stat(filename, &statbuf) == 0)
    file_length = statbuf.st_size;
 else
    file_length = 3000; /* arbitrary file length */

 /* read the file string */
 file_string = (unsigned char *) XtMalloc((unsigned)file_length+1);
 fread(file_string, sizeof(char), file_length, fp);
 file_string[file_length] = NULL;

 /* close up the file */
 if (fclose(fp) != NULL) fprintf(stderr, "Warning: unable to close file.\n");

 /* added the file string to the text widget */
 if(text)XmTextSetString(text, file_string);
 XtFree(file_string);

 return(0);
}



static Dismiss_Button(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 XtDestroyWidget(XtParent(w));
 return;
}



static Selection_Dismiss_Button(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 XtDestroyWidget(XtParent(w));
 selectionBox = (Widget)NULL;
 return;
}


static void build_message(w, mess)
 Widget  w;
 char  *mess;
{
 Widget      mess_dialog;
 Arg         args[20];
 int         argcnt, i;
 XmString    xmstr[2];

 argcnt = 0;
 xmstr[1]=XmStringCreateLtoR(mess , XmSTRING_DEFAULT_CHARSET);
 XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;
 XtSetArg(args[argcnt], XmNokLabelString,
         (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;

 mess_dialog = XmCreateMessageDialog(w, "Message", args, argcnt);

 XtUnmanageChild(XmMessageBoxGetChild (mess_dialog, XmDIALOG_CANCEL_BUTTON));
 XtUnmanageChild(XmMessageBoxGetChild (mess_dialog, XmDIALOG_HELP_BUTTON));
 XtAddCallback(mess_dialog, XmNokCallback, Dismiss_Button, NULL);
 XtAddCallback(mess_dialog, XmNhelpCallback, XuNo_More_Help, NULL);
 XmStringFree( xmstr[0] );
 XmStringFree( xmstr[1] );

 XtManageChild(mess_dialog);
 return;
}


static void sel_callback(w, client, call)
 Widget w;
 caddr_t client;
 XmSelectionBoxCallbackStruct  *call;
{
 char *test;
 int i;
 Boolean found;

 XmAnyCallbackStruct *acs=(XmAnyCallbackStruct*)call;
 XmStringGetLtoR (call->value, XmSTRING_DEFAULT_CHARSET, &test);

 Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );

 filename = concat(help_path,"/",NULL);

 found = False;
 if(strcmp(test,"Whats_Next") == 0 ) {
    if(Whats_Next_Item != (HelpItem *)NULL) {
      filename = concat(filename, Whats_Next_Item->item, NULL);
      found = True;
    }
 }
 else {
   i = 0;
   while(listitems[i].helpitem.type != (char *)NULL){
      if(strcmp(test,listitems[i].title) == 0) { 
        filename = concat(filename,
        listitems[i].helpitem.item, NULL);
        found = True;
        break;
      }
      i++;
   }
 }

 if(!found)filename = concat(filename, test, NULL);

 XtFree(test);
 if(OpenFile()==0) XtManageChild(Help_Window);
 else  {
   XtDestroyWidget(Help_Window);  
   Help_Window = NULL;
   text = NULL;
  }
 return;
}


static void Help_Dismiss(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 if(XtParent(w) != NULL){
   XtUnmanageChild(XtParent(w));
   XtDestroyWidget(XtParent(w));
   Help_Window = NULL;
   text = NULL;
 }
 return;
}



void XuNo_More_Help(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 char *message = {"Sorry no more HELP available."};
 build_message(w, message);
 return;
}


/*  create help window  */
static Widget CreateHelpWindow(parent)
 Widget parent;
{
 Arg    	args[12];
 int    	argcnt;
 Widget 	retval,form,frame;
 XmString	xmstr[1];
 Widget	pushButton;

 argcnt = 0;
 retval = form = (Widget)XmCreateFormDialog(parent,"Help Information",args,argcnt);

 argcnt = 0;
 XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
 XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT);  argcnt++;
 XtSetArg(args[argcnt], XmNcolumns, (short)80); argcnt++;
 XtSetArg(args[argcnt], XmNrows, (short)24); argcnt++;
 text =(Widget)XmCreateScrolledText(form,"",args,argcnt);

 XtManageChild(text);

 argcnt = 0;
 XtSetArg(args[argcnt],XmNbottomAttachment,XmATTACH_FORM); argcnt++;
 XtSetArg(args[argcnt],XmNtopAttachment,XmATTACH_WIDGET); argcnt++;
 XtSetArg(args[argcnt],XmNtopWidget,text); argcnt++;
 XtSetArg(args[argcnt],XmNleftAttachment,XmATTACH_FORM); argcnt++;
 XtSetArg(args[argcnt],XmNrightAttachment,XmATTACH_FORM); argcnt++;
 pushButton = (Widget)XmCreatePushButton(form,"Dismiss",args,argcnt);

 XtAddCallback(pushButton, XmNactivateCallback, Help_Dismiss, NULL);
 XtAddCallback(text, XmNhelpCallback, XuNo_More_Help, NULL );
 XtAddCallback(pushButton, XmNhelpCallback, XuNo_More_Help, NULL );

 XtManageChild(pushButton);

 return( retval );
}


void XuHelp_On_Help(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 Widget      ver;
 Arg         args[2];
 int         argcnt, i;
 XmString    xmstr[2];

 argcnt = 0;
 XtSetArg(args[argcnt], XmNokLabelString,
     (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;


/*         build help on help XmString       */

/* help info */
 for(i=0; help_mess[i][0]  !=  '\0'; i++);
 xmstr[1] = str_array_to_xmstr(help_mess, i);

/* context help ? */
 if(help_context_text){
    for(i=0; help_mess_context[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_context, i, xmstr[1]);
 }

/* help index ? */
 if(help_index_text){
    for(i=0; help_mess_index[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_index, i, xmstr[1]);
 }

/* help on version ? */
 if(help_version_text){
    for(i=0; help_mess_version[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_version, i, xmstr[1]);
 }

/* help on keys ? */
 if(help_keys_text){
    for(i=0; help_mess_keys[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_keys, i, xmstr[1]);
 }

/* tutorial ? */
 if(help_tutorial_text){
    for(i=0; help_mess_tutorial[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_tutorial, i, xmstr[1]);
 }

/* help on windows  ? */
 if(help_windows_text){
    for(i=0; help_mess_windows[i][0]  !=  '\0'; i++);
    xmstr[1] = str_array_to_xmstr_concat(help_mess_windows, i, xmstr[1]);
 }

 XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;

/*        finished building  help on help XmString       */


 ver = XmCreateMessageDialog(Top_Level_Shell, "Help Facility", args, argcnt);

 XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_CANCEL_BUTTON));
 XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_HELP_BUTTON));
 XtAddCallback(ver, XmNokCallback, Dismiss_Button, NULL);
 XtAddCallback(ver, XmNhelpCallback, XuNo_More_Help, NULL );
 XmStringFree( xmstr[0] );
 XmStringFree( xmstr[1] );

 XtManageChild(ver);
 return;
}


void XuHelp_Index(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 Arg         args[12];
 int         argcnt;
 XmString    xmstr[3];
 XmString    *xmstrTable[125];


 if(selectionBox == NULL){
   argcnt = 0;
   XtSetArg(args[argcnt], XmNlistLabelString, (xmstr[0]=XmStringCreateLtoR(
                "Help Index", XmSTRING_DEFAULT_CHARSET))); argcnt++;

   XtSetArg(args[argcnt], XmNlistItems,
          (xmstrTable[0]=create_string_table(nlistitems, listitems))); argcnt++;

   XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
   XtSetArg(args[argcnt], XmNlistItemCount, (int)nlistitems); argcnt++;
   XtSetArg(args[argcnt], XmNlistVisibleItemCount, (int)10); argcnt++;
   XtSetArg(args[argcnt], XmNdialogType, XmDIALOG_SELECTION); argcnt++;
   XtSetArg(args[argcnt], XmNtextString, (xmstr[1]=XmStringCreateLtoR(
                "Whats_Next",XmSTRING_DEFAULT_CHARSET))); argcnt++;
   XtSetArg(args[argcnt], XmNcancelLabelString, (xmstr[2]=XmStringCreateLtoR(
                "Dismiss",XmSTRING_DEFAULT_CHARSET))); argcnt++;
   XtSetArg(args[argcnt], XmNwidth, 220); argcnt++;
   XtSetArg(args[argcnt], XmNheight, 524); argcnt++;
   selectionBox = (Widget)XmCreateSelectionDialog(w, "Help Topic Index",
                                                  args, argcnt);
   XtUnmanageChild(XmSelectionBoxGetChild (selectionBox, XmDIALOG_HELP_BUTTON));
   XtUnmanageChild(XmSelectionBoxGetChild (selectionBox, XmDIALOG_APPLY_BUTTON));
   XtAddCallback(selectionBox, XmNokCallback, sel_callback, NULL);
   XtAddCallback(selectionBox, XmNhelpCallback, XuNo_More_Help, NULL );
   XtAddCallback(selectionBox, XmNcancelCallback, Selection_Dismiss_Button, NULL );

   XmStringFree( xmstr[0] );
   XmStringFree( xmstr[1] );
   XmStringFree( xmstr[2] );
   free_string_table( xmstrTable[0] );

   XtManageChild(selectionBox);

 }
 return;
}



void XuHelper (w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 char *command;
 HelpItem *helpfile;

 helpfile=(HelpItem *)client;

 if( strcmp(helpfile->type,"Guide") == 0 ) {
   if (strncmp(helpfile->item,"/",1) == 0)
      command = concat("guide ",helpfile->item," &",NULL);
   else
      command = concat("guide -f",helpfile->item," ",guide_file," &",NULL);
   system(command);
 }
 else if( strcmp(helpfile->type,"Script") == 0 ) {
   command = concat(helpfile->item,NULL);
   system(command);
 }
 else {
    Help_Window = (Widget)CreateHelpWindow( Top_Level_Shell );

    if( strcmp(helpfile->type,"File") == 0 ||
        strcmp(helpfile->type,"Path") == 0 ) {

      if( strcmp(helpfile->type,"File") == 0)
        filename = concat(help_path,"/",helpfile->item,NULL);
      else
        filename = concat(helpfile->item,NULL);

      if(OpenFile()==0) XtManageChild(Help_Window);
      else  {
        XtDestroyWidget(Help_Window);
        Help_Window = NULL;
        text = NULL;
       }
    }
    else if(text) {
      XmTextSetString(text, (char *)helpfile->item);
      XtManageChild(Help_Window);
    }
 }
 return;
}



void XuHelp_On_Tutorial (w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 HelpItem *helpfile;

 helpfile=(HelpItem *)client;

 if(strcmp(helpfile->type,"Guide") != 0) 
   XuHelper ((Widget)NULL, client, (caddr_t)NULL);

 else { 
   char *text;
   text = concat("guide ", helpfile->item, " &", NULL);
   system(text);
 }
 return;
}


HelpItem *XuDisplay_Help (stringtyp, string)
 char *stringtyp;
 char *string;
{
 HelpItem *helpfile;

 helpfile = (HelpItem *)malloc(sizeof(HelpItem));
 helpfile->type = (char *)malloc(TYPELENGTH*sizeof(char));

 if(     strcmp(stringtyp,"File") == 0)  helpfile->type="File";
 else if(strcmp(stringtyp,"Text") == 0)  helpfile->type="Text";
 else if(strcmp(stringtyp,"Path") == 0)  helpfile->type="Path";
 else if(strcmp(stringtyp,"Guide") == 0) helpfile->type="Guide";
 else if(strcmp(stringtyp,"Script") == 0) helpfile->type="Script";

 helpfile->item = (char *)malloc((strlen(string)+1)*sizeof(char));
 strcpy(helpfile->item,string);

 XuHelper((Widget)NULL, (caddr_t)helpfile, (caddr_t)NULL);

 return helpfile;
}


void XuHelp_On_Context(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 Widget  This_Widget;
 extern Widget  Top_Level_Shell;

 This_Widget = (Widget)NULL;

 This_Widget = XmTrackingLocate(Top_Level_Shell,
               XCreateFontCursor(XtDisplay(Top_Level_Shell), XC_question_arrow), False);

 if(This_Widget != NULL)XtCallCallbacks(This_Widget, XmNhelpCallback, NULL);

 return;
}


void XuHelp_On_Version(w, client, call)
 Widget w;
 caddr_t client;
 caddr_t call;
{
 Widget      ver;
 Arg         args[20];
 int         argcnt, i;
 XmString    xmstr[2];

 argcnt = 0;

 for(i=0; version[i]  !=  NULL; i++);

 xmstr[1]  = str_array_to_xmstr(version, i);
 XtSetArg(args[argcnt], XmNmessageString, xmstr[1]); argcnt++;

 XtSetArg(args[argcnt], XmNokLabelString,
         (xmstr[0] = XmStringCreateLtoR("Dismiss",XmSTRING_DEFAULT_CHARSET)) ); argcnt++;

 ver = XmCreateMessageDialog(Top_Level_Shell, "Version", args, argcnt);

 XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_CANCEL_BUTTON));
 XtUnmanageChild(XmMessageBoxGetChild (ver, XmDIALOG_HELP_BUTTON));
 XtAddCallback(ver, XmNokCallback, Dismiss_Button, NULL);
 XtAddCallback(ver, XmNhelpCallback, XuNo_More_Help, NULL);

 XmStringFree( xmstr[0] );
 XmStringFree( xmstr[1] );

 XtManageChild(ver);

 return;
}
