#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/MenuShell.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>

#include  "HelpObject.h"

Boolean     help_version_text;
Boolean     help_context_text;
Boolean     help_windows_text;
Boolean     help_index_text;
Boolean     help_keys_text;
Boolean     help_tutorial_text;


void
XuCreateHelpPulldown(menuBar,helpdirectory, helplist, uversion, on_context,
                     on_keys, tutorial, on_windows)
Widget    menuBar;
char      *helpdirectory, **uversion;
Boolean   on_context, on_keys, on_windows;
HelpItem  *tutorial;
HelpList  *helplist;
{
    Arg    	args[20];
    int    	argcnt;
    Widget	menuShell;
    Widget	pulldownMenu;
    Widget	toggleButton;
    Widget	toggleButton1;
    Widget	toggleButton2;
    Widget	toggleButton3;
    Widget	toggleButton4;
    Widget	toggleButton5;
    Widget	toggleButton6;
    Widget	cascadeButton;

    extern char *help_path;
    extern HelpList *listitems;
    extern int  nlistitems;
    extern char **version;

    HelpItem *helpfile;

/*  create menu shell in menuBar     */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell = XtCreatePopupShell("menuShell", xmMenuShellWidgetClass,
		menuBar, args, argcnt);
    XtManageChild(menuShell);

 
/*  create pulldownMenu in menuShell  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldownMenu = XtCreateWidget("pulldownMenu", xmRowColumnWidgetClass,
		menuShell, args, argcnt);

 
/*  create toggleButton On Help   */
    if(helpdirectory != (char *)NULL) {
      help_path = helpdirectory;
      argcnt = 0;
      XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
      toggleButton = XtCreateWidget("On Help", xmToggleButtonWidgetClass,
                                     pulldownMenu, args, argcnt);
      XtAddCallback(toggleButton, XmNvalueChangedCallback, 
                    XuHelp_On_Help, (caddr_t)0);
      XuSet_Help( toggleButton, "File", "On_Help_Help" ); 
      XtManageChild(toggleButton);
     }
    else
      help_path = ".";

/*  create toggleButton  Index   */
    help_index_text = False;
    if(helplist != NULL) {
       help_index_text = True;
       argcnt = 0;
       XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
       toggleButton1 = XtCreateWidget("Index", xmToggleButtonWidgetClass,
		   pulldownMenu, args, argcnt);
       XtAddCallback(toggleButton1, XmNvalueChangedCallback, 
                     XuHelp_Index, (caddr_t)0);
       XuSet_Help( toggleButton1, "File", "On_Index_Help" ); 
       XtManageChild(toggleButton1);

       listitems = (HelpList *)helplist;
       nlistitems=0;
       while(helplist[nlistitems].helpitem.type != (char *)NULL) nlistitems++;
      }

/*  create toggleButton Version  */
    help_version_text = False;
    if(uversion != NULL) {
       help_version_text = True;
       argcnt = 0;
       XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
       toggleButton2 = XtCreateWidget("Version", xmToggleButtonWidgetClass,
		   pulldownMenu, args, argcnt);
       XtAddCallback(toggleButton2, XmNvalueChangedCallback, 
                     XuHelp_On_Version, (caddr_t)0);
       XuSet_Help( toggleButton2, "File", "On_Version_Help" ); 
       XtManageChild(toggleButton2);
       version = uversion;
      }


/*  create toggleButton On Context  */
    help_context_text = False;
    if(on_context) {
       help_context_text = True;
       argcnt = 0;
       XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
       toggleButton3 = XtCreateWidget("On Context", xmToggleButtonWidgetClass,
                   pulldownMenu, args, argcnt);
       XtAddCallback(toggleButton3, XmNvalueChangedCallback, 
                     XuHelp_On_Context, (caddr_t)0);
       XuSet_Help( toggleButton3, "File", "On_Context_Help" ); 
       XtManageChild(toggleButton3);
      }

/*  create toggleButton On Keys  */
    help_keys_text = False;
    if(on_keys) {
       help_keys_text = True;
       argcnt = 0;
       XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
       toggleButton4 = XtCreateWidget("On Keys", xmToggleButtonWidgetClass,
                   pulldownMenu, args, argcnt);

       helpfile = (HelpItem *)malloc(sizeof(HelpItem));
       helpfile->type = (char *)malloc(TYPELENGTH*sizeof(char));
       helpfile->type="File";
       helpfile->item = (char *)malloc((strlen("On_Keys_Text")+1)*sizeof(char));
       strcpy(helpfile->item,"On_Keys_Text");
       XtAddCallback(toggleButton4, XmNvalueChangedCallback, XuHelper, helpfile);

       XuSet_Help( toggleButton4, "File", "On_Keys_Help" ); 
       XtManageChild(toggleButton4);
      }


/*  create toggleButton Tutorial   */
    help_tutorial_text = False;
    if(tutorial != NULL) {
       help_tutorial_text = True;
       argcnt = 0;
       XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
       toggleButton5 = XtCreateWidget("Tutorial", xmToggleButtonWidgetClass,
                   pulldownMenu, args, argcnt);
       XtAddCallback(toggleButton5, XmNvalueChangedCallback, 
                     XuHelp_On_Tutorial, tutorial);
       XuSet_Help( toggleButton5, "File", "On_Tutorial_Help" ); 
       XtManageChild(toggleButton5);
      }


/*  create toggleButton On Windows   */
    help_windows_text = False;
    if(on_windows) {
      help_windows_text = True;
      argcnt = 0;
      XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
      toggleButton6 =XtCreateWidget("On Windows",xmToggleButtonWidgetClass,
                                    pulldownMenu, args, argcnt);

      helpfile = (HelpItem *)malloc(sizeof(HelpItem));
      helpfile->type = (char *)malloc(TYPELENGTH*sizeof(char));
      helpfile->type="File";
      helpfile->item = (char *)malloc((strlen("On_Windows_Text")+1)*sizeof(char));
      strcpy(helpfile->item,"On_Windows_Text");
      XtAddCallback(toggleButton6, XmNvalueChangedCallback, XuHelper, helpfile);

      XuSet_Help( toggleButton6, "File", "On_Windows_Help" ); 
      XtManageChild(toggleButton6);
    }


/* create cascadeButton with sub_menu = pulldownMenu   */
/*        pulldownMenu is parent of all toggleButtons  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldownMenu); argcnt++;
    cascadeButton = XtCreateWidget("Help", xmCascadeButtonWidgetClass,
		menuBar, args, argcnt);
    XuSet_Help( cascadeButton, "File", "On_Help_Help" ); 


/*  force the Help button to be located to the far right in menuBar  */
/*  comment if not wanted  */
    argcnt=0;
    XtSetArg (args[argcnt], XmNmenuHelpWidget, cascadeButton); argcnt++;
    XtSetValues(menuBar, args, argcnt);

    XtManageChild(cascadeButton);

}

