/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_query(s, l, a)
char	*s, **a;
int	l;
	{
	int	i;
	char	line[256];
	struct chd_struct	samp, *p, *chd_srch();

	if (abbrev("CONFIG", *a, 4)) {
		int	units = 0, chgrs = 0, drives = 0, io = 0, slots = 0;

		for (i = 0; i < chd_count; i++)
			switch (chdx[i].chd_symbname) {
				case CHD_CHM:
					chgrs++; break;
				case CHD_DRIVE:
					drives++; break;
				case CHD_SLOT:
					slots++; break;
				case CHD_INOUT:
					io++; break;
				case CHD_UNITID:
					units++; break;
				}

		(void) sprintf(line,
			"Config Unit %d Chm %d Drive %d Slot %d I/O %d",
			units, chgrs, drives, slots, io);
		post_msg(286, line);
		}

	else if (abbrev("CONNECTION", *a, 3)) {
		post_msg(200, "Okay");
		}

	else if (abbrev("RESOURCE", *a, 3)) {
		int	drives = 0, empty = 0, scratch = 0, loaded = 0,
			occupied = 0, unavail = 0, j;

		for (i = 0; i < chd_count; i++)
			switch (chdx[i].chd_symbname) {
				case CHD_DRIVE:
					if (chdx[i].chd_symbstat == CHD_EMPTY)
						drives++;
					break;
				case CHD_SLOT:
					switch (j = chdx[i]. chd_symbstat) {
						case CHD_EMPTY:
							empty++; break;
						case CHD_SCRATCH:
							scratch++; break;
						default:
							if (j > 0)
								loaded++;
							else
								if (j == CHD_FULL)
									occupied++;
								else
									unavail++;
						}
				} 

		(void) sprintf(line,
			"Resource Drives %d Empty %d Scratch %d Loaded %d Occupied %d Unavail %d",
			drives, empty, scratch, loaded, occupied, unavail);
		post_msg(287, line);
		}

	else if (abbrev("VOLUME", *a, 1)) {
		if (a[1] == NULL)
			post_msg(480, "Volume Not Specified");
		else	{
			chd_fill(&samp, 0, 0, CHD_SLOT, CHD_EMPTY, a[1]);

			if ((p = chd_srch(CHDX, &samp, CHD_VOL)) != NULL)
				chd_prtln(280, p);
			else	{
				(void) sprintf(line,
					"Volume \"%s\" Not Found", a[1]);
				post_msg(480, line);
				}
			}
		}

	else if (abbrev("SLOT", *a, 1)) {
		if (a[1] == NULL)
			post_msg(481, "Slot Id Not Specified");
		else	{
			if (!sscanf(a[1], "%d", &i))
				i = -1;
			chd_fill(&samp, i, 0, CHD_SLOT, CHD_EMPTY, NULL);

			if ((p = chd_srch(CHDX, &samp, CHD_NAME)) != NULL)
				chd_prtln(281, p);
			else	{
				(void) sprintf(line,
					"Slot \"%s\" Not Found", a[1]);
				post_msg(481, line);
				}
			}
		}

	else if (abbrev("DRIVE", *a, 1)) {
		if (a[1] == NULL)
			post_msg(482, "Drive Id Not Specified");
		else	{
			if (!sscanf(a[1], "%d", &i))
				i = -1;
			chd_fill(&samp, i, 0, CHD_DRIVE, CHD_EMPTY, NULL);

			if ((p = chd_srch(CHDX, &samp, CHD_NAME)) != NULL)
				chd_prtln(282, p);
			else	{
				(void) sprintf(line,
					"Drive \"%s\" Not Found", a[1]);
				post_msg(482, line);
				}
			}
		}

	else if (abbrev("UNIT", *a, 1)) {
		if (a[1] == NULL)
			post_msg(483, "Unit Id Not Specified");
		else	{
			if (!sscanf(a[1], "%d", &i))
				i = -1;
			chd_fill(&samp, i, 0, CHD_UNITID, CHD_EMPTY, NULL);

			if ((p = chd_srch(CHDX, &samp, CHD_NAME)) != NULL)
				chd_prtln(283, p);
			else	{
				(void) sprintf(line,
					"Unit \"%s\" Not Found", a[1]);
				post_msg(483, line);
				}
			}
		}

	else if (abbrev("CHM", *a, 1)) {
		if (a[1] == NULL)
			post_msg(484, "Chm Id Not Specified");
		else	{
			if (!sscanf(a[1], "%d", &i))
				i = -1;
			chd_fill(&samp, i, 0, CHD_CHM, CHD_EMPTY, NULL);

			if ((p = chd_srch(CHDX, &samp, CHD_NAME)) != NULL)
				chd_prtln(284, p);
			else	{
				(void) sprintf(line,
					"Chm \"%s\" Not Found", a[1]);
				post_msg(484, line);
				}
			}
		}

	else if (abbrev("ALL", *a, 1)) {
		for (i = 0; i < chd_count; i++)
			chd_prtln(385, &(chdx[i]));

		post_msg(285, "Command Complete");
		}
	else	{
		(void) sprintf(line, "Unknown Query \"%s\"", *a);
		post_msg(480, line);
		}
	}
