/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_unload(s, l, a)
char	*s, **a;
int	l;
	{
	char	*p, *vol = NULL, line[256];
	int	i, status = CHD_FULL, slot = 0, op_unload(),
		drive = 0, mask = 0, abbrev();
	struct chd_struct	*src, *rbt, *unt, *tgt, *z, samp, *chd_srch();

	for (i= 0, p = a[i]; p != NULL; i++, p = a[i]) {
		if (abbrev("VOLUME", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				vol = a[i];
			}
		else if (abbrev("SLOT", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &slot);
			}
		else if (abbrev("DRIVE", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &drive);
			}
		}

	if (((slot != 0 && vol != NULL) ||
		(slot != 0 && drive != 0) ||
		(vol != NULL && drive != 0)) ||
		(slot == 0 && vol == NULL && drive == 0))
		post_msg(460,
			"Usage: Unload Volume VVVVVVVV | Slot NN | Drive NN");

	else	{
		if (drive != 0) {
			chd_fill(&samp, drive, 0, CHD_DRIVE, CHD_NOTEMPTY, vol);
			if (src = chd_srch(CHDX, &samp, CHD_NAME | CHD_STAT)) {
				chd_fill(&samp, src->chd_symbstat, 0, CHD_SLOT, 0, NULL);
				tgt = chd_srch(CHDX, &samp, CHD_NAME);

				chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
				unt = chd_srch(CHDX, &samp, CHD_NAME);
				chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
				rbt = chd_srch(CHDX, &samp, CHD_UNIT);

				if (op_unload(src, tgt, rbt, unt)) {
					src->chd_symbstat = CHD_EMPTY;
					tgt->chd_symbstat = CHD_FULL;
					chd_save(CHDX);
	
					(void) sprintf(line,
						"Unload Vol %s Slot %d Drive %d Den %d Unit %d",
						tgt->chd_label,
						tgt->chd_symbid,
						src->chd_symbid,
						src->chd_densid,
						src->chd_unitid);
					post_msg(260, line);
					}
				else	{
					post_msg(460, "Unload Operation Failed");
					}
				}
			else
				post_msg(460, "Drive Currently Unoccupied");
			}

		else	{
			if (slot != 0) {
				chd_fill(&samp, slot, 0, CHD_SLOT, CHD_LOADED, NULL);
				mask = CHD_NAME;
				}
			else if (vol != NULL) {
				chd_fill(&samp, 0, 0, CHD_SLOT, CHD_LOADED, vol);
				mask = CHD_VOL;
				}

			if (tgt = chd_srch(CHDX, &samp, mask | CHD_STAT)) {
				chd_fill(&samp, tgt->chd_symbstat, 0, CHD_DRIVE, CHD_EMPTY, NULL);
				src = chd_srch(CHDX, &samp, CHD_NAME);

				chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
				unt = chd_srch(CHDX, &samp, CHD_NAME);
				chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
				rbt = chd_srch(CHDX, &samp, CHD_UNIT);
	
				if (op_unload(src, tgt, rbt, unt)) {
					src->chd_symbstat = CHD_EMPTY;
					tgt->chd_symbstat = CHD_FULL;
					chd_save(CHDX);
	
					(void) sprintf(line,
						"Unload Vol %s Slot %d Drive %d Den %d Unit %d",
						tgt->chd_label,
						tgt->chd_symbid,
						src->chd_symbid,
						src->chd_densid,
						src->chd_unitid);
					post_msg(260, line);
					}
				else
					post_msg(460, "Unload Operation Failed");
				}
			else
				post_msg(460, "Vol Not Currently Loaded");
			}

		}
	}
