/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

#define		FALSE	0
#define		TRUE	1

int
process_cmd(s)
char	*s;
	{
	int	largs, abbrev(), argsep(), my_lock(), my_unlock();
	char	*cmd, *args, *shiftup(), *alist[20], line[256];
	struct chd_struct	*z, *chd_load();

	cmd = shiftup(strtok(s, " ,\t"));
	args = shiftup(strtok(NULL, ""));
	largs = argsep(args, alist);

	if (abbrev("QUIT", cmd, 3))
		return FALSE;
	else if (abbrev("EXIT", cmd, 4))
		return FALSE;
	else if (abbrev("HELP", cmd, 1))
		do_help(args, largs, alist);
	else if (abbrev("?", cmd, 1))
		do_help(args, largs, alist);
	else if (abbrev("SLEEP", cmd, 2))
		do_sleep(args, largs, alist);
	else if (abbrev("EMERGENCY-UNLOCK", cmd, 6))
		if (!(my_unlock(CHD_LOCKFILE)))
			post_msg(411, "Media Changer Unlock Error");
		else	{
			lock_held = FALSE;
			post_msg(200, "Media Changer Lock Removed (RISKY)");
			}
	else	{
		if (!(my_lock(CHD_LOCKFILE))) {
			post_msg(410, "Media Changer Service Unavailable");
			return TRUE;
			}
		lock_held = TRUE;

		z = chd_load(CHDX);

		if (abbrev("QUERY", cmd, 1))
			do_query(args, largs, alist);
		else if (abbrev("SET", cmd, 1))
			do_set(args, largs, alist);
		else if (abbrev("ALLOCATE", cmd, 1))
			do_def(args, largs, alist);
		else if (abbrev("DEALLOCATE", cmd, 1))
			do_undef(args, largs, alist);
		else if (abbrev("LOAD", cmd, 1))
			do_load(args, largs, alist);
		else if (abbrev("MOUNT", cmd, 1))
			do_load(args, largs, alist);
		else if (abbrev("UNLOAD", cmd, 1))
			do_unload(args, largs, alist);
		else if (abbrev("UNMOUNT", cmd, 1))
			do_unload(args, largs, alist);
		else if (abbrev("DISMOUNT", cmd, 4))
			do_unload(args, largs, alist);
		else if (abbrev("IMPORT", cmd, 1))
			do_import(args, largs, alist);
		else if (abbrev("EXPORT", cmd, 1))
			do_export(args, largs, alist);
		else if (abbrev("RESET", cmd, 3))
			do_reset(args, largs, alist);
		else if (abbrev("SYSTEM", cmd, 6))
			do_syscall(args, largs, alist);
		else	{
			(void) sprintf(line, "Command \"%s\" Unknown", cmd);
			post_msg(480, line);
			}

		lock_held = FALSE;

		if (!(my_unlock(CHD_LOCKFILE)))
			post_msg(411, "Media Changer Unlock Error");

		}

	return TRUE;
	}
