/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* client.c - main - From Doug Comer... */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

#include	"chddef.h"

struct chd_stream human = { 0, 0, CHD_STREAM_SIZE, NULL, " " };
struct chd_stream tcpip = { 0, 0, CHD_STREAM_SIZE, NULL, " " };

main(argc, argv)
int argc;
char **argv;
	{
	unsigned long	l_address = 0;
	int c, s, len, irc, p_flag = 0, e_flag = 0;
	struct sockaddr_in sa, la;
	struct hostent *hp, mynet;
	struct servent *sp;
	char human_buf[4096], tcpip_buf[4096], *p;
	char *getnxtln();
	char *myname;
	char *host, hostbuf[512];

	extern char	*optarg;
	extern int	optind;

	(void) gethostname(hostbuf, 512);

	host = hostbuf;
	myname = argv[0];
	if (*myname == '-')
		p_flag = 1;

	while ((c = getopt(argc, argv, "ef:h:p")) != -1)
		switch (c) {
			case 'e':
				e_flag = 1;
				break;
			case 'f':
				if (!(freopen(optarg, "r", stdin))) {
					perror("reopen");
					exit(1);
					}
				break;
			case 'h':
				host = optarg;
				break;
			case 'p':
				p_flag = 1;
				break;
			default:
				break;
			}

	if ((hp = gethostbyname(host)) == NULL) {
		l_address = inet_addr(host);
		if ((long) l_address == -1) {
			fprintf(stderr, "%s: %s: no such host?\n",
				myname, host);
			exit(1);
			}
		else	{
			hp = gethostbyaddr(&l_address, sizeof(unsigned long),
				AF_INET);
			}
		}

	if (hp == 0) {
		bcopy(&l_address, (char *)&sa.sin_addr, sizeof(unsigned long));
		sa.sin_family = AF_INET;
		}
	else	{
		bcopy((char *)hp->h_addr, (char *)&sa.sin_addr, hp->h_length);
		sa.sin_family = hp->h_addrtype;
		}

	if ((sp = getservbyname(CHD_SERVPORT, "tcp")) == NULL) {
		fprintf(stderr, "%s: No Media Changer Service on this host\n", myname);
		exit(1);
		}

	sa.sin_port = sp->s_port;

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		exit(1);
		}

	tcpip.chd_fd = s;

	bzero((char *)&la, sizeof(la));
	la.sin_family = AF_INET;
	*((u_long *) (&la.sin_addr)) = INADDR_ANY;

	if (connect(s, &sa, sizeof(sa)) < 0) {
		perror("connect");
		exit(1);
		}


	while (1)
		if (strlen((p = getnxtln(&tcpip, tcpip_buf)))) {
			write(fileno(stdout), strcat(p, "\n"), strlen(p));
			if ((strncmp("211", p, 3) == 0) || (*p == '5'))
				break;
			if (*p != '3') {
				while (1) {
					if (p_flag)
						write(fileno(stdout),
							">>> ",4);
					p = getnxtln(&human, human_buf);
					if (strlen(p) != 0 && *p != '#') {
						write(s, strcat(p, "\r\n"),
							strlen(p));
						if (e_flag) {
							write(fileno(stdout),
								">>> ", 4);
							write(fileno(stdout),
								p, strlen(p));
							}
						break;
						}
					}
				}
			}

	close(s);
	exit(0);
	}

