/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/uio.h>
#include	<string.h>
#include	<strings.h>

#define		FALSE	0
#define		TRUE	1

/**********/
/*
/*	ctd_sync - synchronize ctd_8l robot after command
/*
/*	fd:	file descriptor for robot
/*	s:	data buffer for returned error messages
/*
/*	Return Values:
/*		TRUE if no errors are detected
/*		FALSE if error messages are encountered
/*		"s" array will contain error string...
/*
/**********/

int
ctd_sync(fd, s)
int	fd;
char	*s;
	{
	int	l, rc = 1, err_cond = FALSE, ctd_getnxt();
	char	*p, *q, line[2];

	p = strcpy(line, "X");
	q = strcpy(s, "");

	for (l = ctd_getnxt(fd, p);
		l > 0 && *p != '>';
		l = ctd_getnxt(fd, p)) {

		if (err_cond)
			if (*p == '\r' || *p == '\n') {
				err_cond = FALSE;
				}
			else	{
				*q++ = *p;
				*q = NULL;
				}

		else if (*p == '*') {
			rc = -1;
			err_cond = TRUE;
			*q++ = *p;
			*q = NULL;
			}
		}

	if (l < 1)
		rc = -1;

	return rc;
	}

