/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/termios.h>
#include	<fcntl.h>

#define	BAD	1
#define	GOOD	0

#define	TRUE	1
#define	FALSE	0

#define		USAGE		"usage: exb_10 -L|U|I|E|S|Z [-d file_id] [-h handler_file_id] -s nn -c nn -t nn\n"
#define		CHANGER		"/dev/serial_switch0"
#define		TAPEDRIVE	"/dev/rst0"

#define		INIT_STRING	"m"
#define		STOP_STRING	"Q"
#define		HOME_POS	"a"

char		*o_lm[] = {	"EGPCa",
				"jEGkPCa",
				"jjEGkkPCa",
				"jjjEGkkkPCa",
				"jjjjEGkkkkPCa",
				"jjjjjEGkkkkkPCa",
				"jjjjjjEGkkkkkkPCa",
				"jjjjjjjEGkkkkkkkPCa",
				"jjjjjjjjEGkkkkkkkkPCa",
				"jjjjjjjjjEGkkkkkkkkkPCa",
				"jjjjjjjjjjEGkkkkkkkkkkPCa"
			};

char		*o_um[] = {	"EGPa",
				"EGjPa",
				"EGjjPa",
				"EGjjjPa",
				"EGjjjjPa",
				"EGjjjjjPa",
				"EGjjjjjjPa",
				"EGjjjjjjjPa",
				"EGjjjjjjjjPa",
				"EGjjjjjjjjjPa",
				"EGjjjjjjjjjjPa",
			};

main(argc, argv)
int	argc;
char	**argv;
	{
	FILE		*fd;
	extern char	*optarg;
	extern int	optind;
	int		irc, c, operation = 'L', check_door(), open_door(),
			handler = 0, source = 0, target = 0, density = 0,
			physical = 0;
	int		no_load = FALSE;
	struct	termios	control_mode;
	char		*file_id = CHANGER;
	char		*tapedrive = TAPEDRIVE;

	while ((c = getopt(argc, argv, "EILSUZc:d:h:m:np:s:t:?")) != -1)
		switch (c) {
		case 'd':
			tapedrive = optarg;
			break;
		case 'h':
			file_id = optarg;
			break;
		case 'c':
			sscanf(optarg, "%d", &handler);
			break;
		case 'm':
			sscanf(optarg, "%d", &density);
			break;
		case 'p':
			sscanf(optarg, "%d", &physical);
			break;
		case 's':
			sscanf(optarg, "%d", &source);
			break;
		case 't':
			sscanf(optarg, "%d", &target);
			break;
		case 'E':
		case 'I':
			exit(BAD);
		case 'Z':
		case 'S':
		case 'L':
		case 'U':
			operation = c;
			break;
		case 'n':
			no_load = TRUE;
			break;
		case '?':
		default:
			fprintf(stderr, USAGE);
			exit(BAD);
		}

	if ((fd = fopen(file_id, "w")) == NULL)
		exit(BAD);

/* non-portable - changed 7/17/01 by joe m. wade

	irc = ioctl(fileno(fd), TCGETS, &control_mode);
*/
	irc = tcgetattr(fileno(fd), &control_mode);
	control_mode.c_iflag = 0;
	control_mode.c_oflag &= ~OPOST;
	control_mode.c_cflag |= CS8;
	control_mode.c_cflag &= ~PARENB;
	control_mode.c_lflag = 0;

/* non-portable - changed 7/17/01 by joe m. wade

	irc = ioctl(fileno(fd), TCSETS, &control_mode);
*/
	irc = tcsetattr(fileno(fd), TCSANOW, &control_mode);

	fprintf(fd, HOME_POS);
	fflush(fd);
	sleep(2);

	if (operation == 'L') {

		fprintf(fd, o_lm[source]);
		fflush(fd);

		sleep(25);

		if ((!(no_load)) && (!(check_door(tapedrive))))
			exit(BAD);
		}

	else if (operation == 'U') {

		if (no_load || open_door(tapedrive)) {

			fprintf(fd, o_um[target]);
			fflush(fd);

			sleep(25);
			}
		else	{
			post_msg(330,"Drive Already Opened By Application");
			fprintf(fd, o_um[target]);
			fflush(fd);

			sleep(25);
			}
		}

	else if (operation == 'S') {

		fprintf(fd, INIT_STRING);
		fprintf(fd, HOME_POS);
		fflush(fd);

		sleep(10);
		}

	else if (operation == 'Z') {

		fprintf(fd, STOP_STRING);
		fflush(fd);

		sleep(5);
		}

	else	{

		(void) fclose(fd);

		sleep(1);

		exit(BAD);
		}

	(void) fclose(fd);

	sleep(1);

	exit(GOOD);
	}
