/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#ifdef		TRIAL_RUN
#define		CHD_FILENAME	"/data/gs53/data1/zrlw05/chd/chd.conf"
#else
#define		CHD_FILENAME	"/etc/chd.conf"
#endif

#define		CHD_LOCKFILE	"/tmp/chd.lock"

#define		CHD_WORKDIR	"/tmp"

#define		CHD_SERVPORT	"media-changer"

#define		NO_LOAD_TAPE	"SPECIAL_CARTRIDGE"

#define		CHD_TYPE	1	/* Search Entity Type	*/
#define		CHD_UNIT	2	/* Search by Unit	*/
#define		CHD_VOL		4	/* Search by Volume	*/
#define		CHD_STAT	8	/* Search by Status	*/
#define		CHD_NAME	16	/* Search by SymbName	*/

#define		CHD_CHM		0	/* Cartridge Handler	*/
#define		CHD_DRIVE	1	/* Cartridge Transport	*/
#define		CHD_SLOT	2	/* Cartridge Storage	*/
#define		CHD_INOUT	3	/* Import/Export Portal	*/
#define		CHD_UNITID	4	/* Phys Unit Identifier	*/

#define		CHD_EMPTY	0	/* Unoccupied Slot	*/
#define		CHD_FULL	-1	/* Occupied Slot	*/
#define		CHD_SCRATCH	-2	/* Occupied Scratch	*/
#define		CHD_NOTEMPTY	-3	/* Occupied or Loaded	*/
#define		CHD_NONEMPTY	-4	/* Occupied or Scratch	*/
#define		CHD_LOADED	-5	/* Occupied AND Loaded	*/

#define		CHD_NODRIVE	-1	/* No Drive Requested	*/

#define		CHD_UNITUP	0	/* Unit is Enabled	*/
#define		CHD_UNITDOWN	-1	/* Unit is Not Enabled	*/
#define		CHD_UNITONL	-2	/* Unit is Online	*/
#define		CHD_UNITOFFL	-3	/* Unit is Not Online	*/

#define		CHD_STREAM_SIZE	1024

struct chd_stream	{
			int	chd_fd;
			int	chd_left;
			int	chd_bsize;
			char	*chd_p;
			char	chd_buf[CHD_STREAM_SIZE];
			};

struct chd_struct	{
			int	chd_uniqid,
				chd_symbid,
				chd_unitid,
				chd_scsiid,
				chd_densid,
				chd_physid,
				chd_symbname,
				chd_symbstat;
			char	chd_label[128];
			};

