/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
/*
#include <Xm/CascadeBP.h>
*/
#include <resources.h>
#include <global.h>
#include <version.h>

unsigned long mask;
XSetWindowAttributes attr;
Dimension display_width,display_height;
XtAppContext app_con;
Display *dpy = NULL;
Widget chd_stat_text;
Window	*busy_win;
Widget	display;
Widget	create_button();
Widget	history_text;
Widget	allocate_list,deallocate_list;
void	quit_chd();
void	get_from_chd();
void	send_to_chd();
void	simple_cmd();
void	comments();
char	msg_text[256];
char	chd_text[80];

#define MAX(a,b) ((a)>(b) ? (a) : (b))

ApplicationData data;
SearchList tmplist[4];

static XrmOptionDescRec options[] = {
	{"-b",		"*blockSize",	XrmoptionSepArg,	"0"}};

static XtResource resources[] = {
	{ "author", "Author", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,author),
	    XtRString, ""}};

void simple_cmd(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	int status;
	Boolean bad_status = FALSE;
	chd_cmd((char *)client_data);
	chd_stat(TRUE,TRUE);
}

void updateSlotItem(list,list_xmstring)
Widget list;
XmString list_xmstring;
{
	int slot;
	unsigned int alloc_length;
	int chd_status,unit,arg,den,phys;
	char *list_item;
	char stat[32],vol[32];
	XmString item;
	char *chd_line;

	if ( XmStringGetLtoR(list_xmstring,
	    XmSTRING_DEFAULT_CHARSET, &list_item) ) {
	    sscanf(list_item,"%d",&slot);
	
	  sprintf(chd_text,"query slot %d",slot);
	  chd_cmd(chd_text);

	  if (chd_stat(FALSE,FALSE) == 281) {
	    chd_line = get_chd_line(FALSE);
	    list_item = XtRealloc(list_item,MAX(strlen(chd_line)-3,64));
	    sscanf(chd_line," Slot %d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s",&slot,&unit,&arg,&den,&phys,stat,vol);
	    sprintf(list_item," %2d      %2d      %2d      %d      %d    %8s  %-16s",slot,unit,arg,den,phys,stat,vol);
	    item = XmStringCreateLtoR(&list_item[0],XmSTRING_DEFAULT_CHARSET);
	    XmListReplaceItems(list,&list_xmstring,1,&item);
	    XmStringFree(item);
	    XtFree(chd_line);
	    }
	  else
	    chd_response(FALSE,TRUE);
	  free(list_item);
	  }
}
void allocate_selections(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	int count;
	char *selection;
/*
	char identifier[32],stat[32],vol[32];
	int slot,unit,drive,drive_unit;
	int arg,den,phys;
*/
	int selected_item_count;
	char slot[8];
	XmString label;
	Widget dialog,top_ref,align;
	Widget slot_heading,volume_heading,scratch_heading;
	Widget slot_label,volume_entry,scratch_toggle;
	XmStringTable items;

	XtVaGetValues((Widget)client_data,
			XmNselectedItemCount,	&selected_item_count,
			XmNselectedItems,	&items,
			NULL);
	if (selected_item_count == 0) return;

	dialog = XmCreateFormDialog(widget,"dialog", NULL, 0);
	
	label = XmStringCreateLtoR( "Slot",
		XmSTRING_DEFAULT_CHARSET);

        slot_heading = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNwidth,		100,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	top_ref = slot_heading;

	label = XmStringCreateLtoR( "Volume",
		XmSTRING_DEFAULT_CHARSET);

        volume_heading = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNwidth,		100,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		slot_heading,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	label = XmStringCreateLtoR( "Scratch",
		XmSTRING_DEFAULT_CHARSET);

        scratch_heading = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNwidth,		100,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_heading,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	label = XmStringCreateLtoR( "scratch",
		XmSTRING_DEFAULT_CHARSET);


/*
	for (count=0; count<((XmListCallbackStruct *)call_data)->selected_item_count; count++) {
*/
	for (count=0; count < selected_item_count; count++) {
	  if ( XmStringGetLtoR(items[count],
			XmSTRING_DEFAULT_CHARSET,&selection) ) {
	    sscanf(selection,"%s",slot);
	    label = XmStringCreateLtoR( slot, XmSTRING_DEFAULT_CHARSET);
	    }
	  slot_label = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		top_ref,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNrightWidget,		slot_heading,
			XmNlabelString,		label,
			NULL);
	  XmStringFree(label);
	  XmStringFree(items[count]);

	  volume_entry = XtVaCreateManagedWidget("label",
		xmTextWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		top_ref,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		slot_label,
			XmNrightAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNrightWidget,		volume_heading,
			NULL);

	  label = XmStringCreateLtoR( "", XmSTRING_DEFAULT_CHARSET);
	  scratch_toggle = XtVaCreateManagedWidget("label",
		xmToggleButtonWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		top_ref,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_entry,
			XmNrightAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNrightWidget,		scratch_heading,
			XmNlabelString,		label,
			NULL);

	  top_ref = slot_label;
	  }
	XtManageChild(dialog);
}
void do_allocate(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	Widget *widgets = (Widget *)client_data;
	XmStringTable items;

	if (XmToggleButtonGetState(widgets[3])) {
	  sprintf(chd_text,"Allocate Slot %s Volume %s Scratch",
		XmTextGetString(widgets[1]),
		XmTextGetString(widgets[2]));
	  }
	else {
	  sprintf(chd_text,"Allocate Slot %s Volume %s",
		XmTextGetString(widgets[1]),
		XmTextGetString(widgets[2]));
	  }

	chd_cmd(chd_text);

	if (chd_stat(FALSE,TRUE) < 400) {
	  XtVaGetValues(widgets[4],
		XmNselectedItems,	&items,
		NULL);
	  updateSlotItem(widgets[4],items[0]);
	  }
	else
	  system("xalert -C XChd OK 'Allocation request failed; check' 'History under Misc pulldown for more info'");
	XtDestroyWidget(widgets[0]);
	XtFree((char *)client_data);
}
void allocate_selection(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	char *selection;
	char identifier[32],stat[32],vol[32];
	char *label_str = "Allocate Volume for Slot";
	char slot[8];
	int unit,drive,drive_unit;
	int arg,den,phys;
	XmString label;
	Widget dialog,*widgets,heading,slot_text,volume_label,volume_entry,
		scratch_toggle, ok_button, cancel_button, align ;

	if ( XmStringGetLtoR(((XmListCallbackStruct *)call_data)->item,
			XmSTRING_DEFAULT_CHARSET,&selection) ) {
	  sscanf(selection,"%s %d %d %d %d %s %s",
		slot,&unit,&arg,&den,&phys,stat,vol);
	  }
	label = XmStringCreate(label_str, XmSTRING_DEFAULT_CHARSET);

	dialog = XmCreateFormDialog(widget,"allocate", NULL, 0);
	XtVaSetValues(dialog,
			XmNmappedWhenManaged,	TRUE,
			NULL);

	align = XtVaCreateManagedWidget("align",
		xmFormWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

        heading = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, align,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	
	label = XmStringCreateLtoR( slot, XmSTRING_DEFAULT_CHARSET);

        slot_text = XtVaCreateManagedWidget("label",
		xmTextWidgetClass, align,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		heading,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNvalue,		slot,
			XmNcolumns,		3,
			XmNborderWidth,		0,
			XmNeditable,		FALSE,
			NULL);
	XmStringFree(label);

	label = XmStringCreateLtoR( "Volume",
		XmSTRING_DEFAULT_CHARSET);

	align = XtVaCreateManagedWidget("align",
		xmFormWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		align,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

        volume_label = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, align,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	volume_entry = XtVaCreateManagedWidget("volume",
		xmTextWidgetClass, align,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_label,
			NULL);

	label = XmStringCreateLtoR( "Scratch", XmSTRING_DEFAULT_CHARSET);

	scratch_toggle = XtVaCreateManagedWidget("scratch",
		xmToggleButtonWidgetClass, align,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_entry,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	label = XmStringCreateLtoR( "OK",
		XmSTRING_DEFAULT_CHARSET);

	align = XtVaCreateManagedWidget("align",
		xmFormWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		align,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

        ok_button = XtVaCreateManagedWidget("ok",
		xmPushButtonWidgetClass, align,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	20,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	40,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	label = XmStringCreateLtoR( "Cancel",
		XmSTRING_DEFAULT_CHARSET);

        cancel_button = XtVaCreateManagedWidget("cancel",
		xmPushButtonWidgetClass, align,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	60,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	XtAddCallback(cancel_button, XmNactivateCallback, drop_dialog, dialog);

	widgets = (Widget *) XtMalloc(5*sizeof(Widget));
	widgets[0] = dialog;
	widgets[1] = slot_text;
	widgets[2] = volume_entry;
	widgets[3] = scratch_toggle; 
	widgets[4] = widget; 
	XtAddCallback(ok_button, XmNactivateCallback, do_allocate, widgets);
	XtManageChild(dialog);
	XmProcessTraversal(volume_entry,XmTRAVERSE_CURRENT);
	XmUpdateDisplay(dialog);
	if ((((XmListCallbackStruct *)call_data)->reason) == -1)
	  XtFree(call_data);
}

void act_on_selection(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	char *selection;
	char identifier[32],stat[32],vol[32];
	int slot,unit,drive,drive_unit;
	int arg,den,phys;
	if ( XmStringGetLtoR(((XmListCallbackStruct *)call_data)->item,
			XmSTRING_DEFAULT_CHARSET,&selection) ) {
	  sscanf(selection,"%d %d %d %d %d %s %s",
		&slot,&unit,&arg,&den,&phys,stat,vol);
	  switch ((int)client_data) {
	    case LOAD:
	  	sprintf(chd_text,"Load vol %s",vol);
		break;
	    case UNLOAD:
		sprintf(chd_text,"Unload vol %s",vol);
		break;
	    case DEALLOCATE:
	  	sprintf(chd_text,"Deallocate vol %s",vol);
		break;
	    default:
		fprintf(stderr,"unrecognized info in act_on_selection\n");
	    }
	  chd_cmd(chd_text);
	  }

	if (chd_stat(FALSE,TRUE) < 400) {
	  updateSlotItem(widget,((XmListCallbackStruct *)call_data)->item);
	  }
	else
	  system("xalert -C XChd OK 'Changer request failed; check History' 'under Misc pulldown for more info'");
	if ((((XmListCallbackStruct *)call_data)->reason) == -1)
	  XtFree(call_data);
}
void act_on_list_item(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XmListCallbackStruct *fake_cb;
	XmString *load_list;
	XtPointer action;
	int count;

	XtVaGetValues((Widget)client_data,
		XmNselectedItemCount,	&count,
		XmNselectedItems, 	&load_list,
		NULL);

	XtVaGetValues(widget,
		XmNuserData,		&action,
		NULL);

	if (count != 1) {
/*
	  fprintf(stderr,"no item has been selected\n");
*/
	  system("xalert -C XChd ok 'No list item has been selected'");
	  }
	else {
	  fake_cb = ( XmListCallbackStruct *)
		malloc(sizeof(XmListCallbackStruct));
	  fake_cb->reason = -1;
	  fake_cb->item = *load_list;
	  switch ((int)action) {
		case LOAD:
	  		act_on_selection((Widget) client_data,
				(XtPointer)action,(XtPointer) fake_cb);
			break;
		case UNLOAD:
	  		act_on_selection((Widget) client_data,
				(XtPointer)action,(XtPointer) fake_cb);
			break;
		case ALLOCATE:
	  		allocate_selection((Widget) client_data,
				NULL,(XtPointer) fake_cb);
			break;
		case DEALLOCATE:
	  		act_on_selection((Widget) client_data,
				(XtPointer)action,(XtPointer) fake_cb);
			break;
		}
	  }
}

void pop_list_dialog(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	Widget list;
	XtPointer action;

#ifdef DEBUG
	fprintf(stderr,"pop_list_dialog called; get user data from %s widget\n",
		XtName(widget));
#endif
	XtVaGetValues(widget,XmNuserData,&action,NULL);

#ifdef DEBUG
	fprintf(stderr," action = %d\n",action);
	if (action == 0) exit(1);
/*
	action = (XtPointer)LOAD;
*/
#endif

	switch ((int)action) {
	  case ALLOCATE:
		tmplist[0].search_key	= ENTRY_STAT;
		tmplist[0].value	= (char *) "Empty";
		tmplist[1].search_key	= NULL;
		break;
	  case DEALLOCATE:
	  case LOAD:
#ifdef DEBUG
	fprintf(stderr,"LOAD selected; call build_list; ENTRY_STAT = %d\n",
		ENTRY_STAT);
#endif
		tmplist[0].search_key	= ENTRY_STAT;
		tmplist[0].value	= "Occupied";
		tmplist[1].search_key	= ENTRY_STAT;
		tmplist[1].value	= "Scratch";
		tmplist[2].search_key	= NULL;
		break;
	  case UNLOAD:
		tmplist[0].value	= "Loaded";
		tmplist[0].search_key	= ENTRY_STAT;
		tmplist[1].search_key	= NULL;
		break;
	  }

	XtVaGetValues((Widget)client_data,XmNuserData,&list,NULL);

	XmListDeleteAllItems(list);
	build_list(list,"Slot",tmplist);
	XtManageChild((Widget) client_data);

	if (*(busy_win+(int)action) == 0)
	  *(busy_win+(int)action) =
		XCreateWindow(dpy, XtWindow((Widget)client_data),
			0, 0, display_width, display_height,
			(unsigned int) 0, CopyFromParent, InputOnly,
			CopyFromParent, mask, &attr);
}

void main(argc,argv)
int argc;
char *argv[];
{
	int indx,pid,status;
	Window top_window;
	unsigned int screen_number;
	Widget toplevel, panel, qbutton;
	Widget cmd_button, text_cmd_dialog, text_cmd; 
	Widget menubar;
	Widget file_pulldown,file_but,deallocate_button,deallocate_dialog;
	Widget	load_button,unload_button,
		load_sel_button,unload_sel_button,
		allocate_sel_button,deallocate_sel_button;
	Widget deallocate_label,separator,form1,od_button,
		frame,control_buttons,ok_button,refresh_button,quit_button;
	Widget add_button,allocate_button,add_dialog,
		allocate_dialog,allocate_label;
	Widget load_dialog,unload_dialog,load_list,unload_list;
	Widget load_label,unload_label;
	Widget mail_button;
	Widget vol,slot,scratch;
	Widget volume_form,volume_label,volume_text,scratch_toggle;
	Widget system_pulldown,system_button,start_button,shutdown_button; 
	Widget signon_button,signoff_button; 
	Widget misc_but,misc_pulldown;
	Widget history_button,history_dialog;
	Widget history_label;
	Widget save_button,dismiss_button,form;
	Widget comment_label,comment_button,comment_dialog,comment_text;
	XmString label,button_label,accel_label,slot_heading_label;
	Arg args[25];
	int nargs;
	int chdc_pid;

/*
	setlinebuf(stdin);
	setlinebuf(stdout);
*/
	setvbuf(stdin, NULL, _IOLBF, BUFSIZ);
	setvbuf(stdout, NULL, _IOLBF, BUFSIZ);

/*
	xs_talkto("/explprod/phase2/chd/chdc");
	xs_talkto("/home/gssa/zjmw36/src/cmd/xchd4/chdc");
	xs_talkto("/net/149.180.140.93/data4/tstapps/global/IRIX64/6.5/chd/prod/IP25/chdc");
	xs_talkto("/net/149.180.140.93/data4/tstapps/global/bin/chdc");
*/
	chdc_pid = xs_talkto("chdc");

	toplevel = XtAppInitialize (&app_con, "XChd", options,
			XtNumber(options), &argc, argv,
			fallback_resources, NULL, 0);

	XtGetApplicationResources (toplevel, &data, resources, 
				   XtNumber(resources), NULL, 0);

	XtVaSetValues(toplevel, XmNallowShellResize, TRUE, NULL);

/*
	panel = XtVaCreateManagedWidget("panel",
		xmPanedWindowWidgetClass, toplevel,
			NULL);
*/
	panel = XtVaCreateManagedWidget("panel",
		xmFormWidgetClass, toplevel,
			NULL);

	menubar = XmCreateMenuBar(panel,"menuBar",NULL,0);
	XtVaSetValues(menubar,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			NULL);

	XtManageChild(menubar);
/*
	XuSet_Help(menubar,"MenuB_Dsc.help");

	XuCreateHelpPulldown(menubar);
	XuSet_Help_Shell(toplevel);
	help_path = getenv("DSKUTIL_HELPDIR");
	if (help_path == (char *)NULL) help_path = ".";
	XuSet_Help_Path(help_path);
	XuSet_Help_Index(help_items,(sizeof(help_items)/sizeof(char *))/2);
	XuSet_Help_Version(version);
*/
	file_pulldown = XmCreatePulldownMenu(menubar,"file_pd",NULL,0);
	file_but = XtVaCreateManagedWidget("File",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'F',
			XmNsubMenuId,		file_pulldown,
			NULL);

	system_pulldown = XmCreatePulldownMenu(file_pulldown,
		"system_pd",NULL,0);
	system_button = XtVaCreateManagedWidget("System",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'S',
			XmNsubMenuId,		system_pulldown,
			NULL);

	accel_label = XmStringCreate("Ctrl+U",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Signon",XmSTRING_DEFAULT_CHARSET);
	signon_button = XtVaCreateManagedWidget("signon",
		xmPushButtonWidgetClass, system_pulldown,
			XmNmnemonic,		'O',
			XmNaccelerator,		"Ctrl<Key>o",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(accel_label);
	XmStringFree(button_label);
	XtAddCallback(signon_button,XmNactivateCallback,
		simple_cmd,"System Signon *");
/*
	XtAddCallback(signon_button,XmNactivateCallback,
		pop_dialog, system_pulldown);
*/

	accel_label = XmStringCreate("Ctrl+F",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Signoff",XmSTRING_DEFAULT_CHARSET);
	signoff_button = XtVaCreateManagedWidget("signoff",
		xmPushButtonWidgetClass, system_pulldown,
			XmNmnemonic,		'F',
			XmNaccelerator,		"Ctrl<Key>f",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNsensitive,		FALSE,
			NULL);
	XmStringFree(accel_label);
	XmStringFree(button_label);
	XtAddCallback(signoff_button,XmNactivateCallback,
		simple_cmd,"System Signoff");
/*
	XtAddCallback(signoff_button,XmNactivateCallback,
		drop_dialog, system_pulldown);
*/

	accel_label = XmStringCreate("Ctrl+U",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Start",XmSTRING_DEFAULT_CHARSET);
	start_button = XtVaCreateManagedWidget("start",
		xmPushButtonWidgetClass, system_pulldown,
			XmNmnemonic,		'U',
			XmNaccelerator,		"Ctrl<Key>u",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNsensitive,		FALSE,
			NULL);
	XmStringFree(accel_label);
	XmStringFree(button_label);
	XtAddCallback(start_button,XmNactivateCallback,
		simple_cmd,"System Start");

	accel_label = XmStringCreate("Ctrl+D",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Shutdown",XmSTRING_DEFAULT_CHARSET);
	shutdown_button = XtVaCreateManagedWidget("shutdown",
		xmPushButtonWidgetClass, system_pulldown,
			XmNmnemonic,		'D',
			XmNaccelerator,		"Ctrl<Key>d",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNsensitive,		FALSE,
			NULL);
	XmStringFree(accel_label);
	XmStringFree(button_label);
	XtAddCallback(shutdown_button,XmNactivateCallback,
		simple_cmd,"System Shutdown");
/*
	XtAddCallback(shutdown_button,XmNactivateCallback,
		pop_dialog, system_pulldown);
*/

	XtAddCallback(signon_button,XmNactivateCallback,
		set_sensitive,signoff_button);
	XtAddCallback(signon_button,XmNactivateCallback,
		set_sensitive,start_button);
	XtAddCallback(signon_button,XmNactivateCallback,
		set_sensitive,shutdown_button);
	XtAddCallback(signon_button,XmNactivateCallback,
		set_insensitive,signon_button);

	XtAddCallback(signoff_button,XmNactivateCallback,
		set_sensitive,signon_button);
	XtAddCallback(signoff_button,XmNactivateCallback,
		set_insensitive,start_button);
	XtAddCallback(signoff_button,XmNactivateCallback,
		set_insensitive,shutdown_button);
	XtAddCallback(signoff_button,XmNactivateCallback,
		set_insensitive,signoff_button);

	accel_label = XmStringCreate("Ctrl+A",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Allocate",XmSTRING_DEFAULT_CHARSET);
	allocate_button = XtVaCreateManagedWidget("Allocate",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'A',
			XmNaccelerator,		"Ctrl<Key>a",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNuserData,		ALLOCATE,
			NULL);

	allocate_dialog = XmCreateFormDialog(allocate_button,"allocate",
		NULL, 0);

	XmStringFree(accel_label);
	XmStringFree(button_label);

	XtAddCallback(allocate_button, XmNactivateCallback,
		pop_list_dialog, allocate_dialog);

	label = XmStringCreateLtoR( "Allocate Slots",
		XmSTRING_DEFAULT_CHARSET);

        allocate_label = XtVaCreateManagedWidget("allocateLabel",
		xmLabelWidgetClass, allocate_dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNborderWidth,		2,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	slot_heading_label = XmStringCreateLtoR(
		" Slot    Unit    Arg    Den    Phys    Stat   Volume",
		XmSTRING_DEFAULT_CHARSET);

        allocate_label = XtVaCreateManagedWidget("selected_label",
		xmLabelWidgetClass, allocate_dialog,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		allocate_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		slot_heading_label,
			NULL);

	control_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, allocate_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	button_label = XmStringCreate("Allocate",XmSTRING_DEFAULT_CHARSET);
	allocate_sel_button = XtVaCreateManagedWidget("allocate",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNuserData,		ALLOCATE,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Dismiss",XmSTRING_DEFAULT_CHARSET);
	ok_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Refresh",XmSTRING_DEFAULT_CHARSET);
	refresh_button = XtVaCreateManagedWidget("refresh",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			XmNuserData,		ALLOCATE,
			NULL);
	XmStringFree(button_label);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, allocate_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	control_buttons,
			XmNbottomOffset,	5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);	nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	allocate_label); 	nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET); 	nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	separator);		nargs++;
	XtSetArg(args[nargs],XmNbottomOffset,		5);		nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);		nargs++;
	XtSetArg(args[nargs],XmNselectionPolicy, XmSINGLE_SELECT);	nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);		nargs++;
	allocate_list = XmCreateScrolledList(allocate_dialog,"allocate_list", args, nargs);

	XtVaSetValues(allocate_dialog,XmNuserData,allocate_list,NULL);
	XtManageChild(allocate_list);

	XtAddCallback(allocate_sel_button,XmNactivateCallback,
		act_on_list_item,allocate_list);

	XtAddCallback(allocate_list,XmNdefaultActionCallback,
		allocate_selection,NULL);

/*
	volume_form = XtVaCreateManagedWidget("volumeform",
		xmFormWidgetClass, allocate_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNtopOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	label = XmStringCreateLtoR( "Volume Name",
		XmSTRING_DEFAULT_CHARSET);
	volume_label = XtVaCreateManagedWidget("volumeLabel",
		xmLabelWidgetClass, volume_form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	volume_text = XtVaCreateManagedWidget("volumeText",
		xmTextWidgetClass, volume_form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_label,
			XmNsensitive,		FALSE,
			NULL);

	XtAddCallback(allocate_list,XmNsingleSelectionCallback,
		set_sensitive,volume_text);

	label = XmStringCreateLtoR( "Volume Name",
		XmSTRING_DEFAULT_CHARSET);
        scratch_toggle = XtVaCreateManagedWidget("scratch",
		xmToggleButtonWidgetClass, volume_form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		volume_text,
			XmNlabelString,		label,
			XmNsensitive,		FALSE,
			NULL);
	XmStringFree(label);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, allocate_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		volume_form,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);
*/
/*
	XtAddCallback(ok_button,XmNactivateCallback,
		allocate_selections,allocate_list);
*/
	XtAddCallback(ok_button,XmNactivateCallback,
		drop_dialog,allocate_dialog);

	XtAddCallback(refresh_button,XmNactivateCallback,
		pop_list_dialog, allocate_dialog);

	XtAddCallback(allocate_button, XmNactivateCallback,
		pop_list_dialog, allocate_dialog);

	accel_label = XmStringCreate("Ctrl+D",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Deallocate",XmSTRING_DEFAULT_CHARSET);
	deallocate_button = XtVaCreateManagedWidget("Deallocate",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'D',
			XmNaccelerator,		"Ctrl<Key>d",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNuserData,		DEALLOCATE,
			NULL);

	deallocate_dialog = XmCreateFormDialog(deallocate_button,"deallocate",
		NULL, 0);

	XmStringFree(accel_label);
	XmStringFree(button_label);

	XtAddCallback(deallocate_button, XmNactivateCallback,
		pop_list_dialog, deallocate_dialog);

	label = XmStringCreateLtoR(
		"Deallocate Slots",
		XmSTRING_DEFAULT_CHARSET);

        deallocate_label = XtVaCreateManagedWidget("DeallocateLabel",
		xmLabelWidgetClass, deallocate_dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNborderWidth,		2,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        deallocate_label = XtVaCreateManagedWidget("selected_label",
		xmLabelWidgetClass, deallocate_dialog,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		deallocate_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		slot_heading_label,
			NULL);

	control_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, deallocate_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	button_label = XmStringCreate("De-allocate",XmSTRING_DEFAULT_CHARSET);
	deallocate_sel_button = XtVaCreateManagedWidget("deallocate",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNuserData,		DEALLOCATE,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Dismiss",XmSTRING_DEFAULT_CHARSET);
	ok_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(ok_button,XmNactivateCallback,
		drop_dialog,deallocate_dialog);

	button_label = XmStringCreate("Refresh",XmSTRING_DEFAULT_CHARSET);
	refresh_button = XtVaCreateManagedWidget("refresh",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			XmNuserData,		DEALLOCATE,
			NULL);
	XmStringFree(button_label);
	XtAddCallback(refresh_button,XmNactivateCallback,
		pop_list_dialog, deallocate_dialog);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, deallocate_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	control_buttons,
			XmNbottomOffset,	5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);	nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	deallocate_label);	nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET);	nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	separator);		nargs++;
	XtSetArg(args[nargs],XmNbottomOffset,	5);			nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);		nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);		nargs++;
	XtSetArg(args[nargs],XmNselectionPolicy, XmMULTIPLE_SELECT);	nargs++;
	deallocate_list = XmCreateScrolledList(deallocate_dialog,"selected_list", args, nargs);

	XtVaSetValues(deallocate_dialog,XmNuserData,deallocate_list,NULL);
	XtManageChild(deallocate_list);

	XtAddCallback(deallocate_list,XmNdefaultActionCallback,
		act_on_selection,(XtPointer) DEALLOCATE);

	XtAddCallback(deallocate_sel_button,XmNactivateCallback,
		act_on_list_item,deallocate_list);

	accel_label = XmStringCreate("Ctrl+L",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Load",XmSTRING_DEFAULT_CHARSET);
	load_button = XtVaCreateManagedWidget("Load",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'L',
			XmNaccelerator,		"Ctrl<Key>l",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNuserData,		LOAD,
			NULL);

	load_dialog = XmCreateFormDialog(load_button,"load",
		NULL, 0);

	XmStringFree(accel_label);
	XmStringFree(button_label);

	XtAddCallback(load_button, XmNactivateCallback,
		pop_list_dialog, load_dialog);

	label = XmStringCreateLtoR(
		"Load Slots",
		XmSTRING_DEFAULT_CHARSET);

        load_label = XtVaCreateManagedWidget("LoadLabel",
		xmLabelWidgetClass, load_dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNborderWidth,		2,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        load_label = XtVaCreateManagedWidget("selected_label",
		xmLabelWidgetClass, load_dialog,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		load_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		slot_heading_label,
			NULL);

	control_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, load_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	button_label = XmStringCreate("Load",XmSTRING_DEFAULT_CHARSET);
	load_sel_button = XtVaCreateManagedWidget("load",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNuserData,		LOAD,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Dismiss",XmSTRING_DEFAULT_CHARSET);
	ok_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(ok_button,XmNactivateCallback,
		drop_dialog,load_dialog);

	button_label = XmStringCreate("Refresh",XmSTRING_DEFAULT_CHARSET);
	refresh_button = XtVaCreateManagedWidget("refresh",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			XmNuserData,		LOAD,
			NULL);
	XmStringFree(button_label);
	XtAddCallback(refresh_button,XmNactivateCallback,
		pop_list_dialog, load_dialog);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, load_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	control_buttons,
			XmNbottomOffset,	5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);	nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	load_label); 		nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET); 	nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	separator);		nargs++;
	XtSetArg(args[nargs],XmNbottomOffset,	5);			nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM);		nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM);		nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);		nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);		nargs++;
	XtSetArg(args[nargs],XmNselectionPolicy, XmSINGLE_SELECT);	nargs++;
	load_list = XmCreateScrolledList(load_dialog,"load_list", args, nargs);

	XtVaSetValues(load_dialog,XmNuserData,load_list,NULL);
	XtManageChild(load_list);

	XtAddCallback(load_list,XmNdefaultActionCallback,
		act_on_selection,(XtPointer) LOAD);

	XtAddCallback(load_sel_button,XmNactivateCallback,
		act_on_list_item,load_list);

	accel_label = XmStringCreate("Ctrl+U",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Unload",XmSTRING_DEFAULT_CHARSET);
	unload_button = XtVaCreateManagedWidget("Unload",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'U',
			XmNaccelerator,		"Ctrl<Key>u",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			XmNuserData,		UNLOAD,
			NULL);

	unload_dialog = XmCreateFormDialog(unload_button,"unload",
		NULL, 0);

	XtAddCallback(unload_button, XmNactivateCallback,
		pop_list_dialog, unload_dialog);

	XmStringFree(accel_label);
	XmStringFree(button_label);

	label = XmStringCreateLtoR(
		"Unload Loaded Slots",
		XmSTRING_DEFAULT_CHARSET);

        unload_label = XtVaCreateManagedWidget("UnloadLabel",
		xmLabelWidgetClass, unload_dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNborderWidth,		2,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        unload_label = XtVaCreateManagedWidget("selected_label",
		xmLabelWidgetClass, unload_dialog,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		unload_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		slot_heading_label,
			NULL);
	XmStringFree(slot_heading_label);

	control_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, unload_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	button_label = XmStringCreate("Unload",XmSTRING_DEFAULT_CHARSET);
	unload_sel_button = XtVaCreateManagedWidget("unload",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNuserData,		UNLOAD,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Dismiss",XmSTRING_DEFAULT_CHARSET);
	ok_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(ok_button,XmNactivateCallback,
		drop_dialog,unload_dialog);

	button_label = XmStringCreate("Refresh",XmSTRING_DEFAULT_CHARSET);
	refresh_button = XtVaCreateManagedWidget("refresh",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			XmNuserData,		UNLOAD,
			NULL);
	XmStringFree(button_label);
	XtAddCallback(refresh_button,XmNactivateCallback,
		pop_list_dialog, unload_dialog);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, unload_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	control_buttons,
			XmNbottomOffset,	5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);	nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	unload_label);		nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET); 	nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	separator);		nargs++;
	XtSetArg(args[nargs],XmNbottomOffset,	5);			nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM); 	nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);		nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);		nargs++;
	XtSetArg(args[nargs],XmNselectionPolicy, XmSINGLE_SELECT);	nargs++;
	unload_list = XmCreateScrolledList(unload_dialog,"selected_list", args, nargs);

	XtVaSetValues(unload_dialog,XmNuserData,unload_list,NULL);
	XtManageChild(unload_list);

	XtAddCallback(unload_list,XmNdefaultActionCallback,
		act_on_selection,(XtPointer) UNLOAD);

	XtAddCallback(unload_sel_button,XmNactivateCallback,
		act_on_list_item,unload_list);

	misc_pulldown = XmCreatePulldownMenu(menubar,"misc_pd",NULL,0);
	misc_but = XtVaCreateManagedWidget("Misc",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'M',
			XmNsubMenuId,		misc_pulldown,
			NULL);

	label = XmStringCreate("History",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+H",XmSTRING_DEFAULT_CHARSET);
	history_button = XtVaCreateManagedWidget("history",
		xmPushButtonWidgetClass, misc_pulldown,
			XmNmnemonic,		'h',
			XmNaccelerator,		"Ctrl<Key>h",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNallowShellResize, TRUE); nargs++;
	XtSetArg(args[nargs],XmNautoUnmanage, FALSE); nargs++;
	history_dialog = XmCreateFormDialog(history_button,"history_dialog",
		args,nargs);

	save_button = XtVaCreateManagedWidget("save",
		xmPushButtonWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	20,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	40,
			NULL);

	dismiss_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	60,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
			NULL);

	form = XtVaCreateManagedWidget("form",
		xmFormWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,     XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget, 	dismiss_button,
			NULL);

	label = XmStringCreateLtoR(
		"Full Changer Mechanism Dialog",
		XmSTRING_DEFAULT_CHARSET);
	history_label = XtVaCreateManagedWidget("hist_label",
		xmLabelWidgetClass, form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget, history_label); nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNautoShowCursorPosition,	TRUE); nargs++;
	XtSetArg(args[nargs],XmNrows, 		24);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	90);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	FALSE); nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	history_text = XmCreateScrolledText(form,"history_text",
		args,nargs);

	XtManageChild(history_text);
	XtManageChild(form);
	XtVaSetValues (history_text, XmNautoShowCursorPosition, TRUE, NULL);

	XtAddCallback(history_button,XmNactivateCallback,
		pop_dialog,history_dialog);
	XtAddCallback(dismiss_button,XmNactivateCallback,
		drop_dialog,history_dialog);
	XtAddCallback(save_button,XmNactivateCallback,
		do_save_history,NULL);

	label = XmStringCreate("Comments",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+C",XmSTRING_DEFAULT_CHARSET);
	comment_button = XtVaCreateManagedWidget("comments",
		xmPushButtonWidgetClass, misc_pulldown,
			XmNmnemonic,		'c',
			XmNaccelerator,		"Ctrl<Key>c",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	nargs = 0;
	XtSetArg(args[nargs],XmNallowShellResize, TRUE); nargs++;
	comment_dialog = XmCreateFormDialog(comment_button,"comment_dialog",
		args,nargs);

	sprintf(msg_text,"Comments will be mailed to %s",data.author);
	label = XmStringCreate(msg_text,XmSTRING_DEFAULT_CHARSET);
	comment_label = XtVaCreateManagedWidget("comment_label",
		xmLabelWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		5,
			XmNbottomAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	mail_button = XtVaCreateManagedWidget("mail",
		xmPushButtonWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	20,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	40,
			NULL);

	dismiss_button = XtVaCreateManagedWidget("cancel",
		xmPushButtonWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	60,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);  nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	comment_label);    nargs++;
	XtSetArg(args[nargs],XmNtopOffset,		5);	   nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	mail_button);    nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrows, 		24);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	80);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	TRUE); nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	comment_text = XmCreateScrolledText(comment_dialog,"comment_text",
		args,nargs);

	XtManageChild(comment_text);

	XtAddCallback(comment_button,XmNactivateCallback,
		pop_dialog,comment_dialog);
	XtAddCallback(comment_button,XmNactivateCallback,
		set_dialog_focus,comment_text);

	XtAddCallback(dismiss_button,XmNactivateCallback,
		comments,comment_text);

	XtAddCallback(dismiss_button,XmNactivateCallback,
		drop_dialog,comment_dialog);

/*
	accel_label = XmStringCreate("Ctrl+S",XmSTRING_DEFAULT_CHARSET);
	button_label = XmStringCreate("Add",XmSTRING_DEFAULT_CHARSET);
	add_button = XtVaCreateManagedWidget("Add",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'S',
			XmNaccelerator,		"Ctrl<Key>s",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);

	XmStringFree(accel_label);
	XmStringFree(button_label);

	add_dialog = XmCreateFormDialog(add_button,"add",
		NULL, 0);

	label = XmStringCreateLtoR(
		"Add Slots",
		XmSTRING_DEFAULT_CHARSET);

        allocate_label = XtVaCreateManagedWidget("AddLabel",
		xmLabelWidgetClass, add_dialog,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNborderWidth,		2,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        slot = XtVaCreateManagedWidget("slot",
		xmTextWidgetClass, add_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		allocate_label,
			XmNcolumns,		5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        vol = XtVaCreateManagedWidget("vol",
		xmTextWidgetClass, add_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		slot,
			XmNcolumns,		32,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        scratch = XtVaCreateManagedWidget("vol",
		xmToggleButtonWidgetClass, add_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		vol,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, add_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		scratch,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	control_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, add_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNtopOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	button_label = XmStringCreate("OK",XmSTRING_DEFAULT_CHARSET);
	ok_button = XtVaCreateManagedWidget("ok",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(ok_button,XmNactivateCallback,
		drop_dialog,add_dialog);

	button_label = XmStringCreate("Refresh",XmSTRING_DEFAULT_CHARSET);
	refresh_button = XtVaCreateManagedWidget("refresh",
		xmPushButtonWidgetClass, control_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(add_button, XmNactivateCallback,
		pop_dialog, add_dialog);
*/

	create_button("Help", file_pulldown);

	text_cmd = XtVaCreateManagedWidget("command",
		xmTextWidgetClass, panel,
			XmNleftAttachment,		XmATTACH_FORM,
			XmNtopAttachment,		XmATTACH_WIDGET,
			XmNtopWidget,			menubar,
			XmNcolumns,	20,
			XmNrows,	1,
			XmNeditable,	TRUE,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget, text_cmd); nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNautoShowCursorPosition,	TRUE); nargs++;
	XtSetArg(args[nargs],XmNrows, 		24);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	90);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	FALSE); nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	chd_stat_text = XmCreateScrolledText(panel,"junk",
		args,nargs);

	XtManageChild(chd_stat_text);

	XtAddCallback(text_cmd, XmNactivateCallback, send_to_chd, "");

	qbutton = xs_create_quit_button(file_pulldown);
	XtAddCallback(qbutton, XmNactivateCallback, quit_chd, NULL);

	XtRealizeWidget(toplevel);

/*	if ((pid = wait3(&status,WNOHANG,NULL)) != 0) { */
	if ((pid = waitpid(chdc_pid,&status,WNOHANG)) != 0) {
	  fprintf(stderr,"child process id %d exited with status %d\n",
		pid,status);
	  system("xalert -C XChd OK 'media changer has apparently failed'");
	  exit(1);
	  }

	if (chd_stat(TRUE,TRUE) != 210) {
	  system("xalert -C XChd OK 'Error in media changer; aborting' ");
	  exit(1);
	  }

/* Define a busy window to be managed when processing is taking place */

	dpy = XtDisplay(toplevel);

	top_window = XtWindow(toplevel);
	screen_number = DefaultScreen(dpy);

/*
	XtManageChild(allocate_dialog);
	XtManageChild(deallocate_dialog);
	XtManageChild(load_dialog);
	XtManageChild(unload_dialog);
	XtUnmanageChild(allocate_dialog);
	XtUnmanageChild(deallocate_dialog);
	XtUnmanageChild(load_dialog);
	XtUnmanageChild(unload_dialog);

	fprintf(stderr,"window for %s = %08x\n",XtName(allocate_dialog),XtWindow(allocate_dialog));
	fprintf(stderr,"window for %s = %08x\n",XtName(deallocate_dialog),XtWindow(deallocate_dialog));
	fprintf(stderr,"window for %s = %08x\n",XtName(load_dialog),XtWindow(load_dialog));
	fprintf(stderr,"window for %s = %08x\n",XtName(unload_dialog),XtWindow(unload_dialog));

	if (top_window == 0) {
	  fprintf(stderr,"top_window = 0; terminating\n");
	  exit(1);
	  }
*/
     /* Ignore device events while the busy cursor is displayed. */

	mask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
		ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(dpy, XC_watch);

	display_width  = DisplayWidth(dpy,screen_number);
	display_height = DisplayHeight(dpy,screen_number);

	busy_win = (Window *) XtMalloc(NUMBER_OF_BUSY_WINS * sizeof(Window));

	for (indx=1; indx<NUMBER_OF_BUSY_WINS; indx++) 
	  *(busy_win+indx) = NULL;

	*(busy_win+MAIN) = XCreateWindow(dpy, top_window, 0, 0,
		display_width, display_height,
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
/*
	busy_win[1] = XCreateWindow(dpy, XtWindow(allocate_dialog), 0, 0,
		display_width, display_height,
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
	busy_win[2] = XCreateWindow(dpy, XtWindow(deallocate_dialog), 0, 0,
		display_width, display_height,
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
	busy_win[3] = XCreateWindow(dpy, XtWindow(load_dialog), 0, 0,
		display_width, display_height,
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
	busy_win[4] = XCreateWindow(dpy, XtWindow(unload_dialog), 0, 0,
		display_width, display_height,
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
*/

	XtAppMainLoop(app_con);
}
