########################################################################
#                 copyright 2001, Amoco Production Company             #
#                             All Rights Reserved                      #
#                     an affiliate of BP America Inc.                  #
########################################################################

#	gmake stuff for assembly language
#
#	Changes:
#
#	02/22/91 - kfm	Changed TArchDir to Vendor to support crayxmp.
#			Changed negative conditionals to positive
#			conditionals.
#
#	09/31/89 - tlf	Wrote original.
#
#	Note: there is not a LinkA. You are expected to use LinkC or LinkF
#
#	the assembly compiler
AS	:=	as
#
#	ASrcs	a list of .s and .S assembly source files
#		.S files are intended to go thru cpp
#
AObjs	=	${patsubst %.s, ${TArchDir}/%.o,	\
		${patsubst %.S, ${TArchDir}/%.o, ${ASrcs}}}
#
# rule for %.s -> ${TArchDir}/%.o
#
CompileAs	=	${strip ${AS}			\
				${AFlags}		\
				${${Vendor}AFlags}	\
				${${TArchDir}AFlags}	\
			}
#
# rule for %.S -> ${TArchDir}/%.o
#
sunCompileAS	=	${strip ${CC}			\
				${TargetFlags}		\
				${IncludeDirs}		\
				${AFlags}		\
				${${Vendor}AFlags}	\
				${${TArchDir}Aflags}	\
				${CFlags}		\
				${CCFlags}		\
				${${Vendor}CCFlags}	\
				${${TArchDir}CCFlags}	\
				-c			\
			}
#
crayCompileAS	=	${strip ${CC}			\
				${IncludeDirs}		\
				${CFlags}		\
				${CCFlags}		\
				${${Vendor}CCFlags}	\
				${${TArchDir}CCFlags}	\
				-c -P			\
			}
#
# how to compile .s files
#
${TArchDir}/%.o:: %.s
	${CompileAs} -o $@ $< 
#
# how to compile .S files
#
${TArchDir}/%.o:: %.S
ifeq "${Vendor}" "cray"
	cp $< ${basename ${@F}}.s
	${crayCompileAS} ${basename ${@F}}.s
	mv -f ${basename ${@F}}.i ${basename ${@F}}.s
	${CompileAs} -o $@ ${basename ${@F}}.s
	rm ${basename ${@F}}.s
else
	${sunCompileAS} -o $@ $<
endif
#
# sets of All source, All object
#
AllSrcs	=	${CSrcs} ${F77Srcs} ${F8xSrcs} ${ASrcs}
AllObjs	=	${CObjs} ${FObjs} ${AObjs}
