########################################################################
#                 copyright 2001, Amoco Production Company             #
#                             All Rights Reserved                      #
#                     an affiliate of BP America Inc.                  #
########################################################################

C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#
#	top-level of gmake initialization:
#
#	this file should only exist in ${DEPTROOT}/etc.
#
#	CHANGES:
#
#	10/1/91  mls -  Added LocalMan ot list of directory pointers.
#
#	02/20/91 tlf -	Removed /dev/tty reference from error echos
#			since they break on the crays and added the
#			message obseleting .cf and .cf8x suffixes.
#			Changed negative "ifneq cray" conditionals to
#			positive "ifeq cray" conditionals.
#
#	02/20/91 kfm -	Kathy Mathieu -- Added crayxea ability.
#			This includes changing references of
#				ifneq "${TArchDir}" "cray2"
#			to
#				ifneq "${Vendor}" "cray"
#			
#	10/19/90 jmw -	Added /usr/llib to list of directories for
#			default library search path on Cray.
#
#	06/28/90 tlf -	Added ${${Vendor}CFlags} ${${TArchDir}CFlags}
#			to both the CompileC & LinkC macros.
#
#	02/22/90 tlf -	Added "-c" to CompileF and removed it from the
#			various fortran compile rules.
#
#	11/27/89 tlf -	Added rules for .F, .F8x, and .F8X for the new
#			version of afp that sends these thru cpp
#			first.
#
#	11/22/89 tlf -	Added MakeTArchDir macro to create
#			subdirectories if they don't already exist so
#			code won't break when you move a program to a
#			new machine.
#
#	11/07/89 tlf -	Added forgotten -c option to non-cray .f8x,
#			.cf, and .f suffix rules.
#
#	10/09/89 tlf -	Changed rules to reflect changes on cray.  Got
#			rid of muff and mufc in favor of new suffix
#			rules.
#
#	09/28/89 prg -	Removed flags added on 26th.
#
#	09/26/89 prg -	Added flags to FORTRAN suffix rules on cray to
#			improve performance.
#
#	08/31/89 tlf -	Added .S as a suffix (see gmake.as) and fixed
#			a typo.
#
#	07/21/89 tlf -	Added Vendor Flags so wouldn't have to have
#			versions of CCFlags, etc, for sun3's,
#			sun3fpa's, and sun4's.  Changed LdFlags to
#			CLFlags (as it should have been) and changed
#			MuffFlags to FCFlags and FLFlags where
#			appropriate.  Removed the two (identical)
#			versions of CompileF77 and CompileF8x to
#			create one CompileF.
#
#	06/09/89 tlf -	Changed so that HostArch and TargetArch are
#			defined here and not in source code to gmake.
#
#	04/24/89 tlf -	Fixed typos.
#
#	04/14/89 mls -	Extensive alterations to standard variables.
#
#	04/05/89 mls -	Added stuff to compile commands to invoke the
#			macro ${RemakeRemotes}
#
#	03/17/89 mls -	Created gmake.init.
#
#	05/11/92 jmw -	Eliminated special handling of library directories
#			on the crays. With UNICOS 6.1, the "-L" format
#			should be the same among systems.
#
#	06/16/92 jmw -	Added rules for the Cray El being installed in 
#			Calgary. 
#
#	08/19/92 jmw -	Added rules for the HP and IBM RS600 systems.
#			These rules have been floating bootleg till now.
#
#       04/29/93 jmw -  Added rules for the Cray c90 system.
#                       Also changed typo for setting "-eu" on Fortran
#                       compiler for crayxea, crayyel, and crayc90
#                       architectures.
#
#       07/01/93 jmw -  Changed CompileF per Kathy Mathieu's mods.
#
#------------------------------------------------------------------------------
#
#	Things You Should Know in Order to Understand This File:
#
#	1.	Don't put leading tabs in front of make directives
#		other than actions.  The gmake document (Terri tells me)
#		says that leading spaces are OK.
#
#		My advice is:	Don't put ANY leading whitespace in front
#		of ANYthing except comments and actions, and for actions
#		use ONLY TABS.
#
#		If you use spaces to indent your code, then sure as hell
#		someone'll replace some of them with tabs someday.  The
#		invisible failure of gmake to interpret some of your
#		directives will lead to truly agonizing bugs.
#
#	2.	The double colon '::' used in a number of the default
#		rules is supposed to keep gmake from searching for
#		possible intermediate makeable files.  If it gives trouble
#		I'll drop it.
#
#------------------------------------------------------------------------------
#
#	This initialization file will break if DEPTROOT is not
#	set in the user's environment (or in the makefile prior
#	to including this file) even if the make itself does not
#	deal with stuff in the department tree.
#
#	If DEPTROOT has not been set, force an abort.
#
ifndef	DEPTROOT
ErrorMsg	:=	"gmake: FATAL ERROR: DEPTROOT not defined."
DEPTROOT	:=	${shell echo ${ErrorMsg}}

.PHONY:	DropThisMake
DropThisMake:

endif
#
#	macro to force remaking of remote programs.  should be invoked
#	automatically by all compiles.
#
define	RemakeRemotes
	@rm -f RemoteMakes
endef
#
#	The new (as of 3/89) version of afp, the Amoco fortran
#	preprocessor, supports setting afp argument flags through
#	an environment variable, AFPVAR.  Using this (so says mls)
#	is a bad practice; it means your afp is different from
#	someone else's.  The next bit of gmake code is intended to
#	turn AFPVAR off (in case someone is using it).
#
ifdef AFPVAR
AFPVAR	:= ${shell echo "Don't use AFPVAR in your environment."}
AFPVAR	:=
endif
#
#	shorten the suffix list.  the default list is very long.
#	nota bene: adding a suffix does not automatically add a rule.
#
.SUFFIXES:
.SUFFIXES:  .cf8x .f8x .cf .f .l .y .c .s .S .o .h .a
#
#	HostArch is the host (current) architecture.
#		It has the form '-sun3' etc.  This is
#		ass backwards (it should be 'sun3' etc) but it's
#		compatible with current sun 'make' practice.  Currently
#		legal values are:
#			-sun3
#			-sun4
#			-cray2
#			-crayxea
#			-crayyel
#			-HP-UX
#			-hp800
#			-RS6000
#
#		nota bene: -sun3fpa is a legal architecture but it is not
#		sensed by gmake at startup so HostArch will never
#		be given this value.
HostArch := -${shell arch}

#
#	TargetArch is the target architecture.  It is initialized
#		to the value of HostArch.  If this make
#		is to use a non-default TargetArch, then the value
#		of TargetArch must be set BEFORE entering this
#		include file.  TargetArch may be set to any of the
#		above or to
#			-sun3fpa.
ifndef TargetArch
TargetArch := ${HostArch}
endif

#
#	TArchDir is TargetArch with the leading '-' stripped off.  Currently
#		legal values are:
#			sun3
#			sun3fpa
#			sun4
#			cray2
#			crayxea
#			crayyel
#
#	TargetFlags is the architecture type passed to the compiler.
#		The values of TArchDir map to TargetFlags as:
#			sun3	->	-sun3 -f68881
#			sun3fpa	->	-sun3 -ffpa
#			sun4	->	-sun4
#			cray2	->	{empty}
#			crayxea	->	{empty}
#			crayyel	->	{empty}
#
#
#	Compilers: Compiler wrappers (like muff and mufc) have been
#		mostly replaced by afp and new suffix rules.
#
#	The first code below deals with a special case.  On a cray2,
#		TargetArch must be -cray2.  If we override any other
#		value for TargetArch here then we may be able to
#		intercept an occasional user glitch.  (We could make
#		this a fatal error instead?)
#
ifeq  "${strip ${HostArch}}"   "-cray2"
ifneq "${strip ${TargetArch}}" "-cray2"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> cray2"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-cray2
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayxea"
ifneq "${strip ${TargetArch}}" "-crayxea"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayxea"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayxea
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayymp"
ifneq "${strip ${TargetArch}}" "-crayymp"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayymp"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayymp
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayyel"
ifneq "${strip ${TargetArch}}" "-crayyel"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayyel"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayyel
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayc90"
ifneq "${strip ${TargetArch}}" "-crayc90"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayc90"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayc90
endif
endif
#
#	Get TArchDir and set the remaining variables:
#
TArchDir	:=	${strip ${patsubst -%,%,${TargetArch}}	}
ifeq "${TArchDir}" "sun3"
Vendor		:=	sun
CC		:=	cc
FC		:=	afp
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
TargetFlags	:=	-sun3 -f68881
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun3fpa"
Vendor		:=	sun
CC		:=	cc
FC		:=	afp
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
TargetFlags	:=	-sun3 -ffpa
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4"
Vendor		:=	sun
CC		:=	cc
FC		:=	afp
FC90		:=	f90
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
F90LD		:=	${FC90}
# I'm taking off the static option - programmer should choose - jmw - 7/12/91
TargetFlags	:=	-sun4 -Bstatic
# TargetFlags	:=	-sun4
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "cray2"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayxea"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayxeaFCFlags	:=	-eu
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayymp"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayympFCFlags	:=	-eu
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayyel"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayyelFCFlags	:=	-eu
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayc90"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayc90FCFlags	:=	-eu
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "rs6000"
Vendor		:=	ibm
CC		:=	cc
FC		:=	afp -D_IBMR2
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "HP-UX"
Vendor		:=	hp
CC		:=	cc
FC		:=	afp -D_HPUX
AR		:=	ar
CLD		:=	${CC}
FLD		:=	fort77
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "HP800"
Vendor		:=	hp
CC		:=	cc
FC		:=	afp -D_HPUX
AR		:=	ar
CLD		:=	${CC}
FLD		:=	fort77
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifndef XFoundArch
ErrorMsg	:=	"gmake: FATAL ERROR: TargetArch not defined."
ErrorMsg	:=	${shell echo ${ErrorMsg}}	

.PHONY:	DropThisMake
DropThisMake:

endif
#
#	current local values:
#		LocalRoot is the root of the subtree holding this init file.
#		LocalBinCommon is the bin below LocalRoot.
#		LocalBin is the architecture-dependent part of
#			LocalBinCommon.
#		LocalLibCommon and LocalLib perform similarly as the above
#			for libraries.
#		LocalInclude performs similarly for includes.
#
LocalRoot	:=	${DEPTROOT}
LocalBinCommon	:=	${LocalRoot}/bin
LocalBin	:=	${LocalBinCommon}/${TArchDir}
LocalLibCommon	:=	${LocalRoot}/lib
LocalLib	:=	${LocalLibCommon}/${TArchDir}
LocalInclude	:=	${LocalRoot}/include
LocalMan	:=	${LocalRoot}/man
#
#	include and lib search paths.  is it a mistake to build in -I and -L?
#
#	it seems to be necessary to zero the variables initially.  is
#	this a gmake bug?  It may be induced by the recursive definitions.
#
IncludeDirs	:=	-I.
LibCommonDirs	:=
LibDirs		:=
IncludeDirs	:=	${strip -I${LocalInclude} ${IncludeDirs} }
LibCommonDirs	:=	${strip -L${LocalLibCommon} ${LibCommonDirs} }
LibDirs		:=	${strip -L${LocalLib} ${LibDirs} }
#
#	Some handy canned stuff:
#
#	MoveObjectToTArchDir moves something.o -> ${TArchDir}/something.o
#		when invoked in a pattern rule.  We use this to move
#		the result of a compilation (?.o) in the main directory
#		into the TArchDir subdirectory for those compilers which
#		don't usefully support "-c -o outfilepath", i.e.,
#		the Cray's.  We AVOID using this method where possible
#		so that simultaneous gmake's for multiple architectures
#		can proceed in the same directory.
#
define	MoveObjectToTArchDir
	mv ${patsubst ${TArchDir}/%.o, %.o, $@} $@
endef
#
#	MakeTArchDir creates the appropriate architecture subdirectory.
#		It is called for every source file before a compile
#		attempts to create a .o file in that subdirectory.
#		The overhead of having it called many times seems
#		worth not having compiles break because of missing
#		subdirectories.
#
define  MakeTArchDir
	@if test ! -w ${TArchDir};\
	then mkdir ${TArchDir};\
	fi
endef

#	routine for the cray's linker segldr
comma		:= ,

# We can get rid of this with Unicos6.1  - 	j.m.wade 5/11/92
#
# ifeq "${Vendor}" "cray"
# space := ${empty} ${empty}
# NewLibNames = -L ${subst ${space},${empty},\
#	${strip ${patsubst -L%,%${comma},${LibDirs}}/lib,/usr/lib,/usr/llib}}
#else
# NewLibNames	=	${LibDirs}
#endif
#
#	C stuff
#
#	these derive from things the user's  makefile sets:
#
#	CSrcs		a list of C files.
#
CObjs		=	${patsubst %.c, ${TArchDir}/%.o, ${CSrcs}}
#
#	How to make C objects:
#
#	The cray (as usual) is different: it doesn't support
#		"-c -o outfile" during compilation.
#
#	This will accept additional flags defined by TArchDir
#		cray2CCFlags	=	stuff...
#		crayxeaCCFlags	=	stuff...
#		crayyelCCFlags	=	stuff...
#		crayc90CCFlags	=	stuff...
#		sun3CCFlags	=	stuff...
#		sun4CCFlags	=	stuff...
#	etc., and by Vendor
#		sunCCFlags	= 	stuff...
#		crayCCFlags	=	stuff...
#	etc.  The 'CC' stands for "C Compiler".  The ${strip...},
#	which you will see from time to time, makes the command
#	lines actually issued easier for people to read by removing
#	extra white-space.
#
#	Similar rules apply for the following variables.
#
#		CFlags		goes to compiler AND linker
#		CCFlags		goes to compiler only
#		CLFlags		goes to linker only
#
CompileC   =		${strip ${CC}			\
 				${TargetFlags}		\
 				${IncludeDirs}		\
 				${CFlags}		\
 				${${Vendor}CFlags}	\
 				${${TArchDir}CFlags}	\
 				${CCFlags}		\
 				${${Vendor}CCFlags}	\
 				${${TArchDir}CCFlags}	\
 				-c			}
${TArchDir}/%.o::	%.c
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileC} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileC} $<
	${MoveObjectToTArchDir}
else
	${CompileC} -o $@ $<
endif
endif
	${RemakeRemotes}
#
#	how to link C objects
#
#	This will accept additional flags of the TArchDir form
#		cray2CLFlags	=	...
#		sun3fpaCLFlags	=	...
#	etc., and in Vendor form
#		sunCLFlags	=	...
#		crayCLFlags	=	...
#	The 'CL' stands for "C linker".
#
LinkC	    =		${strip ${CLD}			\
				${TargetFlags}		\
				${LibDirs}		\
				${CFlags}		\
				${${Vendor}CFlags}	\
				${${TArchDir}CFlags}	\
				${CLFlags}		\
				${${Vendor}CLFlags}	\
				${${TArchDir}CLFlags}	}
#
#	fortran stuff
#
#	Use of .cf and .cf8x is now obsolete.  Their use is discouraged.
#
#	Things the user's makefile sets:
#
#	F8xSrcs 	a list of .cf8x .F8x .f8x files with main programs
#	F77Srcs 	a list of .cf .F .f files with main programs
#
#
F90Objs 	=	${patsubst %.F90, ${TArchDir}/%.o,	\
			${patsubst %.f90, ${TArchDir}/%.o, ${F90Srcs}}}
#
F8xObjs 	=	${patsubst %.cf8x, ${TArchDir}/%.o,	\
			${patsubst %.F8x, ${TArchDir}/%.o,	\
			${patsubst %.F8X, %{TArchDir}/%.o,	\
			${patsubst %.f8x, ${TArchDir}/%.o, ${F8xSrcs}}}}}
#
F77Objs 	=	${patsubst %.cf, ${TArchDir}/%.o,	\
			${patsubst %.F, ${TArchDir}/%.o,	\
			${patsubst %.f, ${TArchDir}/%.o, ${F77Srcs}}}}
#
FObjs		=	${F77Objs} ${F8xObjs} ${F90Objs}
#
#	some fortran macros
#
#	Obsolete cf error message.
#
define SendCFMsg
@echo
@echo "gmake: WARNING: \"$<\" name obsolete."
@echo "       Use of .cf and .cf8x suffixes is obsolete and support\
		 will soon go away!"
@echo "       Please change suffixes from .cf to .F and from .cf8x to .F8x."
@echo "       Contact Joe Wade if you have questions."
@echo
endef

# name of source files without c in suffix

NewFName = ${patsubst %.cf, %.f,	\
            ${patsubst %.cf8x,%.f8x,$<}}

# a weird temporary name for cpp output

WeirdCppName = M00Cpp00aZ

# copy .cf or .cf8x source to a .c file so that cc will run cpp on it

CopyCFtoTmpC = ${strip cp $< ${WeirdCppName}.c}

# rename cpp's .i output to its appropriate .f* name and delete weird C file

MoveCppOutput = ${strip mv ${WeirdCppName}.i ${NewFName};\
			rm -f ${WeirdCppName}.c}

# remove intermediate fortran output after cpp has run

RemoveNewFName = ${strip rm -f			\
			${patsubst %.cf, %.f,	\
			${patsubst %.cf8x,%.f8x,$<}}}

# how to create .i output from a .c file

CompileCpp = ${strip	${CC}			\
			${IncludeDirs}		\
			${CppFlags}		\
			${${Vendor}CppFlags}	\
			${${TArchDir}CppFlags}	\
			-C -P			\
						}
#	how to make fortran objects:
#
#	This will accept additional TArchDir constructed flags like
#		cray2FCFlags	=	...
#		sun3FCFlags	=	...
#	etc., and Vendor constructed flags like
#		sunFCFlags	=	...
#		crayFCFlags	=	...
#	'FC' stands for "fortran compiler".
#
#	Also:
#		FFlags		goes to compiler AND linker
#		FCFlags		goes to compiler only
#		FLFlags		goes to linker only
#
ifeq "${TArchDir}" "crayc90"
MinusCFlag := -c
else
ifeq "${Vendor}" "cray"
MinusCFlag := 
else
MinusCFlag := -c
endif
endif

ifeq "${TArchDir}" "crayc90"
CompileF	=	${strip ${FC}			\
				${TargetFlags}		\
				${IncludeDirs}		\
				-compwith eval cf77 -Zv \
				-Wf\"${FFlags}		\
				${${Vendor}FFlags}	\
				${${TArchDir}FFlags}	\
				${FCFlags}		\
				${${Vendor}FCFlags}	\
				${${TArchDir}FCFlags}\"	\
				${MinusCFlag}		}
else
CompileF	=	${strip ${FC}			\
				${TargetFlags}		\
				${IncludeDirs}		\
				${FFlags}		\
				${${Vendor}FFlags}	\
				${${TArchDir}FFlags}	\
				${FCFlags}		\
				${${Vendor}FCFlags}	\
				${${TArchDir}FCFlags}	\
				${MinusCFlag}		}
endif

CompileF90	=	${strip ${FC90}			\
				${TargetFlags}		\
				${IncludeDirs}		\
				${FC90Flags}		\
				${${Vendor}FC90Flags}	\
				${${TArchDir}FC90Flags}	\
				${FC90CFlags}		\
				${${Vendor}FC90Flags}	\
				${${TArchDir}FC90Flags}	\
				${MinusCFlag}		}
#
#	nota bene:
#		it would be possible to simply use the same compile/mv rule
#		on the sun and the cray BUT we could not then do simultaneous
#		sun3/sun4 gmakes in the same directory.  (If this doesn't
#		make sense then you haven't been paying attention.  Try
#		again.)
#
${TArchDir}/%.o:: %.cf8x
	${MakeTArchDir}
	${SendCFMsg}
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c
	${MoveCppOutput}
ifeq "${Vendor}" "cray"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ ${NewFName}
endif
endif
	${RemoveNewFName}
	${RemakeRemotes}
${TArchDir}/%.o:: %.f8x
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ $<
endif
endif
	${RemakeRemotes}
${TArchDir}/%.o:: %.F8x
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ $<
endif
endif
	${RemakeRemotes}
#
# This looked like a verbatim repeat of the previous block, so
# I commented it out. See if it breaks!!  - j.m.wade 8/19/92
#
# ${TArchDir}/%.o:: %.F8X
# 	${MakeTArchDir}
# ifeq "${Vendor}" "cray"
# 	${CompileF} $<
# 	${MoveObjectToTArchDir}
# else
# 	${CompileF} -o $@ $<
# endif
# 	${RemakeRemotes}
${TArchDir}/%.o:: %.cf
	${MakeTArchDir}
	${SendCFMsg}
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c
	${MoveCppOutput}
ifeq "${Vendor}" "cray"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ ${NewFName}
endif
endif
	${RemoveNewFName}
	${RemakeRemotes}
${TArchDir}/%.o:: %.F
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ $<
endif
endif
	${RemakeRemotes}
${TArchDir}/%.o:: %.f
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ $<
endif
endif
	${RemakeRemotes}
#
#	How to link fortran objects:
#
#	This supports the additional TArchDir constructed flags like
#		sun4FLFlags	=	...
#		sun3fpaFLFlags	=	...
#	etc., and the Vendor constructed flags like
#		sunFLFlags	=	...
#		crayFLFlags	=	...
#	'FL' stands for "fortran linker".
#
LinkF	    =		${strip ${FLD}			\
				${TargetFlags}		\
				${LibDirs}		\
				${FFlags}		\
				${${Vendor}FFlags}	\
				${${TArchDir}FFlags}	\
				${FLFlags}		\
				${${Vendor}FLFlags}	\
				${${TArchDir}FLFlags}	}
#
#	sets of ALL source, ALL object, etc
#
AllSrcs		=	${CSrcs} ${F77Srcs} ${F8xSrcs}
AllObjs		=	${CObjs} ${FObjs} 
#
#	ccincl: include file dependency generator
#
#	This scheme has a few problems, but it does make it practical
#	to generate complete include-dependency rules for programs
#	which use the C preprocessor.  This includes all C programs
#	and those in several fortran dialects.
#
#	If you wish to pursue this further, you will have to read
#	the man page on ccincl.
#
CCIncl		=	ccincl ${IncludeDirs} -r -o\$${TArchDir}
#
#	Another include file dependency generator that works better
#	than ccincl is to use the c preprocessor itself to generate
#	the dependency list. Doesn't work on the cray though.
# 	Should be used in a rule such as:
#		included.files : ${AllSrcs}
#			${FindIncludes}
#

ifeq "${Vendor}" "cray"
FindIncludes	=	${strip ${CCIncl} $^ > $@}
else
ifeq "${Vendor}" "hp"
FindIncludes	=	${strip ${CCIncl} $^ > $@}
else
FindIncludes	=	${strip	${CC}			\
				-P -M -C		\
				${IncludeDirs}		\
				${CFlags}		\
				${${Vendor}CFlags}	\
				${${TArchDir}CFlags}	\
				${CCFlags} 		\
				${${Vendor}CCFlags}	\
				${${TArchDir}CCFlags}	\
				$^			\
				| sort | uniq		\
				| sed -e 's/^\(.*\.o\)/$${TArchDir}\/\1/' \
				> $@			\
			}
endif
endif
#
#	making safe	-	need to avoid `compress' on the cray.
#
ifeq "${Vendor}" "cray"
define MakeSafe
rm -f .safe .safe.Z
ar rv .safe ${SafeFiles}
mv .safe .safe.Z
chmod ugo-w .safe.Z
endef
else
define MakeSafe
rm -f .safe .safe.Z
ar rv .safe ${SafeFiles}
compress .safe
chmod ugo-w .safe.Z
endef
endif
