/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _ArgSys_h
#define _ArgSys_h
/*
    everything needed to use the argsys package
           Rick Cook    1-11-90
*/

#if defined( SOLARIS ) || defined( CONVEXSYSTEM )
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef _NO_PROTO
    extern char   *argstr_c();
    extern int    argi4_c();
    extern int    argi8_c();
    extern float  argr4_c();
    extern double argr8_c();
    extern int    argis_c();
#else
#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
    extern "C" {
#endif
    extern char   *argstr_c( char *, char *, char *, char *, int *, char ** );
    extern int    argi4_c( char *, int *, int, int, int *, char ** );
    extern int    argi8_c( char *, long *, long, long, int *, char ** );
    extern float  argr4_c( char *, float *, double, double, int *, char ** );
    extern double argr8_c( char *, double *, double, double, int *, char ** );
    extern int    argis_c( char *, int *, char ** );
#if defined(__cplusplus) || defined(c_plusplus)		/* C++ Prototype Only */
}
#endif

#endif	/* End of ANSI C or C++ function prototypes. */
#endif	/* _ArgSys_h */
